/**
 * Copyright yangliu9812 ( http://wonderfl.net/user/yangliu9812 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mpjh
 */

// forked from WLAD's forked from: forked from: chrysanthemum ベクタースキャンっぽくしてみた
// forked from k0rin's forked from: chrysanthemum ベクタースキャンっぽくしてみた
// forked from mari's chrysanthemum
package {
    import flash.display.*;
    import flash.events.Event;
    import flash.filters.*;
    import flash.geom.*;
    import flash.utils.*;

    [SWF(width = "465", height = "465", backgroundColor = "#000000", frameRate = "30")]
    public class Chrysanthemum extends Sprite {
        private const WIDTH:Number = stage.stageWidth;
        private const HEIGHT:Number = stage.stageHeight;
        
        private var base:Sprite = new Sprite();
        private var bitmapData:BitmapData = new BitmapData(WIDTH, HEIGHT, false, 0x0);
        private var grid:Shape = new Shape();
        
        private const CENTER_X:Number = WIDTH / 2;
        private const CENTER_Y:Number = HEIGHT / 2;
        private var centeringMatrix:Matrix = new Matrix();
    
        private const ELECTRON_NUMBER:int = 20;
        private var electrons:Array = new Array();
    
        public var v:Array = new Array();
    
        public function Chrysanthemum():void {
                        
                        
    
            var pt:Point = new Point();
            // キクの花
            var N:int = 2000;
            var u:Number = 0.0, r:Number = 0.0, p4:Number = 0.0, p8:Number = 0.0;
            for(var i:int=0; i<=N; i++) {
                u = i*21.0*Math.PI/N;
                p4 = Math.sin(17*u/3);
                p8 = Math.sin(2*Math.cos(3*u) - 28*u);
                r = 5*(1 + Math.sin(11*u/5)) - 4*Math.pow(p4, 4)*Math.pow(p8, 8);
                pt.x = r*Math.cos(u)*22;
                pt.y = r*Math.sin(u)*22;
                v.push(pt.clone());
            }

            base.x = CENTER_X;
            base.y = CENTER_Y;
            addChild(base);
            
            var bitmap:Bitmap = new Bitmap(bitmapData);
            bitmap.x = -CENTER_X;
            bitmap.y = -CENTER_Y;
            bitmap.filters = [ new GlowFilter(0x00FF00, 1, 8, 8) ];
            base.addChild(bitmap);
            
            centeringMatrix.translate(CENTER_X, CENTER_Y);
            
            for (i = 0; i < ELECTRON_NUMBER; i++) {
                var electron:Electron = new Electron(this, N * i / ELECTRON_NUMBER);
                electrons.push(electron);
                base.addChild(electron.body);
            }
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            
            // グリッドで雰囲気作り
            var g:Graphics = grid.graphics;
            g.lineStyle(1, 0x00FF00, 0.2);
            const GRID_SIZE:Number = 100;
            for (var iy:Number = GRID_SIZE * 0.4; iy < HEIGHT; iy += GRID_SIZE) {
                g.moveTo(0, iy);
                g.lineTo(stage.stageWidth, iy);
            }
            for (var ix:Number = GRID_SIZE * 0.2; ix < WIDTH; ix += GRID_SIZE) {
                g.moveTo(ix, 0);
                g.lineTo(ix, stage.stageHeight);
            }
            addChild(grid);
        }
        
        private function enterFrameHandler(e:Event):void {
            //　回転させないほうがいいかな
                        //base.rotation += 0.2;
            
            bitmapData.colorTransform(bitmapData.rect, new ColorTransform(1, 1, 1, 0.93));
            
            for each (var electron:Electron in electrons) {
                electron.update();
            }
        }
        
        public function draw(shape:Shape):void {
            bitmapData.draw(shape, centeringMatrix);
        }
    }
}

import flash.display.*;
import flash.geom.*;

class Electron {
    private var parent:Chrysanthemum;
    
    private var x:Number;
    private var y:Number;
    private var nextVertex:int;
    internal var body:Shape;
    
    private const SPEED:Number = 6;
    private const SPLIT:int = 4;
    
    function Electron(parent:Chrysanthemum, vertex:int) {
        this.parent = parent;
        
        x = parent.v[vertex].x;
        y = parent.v[vertex].y;
        this.nextVertex = vertex + 1;
        
        body = new Shape();
        var g:Graphics = body.graphics;
        
        const RADIUS:Number = 20;
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(RADIUS * 2, RADIUS * 2, 0, -RADIUS, -RADIUS);
        g.beginGradientFill(GradientType.RADIAL, [ 0x88FFEE, 0x00FF88, 0x00FF88 ], [ 1, 0.5, 0 ], [ 48, 64, 255 ], matrix);
        g.drawCircle(0, 0, RADIUS);
        g.endFill();
    }
    
    static private var shape:Shape = new Shape();

    public function update():void {
        shape.graphics.clear();
        shape.graphics.lineStyle(2, 0x00FFFF);
        shape.graphics.moveTo(x, y);
        
        for (var i:int = 0; i < SPLIT; i++) {
            var destX:Number = parent.v[nextVertex].x;
            var destY:Number = parent.v[nextVertex].y;
            var dx:Number = destX - x;
            var dy:Number = destY - y;
            var length:Number = Math.sqrt(dx * dx + dy * dy);
            x += dx / length * SPEED;
            y += dy / length * SPEED;
            var tx:Number = destX - x;
            var ty:Number = destY - y;
            if (tx * tx + ty * ty < SPEED * SPEED) {
                x = destX;
                y = destY;
                if (++nextVertex >= parent.v.length) {
                    nextVertex = 0;
                }
            }
            shape.graphics.lineTo(x, y);
        }
        parent.draw(shape);
        
        body.x = x;
        body.y = y;
    }
}

