/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mpZa
 */

package
{
    import net.hires.debug.*;
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;   

    [SWF(frameRate = 60, width = 465, height = 465)]
    public class Instance extends Sprite
    {
        internal var image1 :ImageBuffer;
        internal var image2 :ImageBuffer;       
        internal var image3 :ImageBuffer;
        internal var image4 :ImageBuffer;
        internal var sTrace :Text_Output;
        
        
        public function Instance()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            image1 = new ImageBuffer(Resources.URL3, true, 200,200);
            //image2 = new ImageBuffer(Resources.URL2, true, 75, 125, 200, 200);
        }
        
        public function _init() :void
        {
            graphics.clear     ();
            graphics.lineStyle (1, 0, 0.75);
            graphics.drawRect  (0, 0, 464, 464);
        }
        
        public function addedToStage($e:Event) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            addChild(image1);
            
            _init();

            addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
        }
        
        internal var ptObj :Object;
        internal var oldPt :Point = new Point();
        internal var newPt :Point = new Point();
        internal var clcPt :Point = new Point();

        public function onMouseDown($e:MouseEvent) :void
        {
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            
            if ($e.target != this) {ptObj = $e.target}
            oldPt = new Point($e.stageX, $e.stageY);   
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        }
        
        public function onMouseMove($e:MouseEvent) :void
        {
            newPt = new Point($e.stageX, $e.stageY);
            clcPt = Point(newPt.subtract(oldPt));
            
            if (ptObj != null)
            {
                ptObj.x = (ptObj.x + clcPt.x);
                ptObj.y = (ptObj.y + clcPt.y);
            }

            oldPt = newPt;
        }
        
        public function onMouseUp($e:MouseEvent) :void
        {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            
            var colArr :Array = CollisionHandler.detectCollision(Resources.colArr);
            
            if  (colArr.length > 0)
                {sTrace.content = "Overlap:\n" + colArr}else{sTrace.content = "Non-Overlap"}
        }
    }
}

import flash.display.*;
import flash.system.*;
import flash.events.*;
import flash.text.*;
import flash.net.*;

class CollisionHandler
{
    public static function detectCollision($arr:Array) :Array
    {
        var enumItems :Array = $arr;
        var detectedItems :Array = [];
        
        for (var $enum:Number = 0; $enum < enumItems.length; $enum++)
        {
            for (var $enum2:Number = 0; $enum2 < enumItems.length; $enum2++)
            {
                if ((enumItems[$enum] != enumItems[$enum2]) && (enumItems[$enum].hitTestObject(enumItems[$enum2])))
                {
                    detectedItems.push(enumItems[$enum].parent);
                }
            }
        }
        
        return detectedItems;
    }
}

class ImageBuffer extends Sprite
{
    private var preloader :Preloader;

    protected var _url    :String;
    protected var _x      :Number;
    protected var _y      :Number;
    protected var _width  :Number;
    protected var _height :Number;
    protected var _alpha  :Number;
    protected var _state  :Boolean;
    
    public function ImageBuffer($url:String, $pre:Boolean, $x:Number = 1, $y:Number = 1, $w:Number = 100, $h:Number = 100, $a:Number = 0.9)
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);

        _url    = $url;
        _state  = $pre;
        _x      = $x;
        _y      = $y;
        _width  = $w;
        _height = $h;
        _alpha  = $a;
        
        preloader = new Preloader(this, url, _state);
    }
    
    public function _init() :void
    {   
        alpha = alpha;
        if (preloader.state)
        {
            preloader.x = x;
            preloader.y = y;
            preloader.width = width;
            preloader.height = height;            
        }
        
        if (url != preloader.url)
           {for (var i:int = 0; i < numChildren; i++)
                {if (getChildAt(i) == preloader) {preloader.url = url}}}
    }
    
    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        mouseChildren = false

        addChild(preloader);
        
        _init();
    }

    public function get url() :String
    { return _url }
    public override function get x() :Number
    { return _x }
    public override function get y() :Number
    { return _y }
    public override function get width() :Number
    { return _width }
    public override function get height() :Number
    { return _height }
    public override function get alpha() :Number
    { return _alpha }
    public function set url($value:String) :void
    { _url = $value; _init(); }
    public override function set x($value:Number) :void
    { _x = $value; _init(); }
    public override function set y($value:Number) :void
    { _y = $value; _init(); }
    public override function set width($value:Number) :void
    { _width = $value; _init(); }
    public override function set height($value:Number) :void
    { _height = $value; _init(); }
    public function set trans($value:Number) :void
    { _alpha = $value; _init(); }
}

class Preloader extends Loader
{
    private var preBG :Sprite = new Sprite;
    private var preFG :Sprite = new Sprite;

    //background
    private var BG_x :Number;
    private var BG_y :Number;
    private var BG_w :Number;
    private var BG_h :Number;
    private var BG_a :Number;
    
    //foreground
    private var FG_x :Number;
    private var FG_y :Number;
    private var FG_w :Number;
    private var FG_h :Number;
    private var FG_a :Number;
    
    protected var _obj :Object; //so we can add our children
    protected var _url :String;
    protected var _pre :Boolean;
    protected var _ste :Boolean;
    
    public function Preloader($obj:Object, $url:String, $pre:Boolean)
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _obj = $obj;
        _url = $url;
        _pre = $pre;
        _ste = false;
        
        var bgWidth  :Number = (_obj.width * 0.66);
        var bgHeight :Number = (60);
        
        BG_x = (_obj.x + (_obj.width / 2) - (bgWidth / 2));
        BG_y = (_obj.y + (_obj.height / 2) - (bgHeight / 2));
        BG_w = (bgWidth);
        BG_h = (bgHeight);
        BG_a = (0.5);
        
        FG_x = (BG_x + 4);
        FG_y = (BG_y + 4);
        FG_w = (0);
        FG_h = (BG_h - 8);
        FG_a = (0.75);
    }
    
    public function _init() :void
    {
        _obj.addChild(preBG);
        _obj.addChild(preFG);        
        
        if (_pre)
        {
            contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, onLoaderProgress);
            contentLoaderInfo.addEventListener(Event.COMPLETE, onLoaderComplete);
            
            BG_a = (0.5);
            FG_a = (0.75);
            FG_w = (0);
            _initBG();
            _initFG();
        }
        
        contentLoaderInfo.addEventListener(Event.COMPLETE, onLoaderComplete);
        
        load(new URLRequest(_url), new LoaderContext(true));
    }
    
    public function _initBG() :void
    {
        preBG.graphics.clear         ();
        preBG.graphics.lineStyle     (4, 0xFFFFFF, BG_a);
        preBG.graphics.beginFill     (0, BG_a);
        preBG.graphics.drawRoundRect (BG_x, BG_y, BG_w, BG_h, 12);
        preBG.graphics.endFill       ();
    }
    
    public function _initFG() :void
    {
        preFG.graphics.clear         ();
        preFG.graphics.beginFill     (0xFFFFFF, FG_a);
        preFG.graphics.drawRoundRect (FG_x, FG_y, FG_w, FG_h, 6);
        preFG.graphics.endFill       ();
    }
    
    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);

        _init();
    }
    
    public function onLoaderProgress($e:ProgressEvent) :void
    {
        state = false;
        
        var loaderContext :Number = (BG_w - 8);    
        var deltaProgress :Number = ($e.bytesTotal > $e.bytesLoaded) ? ($e.bytesLoaded / $e.bytesTotal) : 0.01;
        
        loaderWidth = (deltaProgress * loaderContext);
    }
    
    public function onLoaderComplete($e:Event) :void
    {
        contentLoaderInfo.removeEventListener(ProgressEvent.PROGRESS, onLoaderProgress);
        contentLoaderInfo.removeEventListener(Event.COMPLETE, onLoaderComplete);
        
        state = true;
        
        //inherit our parent
        x = parent.x;
        y = parent.y;
        width = parent.width;
        height = parent.height;
        Resources.colArr.push(this);
        
        if (_pre) {addEventListener(Event.ENTER_FRAME, onEnterFrame);}
    }
        
    public function onEnterFrame($e:Event) :void
    {fadeOut()}
    
    public function fadeOut() :void
    {
        if   (FG_a > 0) {alpha -= 0.025;}
        else {removeEventListener(Event.ENTER_FRAME, onEnterFrame); parent.removeChild(preBG); parent.removeChild(preFG);}
    }

    public function get url() :String
    { return _url }
    public function get state() :Boolean
    { return _ste }
    public override function get alpha() :Number
    { return FG_a } //because foreground alpha is, by default, a greater quantity
    public function set url($value:String) :void
    { _url = $value; _init(); }
    public function set state($value:Boolean) :void
    { _ste = $value; }
    public override function set alpha($value:Number) :void
    { BG_a = FG_a = $value; _initBG(); _initFG(); } //background alpha will increase, by inheriting foreground's alpha (since background alpha is, by default, less of a quantity
    public function set loaderWidth($value:Number) :void
    { FG_w = $value; _initFG(); }
}

class Text_Output extends TextField
{
    private var textFormat :TextFormat;
    
    protected var _content :String;
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    
    public function Text_Output($content:String, $x:Number = 0, $y:Number = 0, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _content = $content;
        _x = $x;
        _y = $y;
        _font = $font;
        
        multiline = true;
        autoSize = "left";
        selectable = mouseEnabled = false;
        antiAliasType = AntiAliasType.ADVANCED;
    }
    
    public function _init() :void
    {
        text = _content;
        x = _x;
        y = _y;
        
        textFormat = new TextFormat(_font);
        setTextFormat(textFormat);
    }
    
    public function addedToStage($e:Event) :void
    {
       removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
       
       _init(); 
    }
    
    public function get font() :String
    { return _font }
    public function get nWidth() :Number
    { return width }
    
    public function set font($:String) :void
    { _font = $; _init(); }
    public function set content($:String) :void
    { _content = $; _init(); }
}

class Resources
{
    public static var colArr :Array = [];
    
    public static const URL1 :String = "http://i609.photobucket.com/albums/tt178/g500pb/album%202/fl_03c9fb5c6b66afa37b6c5de5aedd2c2e.jpg";
    public static const URL2 :String = "http://i609.photobucket.com/albums/tt178/g500pb/album%202/fl_04c6906524cd877e833fe26ddaddc62f.jpg";
    public static const URL3 :String = "http://www.wallpaperup.com/uploads/wallpapers/2012/09/10/13699/6e07ade0cfe8ec9f84fd2d4b3fa7fe60.jpg";
    public static const URL4 :String = "fake.png";
    public static const URL5 :String = "";
}