/**
 * Copyright EGO ( http://wonderfl.net/user/EGO )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mpCv
 */

// photo by:
// http://www.flickr.com/photos/wili/214317898/ (by 5656life)
package {
    import flash.display.*;
    import flash.net.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.system.Security;
    import flash.system.LoaderContext;
    
    import org.libspark.thread.Thread;
    import org.libspark.thread.EnterFrameThreadExecutor;

    public class FlashTest extends Sprite {
        private var motoSize:Number = 500;
        private var motoBmd:BitmapData;
        private var picSize:Number = 5;
        private var base:BaseImg;
        
        private var DefBitmap:Bitmap;
        
        private var bImg:BaseImg;
        private var thread:MainThread;
        
        public function FlashTest() {
            if (!Thread.isReady) {
                Thread.initialize(new EnterFrameThreadExecutor());
            }


            Security.loadPolicyFile("http://api.flickr.com/crossdomain.xml");
            Security.loadPolicyFile("http://farm5.static.flickr.com/crossdomain.xml");
            var myLoaderContext:LoaderContext = new LoaderContext(true);
            var tURL:String = "http://farm5.static.flickr.com/4106/5059597752_6da94b354b_z.jpg";
            var urImage:URLRequest = new URLRequest(tURL);
            var imgLoader:Loader = new Loader();
            imgLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageLoaded);
            imgLoader.load(urImage);
        }
        private function onImageLoaded(e:Event):void {
            DefBitmap = e.target.content;
            motoBmd = new BitmapData(motoSize, motoSize);
            var bai:Number = motoSize / Math.min(DefBitmap.width, DefBitmap.height);
            var idoX:Number = 0;
            var idoY:Number = 0;
            if (DefBitmap.width > DefBitmap.height) {
                idoX = -bai * (DefBitmap.width - DefBitmap.height) / 2;
            }else {
                idoY = -bai * (DefBitmap.height - DefBitmap.width) / 2;
            }
            var mat:Matrix = new Matrix(bai, 0, 0, bai, idoX, idoY);
            var rct:Rectangle = new Rectangle(0, 0, bai * Math.min(DefBitmap.width, DefBitmap.height), bai * Math.min(DefBitmap.width, DefBitmap.height));
            motoBmd.draw(DefBitmap, mat, null, null, rct, false);
            
            base = new BaseImg(motoBmd, motoSize, motoSize, picSize);
            base.addEventListener(BaseImg.HAS_LOAD, Kaiseki);
            base.ColorAnalysis();
        }
        
        private function Kaiseki(e:Event):void {
            bImg = base;
            base.removeEventListener(BaseImg.HAS_LOAD, Kaiseki);
            motoBmd.dispose();
            thread = new MainThread(stage,bImg,picSize);
            thread.start();
        }
    }
}
import flash.display.Stage;
import flash.display.Graphics; 
//-------------------------------------------------------------
//MainThread
//そうめん処理クラス
//-------------------------------------------------------------

import flash.display.Sprite;
import flash.display.Shape;
import org.libspark.thread.Thread;
import org.libspark.thread.threads.tweener.TweenerThread;

internal class MainThread extends Thread {
    private var _stage:Stage;
    private var nLine:int = 0;
    private var nCol:int = 0;
    private var bImg:BaseImg;
    private var picSize:int
    public function MainThread(stage:Stage,bBitmap:BaseImg,_picSize:int) {
        _stage = stage;
        bImg = bBitmap;
        picSize = _picSize;
    }
    override protected function run():void{
        for (var i:int = 0; i < bImg.redValue[nCol].length; i++){
            var chkBM:MovieClip = new MovieClip();
            var bColor:uint = 0;
            var gray:Number = (bImg.redValue[i][nCol] * 0.298912) + (bImg.greenValue[i][nCol] * 0.586611) + (bImg.blueValue[i][nCol] * 0.114478);
            gray = Math.floor(gray);
            bColor = (gray << 16) | (gray << 8) | gray;
            var shape:Shape = new Shape();
            var g:Graphics = shape.graphics;
            chkBM.addChild(shape);
            g.lineStyle(0, 0x000000, 0);
            g.beginFill(bColor, 1.0);
            g.drawCircle(picSize / 2, picSize / 2 , picSize);
            chkBM.width = chkBM.height = picSize;
            chkBM.x = i * picSize;
            chkBM.y = nCol * picSize;
            chkBM.alpha = 1;
            _stage.addChild(chkBM);
        }
        nCol++;
        if (nCol != bImg.redValue.length) {
            sleep(1);
            next(run);
        }
    }
}
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.MovieClip;    
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.geom.Matrix;
import flash.geom.Rectangle;
internal class BaseImg extends MovieClip{    
    
        private var displaySize:Number;
        private var motoSize:Number;
        
        public var redValue:Array = new Array();
        public var greenValue:Array = new Array();
        public var blueValue:Array = new Array();
        public var picSize:Number;
        
        private var motoBmd:BitmapData;
        
        public var maxNum:Number = (displaySize / picSize) * (displaySize / picSize);
        
        public static const HAS_LOAD:String = "hasLoad";
        
        public function BaseImg (path:BitmapData, dSize:Number, mSize:Number, pxSize:Number) {
            motoBmd = path;
            displaySize = dSize;
            picSize = pxSize;
            motoSize = mSize;
        }
        public function ColorAnalysis():void {
                        
            for (var i:Number = 0; i < motoBmd.width; i += picSize) {
                redValue.push(new Array());
                greenValue.push(new Array());
                blueValue.push(new Array());
                for (var j:Number = 0; j < motoBmd.height; j += picSize) {
                    var col:AverageColor = new AverageColor(motoBmd, i, j, picSize, picSize);
                    redValue[redValue.length - 1].push(col.red);
                    greenValue[greenValue.length - 1].push(col.green);
                    blueValue[blueValue.length - 1].push(col.blue);
                    col = null;
                }
            }
            EndLoad();
        }
        
        private function EndLoad():void {
            motoBmd.dispose();
            motoBmd = null;
            dispatchEvent(new Event(HAS_LOAD));
        }
}
import flash.display.BitmapData;
import flash.display.MovieClip;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.events.Event;
internal class AverageColor{
    
        
        public var red:Number;
        public var green:Number;
        public var blue:Number;    
        
        public function AverageColor(bmd:BitmapData, xx:Number, yy:Number, wi:Number, he:Number){
            var rect:Rectangle = new Rectangle(xx, yy, wi, he);
            var pos:Point = new Point(0, 0);
            var sliceBMD:BitmapData = new BitmapData(wi, he, false, 0xFFFFFF);
            sliceBMD.copyPixels(bmd, rect, pos);
                    
            var BMD:BitmapData = new BitmapData(1, 1, false);
            var Mtx:Matrix = new Matrix();
            Mtx.scale(1 /wi, 1 / he);
            BMD.draw(sliceBMD, Mtx);                
            var imgData:Number = BMD.getPixel(0, 0);
            
            this.red = (imgData >> 16) & 0xFF;
            this.green = (imgData >>  8) & 0xFF;
            this.blue = (imgData >>  0) & 0xFF;
            
            sliceBMD.dispose();
            sliceBMD = null;
            
            BMD.dispose();
            BMD = null;
            
        }
}