/**
 * Copyright ffffine ( http://wonderfl.net/user/ffffine )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/moVt
 */

package 
{
	import com.bit101.components.HSlider;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.ColorTransform;
	import flash.utils.getTimer;

    [SWF(width = 465, height = 465, backgroundColor = 0x0, frameRate = 30)]	
	
	/**
	 * バラ曲線
	 * @author ffffine
	 */
	public class Main extends Sprite 
	{
		private var _max:uint = 60;
		private var _list:Array = [];
		private var _slider:HSlider;
		private var _bmpdata:BitmapData;
		private var _colorTransform:ColorTransform;
		private var _container:Sprite;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			_slider = new HSlider(this, 120, stage.stageHeight - 20, change);
			_slider.minimum = 3;
			_slider.maximum = 30;
			_slider.value = 11;
			_slider.setSize(stage.stageWidth - 240, 8);
			setUpCirlcle();
			addChildAt(_slider, numChildren-1);
			addEventListener(Event.ENTER_FRAME, change);
		}
		
		private function setUpCirlcle():void
		{
			_container = addChild(new Sprite()) as Sprite;
			for (var i:int = 0; i < _max; i++) 
			{
				var circle:Circle = new Circle();
				_container.addChild(circle);
				_list.push(circle);
			}
			_bmpdata  = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x0);
			var bitmap:Bitmap = new Bitmap(_bmpdata);
			_colorTransform = new ColorTransform(0.99, 0.99, 0.99);
			addChildAt(bitmap, 0);			
			var bg:Shape = new Shape();
			bg.graphics.clear();
			bg.graphics.beginFill(0x0);
			bg.graphics.drawRect(0, 0, 465, 465);
			bg.graphics.endFill();
			addChildAt(bg,0);
		}
		
		private function change(e:Event = null):void
		{
			for (var i:int = 0; i < _max; i++) 
			{
				var rot:Number = i * 180 / _max ;
				_list[i].scaleX = _list[i].scaleY = (Math.sin(getTimer() / 2000) * 1 + 3);
				_list[i].x = (Math.sin(getTimer()/2000)*465/2) * (Math.sin(_slider.value * ((rot + getTimer()/50) * Math.PI / 180))* Math.cos(rot*Math.PI/180)) + stage.stageWidth/2;
				_list[i].y = (Math.sin(getTimer()/2000)*465/2) * (Math.sin(_slider.value * ((rot + getTimer()/50)  * Math.PI / 180))* Math.sin(rot*Math.PI/180)) + stage.stageHeight/2;				
			}
			_bmpdata.draw(_container);
			_bmpdata.colorTransform(_bmpdata.rect,_colorTransform);
		}
		
	}
	
}
import flash.display.Shape;
import frocessing.color.ColorHSV;

class Circle extends Shape {
	public static var num:int = 180;
	
	public function Circle () {
		var colorHSV:ColorHSV = new ColorHSV(num, 0.9, 0.9);
		graphics.clear();
		//graphics.lineStyle(1, colorHSV.value);
		graphics.beginFill(colorHSV.value, 1);
		graphics.drawCircle(0, 0, 2);
		graphics.endFill();
		num += 6;
	}
	
}