/**
 * Copyright takishiki ( http://wonderfl.net/user/takishiki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mo7K
 */

/*
MouseEvent.CLICK
画面をクリックする度に白黒反転
*/
package {
    import flash.display.Graphics;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    
    public class FlashTest extends Sprite {
        // 変数
        private var _color:uint; // 描画色
        
        // コンストラクタ
        public function FlashTest() {
            _color = 0xFFFFFF; // 最初は白
            
            var sprite:Sprite = new Sprite();
            paintRect(sprite.graphics, 0, 0, stage.stageWidth, stage.stageHeight, _color);
            sprite.buttonMode = true; // 
            addChild(sprite);
            
            sprite.addEventListener(MouseEvent.CLICK, onClick);
        }
        
        // クリック時に実行
        private function onClick(event:MouseEvent):void{
            _color ^= 0xFFFFFF; // 白黒反転
            paintRect(event.target.graphics, 0, 0, stage.stageWidth, stage.stageHeight, _color);
        }
        
        // 描画
        private function paintRect(g:Graphics, x:int, y:int, w:int, h:int, color:uint):void{
            g.clear(); // 描画消去
            g.lineStyle(); // 線なし
            g.beginFill(color); // 塗りつぶし開始
            g.drawRect(x, y, w, h); // 四角描画
            g.endFill(); // 塗りつぶし終了
        }


    }
}