/**
 * Copyright matacat ( http://wonderfl.net/user/matacat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mnqJ
 */

package
{
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    public class IrregularCircle extends Sprite
    {
        private var lineCanvas:Shape;
        private var g:Graphics;
        private var points:Vector.<Sprite>;
        private var center:Vector.<Vector.<Number>>;
        private var colors:Vector.<uint>;
        private var division:int;
        private var dispMode:int;
        
        
        public function IrregularCircle()
        {
            lineCanvas = new Shape();
            addChild(lineCanvas);
            
            g = lineCanvas.graphics;
            
            points = new Vector.<Sprite>();
            for (var i:int = 0; i < 4; i++) {
                points[i] = new Sprite();
                points[i].buttonMode = true;
                
                points[i].graphics.lineStyle(0, hsv2rgb(90 * i, 1, 0.25));
                points[i].graphics.beginFill(hsv2rgb(90 * i, 1, 0.4), 0.5);
                points[i].graphics.drawCircle(0, 0, 6);
                
                points[i].x = Math.cos((i * 2 - 1) / 4 * Math.PI) * 200 + stage.stageWidth / 2;
                points[i].y = Math.sin((i * 2 - 1) / 4 * Math.PI) * 200 + stage.stageHeight / 2;
                addChild(points[i]);
            }
            
            center = new Vector.<Vector.<Number>>();
            
            colors = new Vector.<uint>();
            for (i = 0; i < 4; i++) colors[i] = hsv2rgb(45 + 90 * i, 1, 0.25);
            
            division = 6;
            
            dispMode = 0;
            
            stage.doubleClickEnabled = true;
            update();
            
            
            stage.addEventListener(MouseEvent.DOUBLE_CLICK, function(e:MouseEvent):void
            {
                dispMode++;
                if (dispMode > 2) dispMode = 0;
                update();
            });
            
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void
            {
                if (e.target != stage) e.target.startDrag();
                stage.addEventListener(Event.ENTER_FRAME, update);
            });
            
            
            stage.addEventListener(MouseEvent.MOUSE_UP, function(e:MouseEvent):void
            {
                for (i = 0; i < 4; i++) points[i].stopDrag();
                stage.removeEventListener(Event.ENTER_FRAME, update);
            });
        }
        
        
        private function update(e:Event = null):void
        {
            var a:Number, b:Number, c:Number, d:Number;
            
            g.clear();
            
            for (var i:int = 0; i < 4; i++) {
                a = points[i].x;
                b = points[i].y;
                c = points[i == 3 ? 0 : i + 1].x;
                d = points[i == 3 ? 0 : i + 1].y;
                
                g.lineStyle(2, colors[i]);
                g.moveTo(a, b);
                g.lineTo(c, d);
                
                center[i] = Vector.<Number>([ (a + c) / 2, (b + d) / 2 ]);
                
                g.lineStyle();
                g.beginFill(colors[i], 0.5);
                g.drawCircle(center[i][0], center[i][1], 3);
                g.endFill();
            }
            
            for (i = 0; i < 4; i++) {
                a = (points[i].x - center[i == 0 ? 3 : i - 1][0]) / division;
                b = (points[i].y - center[i == 0 ? 3 : i - 1][1]) / division;
                c = (center[i][0] - points[i].x) / division;
                d = (center[i][1] - points[i].y) / division;
                
                if(dispMode!=1){
                    for (var j:int = 1; j < division; j++) {
                        var mX:Number = a * j + center[i == 0 ? 3 : i - 1][0];
                        var mY:Number = b * j + center[i == 0 ? 3 : i - 1][1];
                        var nX:Number = c * j + points[i].x;
                        var nY:Number = d * j + points[i].y;
                        
                        g.lineStyle(0, 0x3F3F3F);
                        g.moveTo(mX, mY);
                        g.lineTo(nX, nY);
                        g.lineStyle();
                        
                        g.beginFill(0x5F5F5F, 0.5);
                        g.drawCircle((nX - mX) / division * j + mX, (nY - mY) / division * j + mY, 3);
                        g.endFill();
                    }
                }
                
                if (dispMode < 2) {
                    g.lineStyle(2, 0);
                    g.moveTo(center[i == 0 ? 3 : i - 1][0], center[i == 0 ? 3 : i - 1][1]);
                    g.curveTo(points[i].x, points[i].y, center[i][0], center[i][1]);
                }
            }
        }
        
        
        private function hsv2rgb(h:Number, s:Number, v:Number):uint
        {
            s = s > 1 ? 1 : (s < 0 ? 0 : s);
            v = v > 1 ? 1 : (v < 0 ? 0 : v);
            
            if (s == 0) return v * 0xFF << 16 | v * 0xFF << 8 | v * 0xFF << 0;
            
            h = h >= 360 ? h % 360 : (h < 0 ? h % 360 + 360 : h);
            
            var i:int = int(h / 60);
            var f:Number = h / 60 - i;
            var p:Number = v * (1 - s);
            var q:Number = v * (1 - s * f);
            var t:Number = v * (1 - s * (1 - f));
            
            switch (i) {
                case 0: return v * 0xFF << 16 | t * 0xFF << 8 | p * 0xFF << 0;
                case 1: return q * 0xFF << 16 | v * 0xFF << 8 | p * 0xFF << 0;
                case 2: return p * 0xFF << 16 | v * 0xFF << 8 | t * 0xFF << 0;
                case 3: return p * 0xFF << 16 | q * 0xFF << 8 | v * 0xFF << 0;
                case 4: return t * 0xFF << 16 | p * 0xFF << 8 | v * 0xFF << 0;
                case 5: return v * 0xFF << 16 | p * 0xFF << 8 | q * 0xFF << 0;
            }
            
            return 0;
        }
    }
}