/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mnai
 */

/*
参考
http://ja.wikipedia.org/wiki/星座占い
*/
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.text.TextField;
	/**
	 * ...
	 * @author umhr
	 */
	public class Main extends Sprite
	{
		private var tf:TextField;
		public function Main() {
			
			tf = new TextField();
			tf.text = "簡易ComboBoxのつもりで作ったけど、いつのまにか違うものにPert 2";
			tf.width = 465;
			tf.height = 22;
			addChild(tf);
			
			const TODOUFUKEN:Array = ["牡羊座","牡牛座","双子座","蟹座","獅子座","乙女座","天秤座","蠍座","射手座","山羊座","水瓶座","魚座"];
			
			var cbl:ComboBoxLite = new ComboBoxLite();
			cbl.move(180, 220);
			for (var i:int = 0; i < TODOUFUKEN.length; i++) {
				cbl.addItem( { label:String(TODOUFUKEN[i]) } );
			}
			cbl.selectedIndex = 0;
			cbl.onChange = onChange;
			addChild(cbl);
			
		}
		private function onChange(obj:Object):void {
			tf.text = obj.target.selectedIndex+","+obj.target.selectedItem.label;
		}
	}
}

///////////////////////////////////////ComboBoxLite
import flash.display.SimpleButton;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.text.TextField;
import flash.utils.Dictionary;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.events.TweenEvent;
/**
 * ...
 * @author umhr
 */
class ComboBoxLite extends Sprite {
	private var _selecterCanvas:Sprite;
	private var _sp:Sprite;
	private var _item:Array;
	private var _tf:TextField;
	private var _selectedIndex:int;
	private var _dictionary:Dictionary;
	public function ComboBoxLite() {
		_dictionary = new Dictionary();
		
		_tf = new TextField();
		_tf.border = true;
		_tf.width = 60;
		_tf.height = 22;
		_tf.selectable = false;
		this.addEventListener(MouseEvent.CLICK, _onClick);
		this.addChild(_tf);
		_dictionary[_tf] = {type:"open"};
		
		_sp = Create.newSprite( { alpha:0.1 }, Create.drawRect( { width:465, height:465 } ));
		_sp.visible = false;
		addChild(_sp);
		_dictionary[_sp] = {type:"close"};
		
		_selecterCanvas = new Sprite();
		_item = [];
		this.addChild(_selecterCanvas);
	}
	
	public function move(x:Number, y:Number):void {
		this.x = x;
		this.y = y;
		_sp.x = -x;
		_sp.y = -y;
	}
	public var onChange:Function = function(obj:Object):void { };
	private function _onClick(e:MouseEvent):void {
		while (_selecterCanvas.numChildren > 0) {
			_selecterCanvas.removeChildAt(0);
		}
		if (_dictionary[e.target] && _dictionary[e.target].type == "open") {
			_sp.visible = true;
			var n:int= _item.length;
			for (var i:int = 0; i < n; i++) {
				var sp:SimpleButton;
				if(i == selectedIndex){
					sp = Create.newSimpleButton( { text:" " + _item[i].label + " ", width : 50, height:21 ,color:0xFFCCCC} );
				}else {
					sp = Create.newSimpleButton( { text:" " + _item[i].label + " ", width : 50, height:21 } );
				}
				var nx:Number = Math.cos(Math.PI*2*i/n)*110;
				var ny:Number = Math.sin(Math.PI*2*i/n)*110;
				BetweenAS3.tween(sp,{x:nx,y:ny,alpha:1}, {x:nx*0.3,y:ny*0.3,alpha:0}, 0.2).play();
				_selecterCanvas.addChild(sp);
				_dictionary[sp] = { type:"block", num:i };
			}
		}else if (_dictionary[e.target] && _dictionary[e.target].type == "block") {
			selectedIndex = _dictionary[e.target].num;
			_sp.visible = false;
			onChange( { target:this } );
		}else {
			_sp.visible = false;
		}
	}
	
	public function addItem(item:Object):void {
		_item.push(item);
	}
	public function get selectedItem():Object {
		return _item[selectedIndex];
	}
	public function set selectedIndex(value:int):void {
		_selectedIndex = value;
		_tf.text = _item[value].label;
	}
	public function get selectedIndex():int {
		return _selectedIndex;
	}
}



///////////////////////////////////////汎用品
import flash.display.DisplayObject;
import flash.display.Graphics;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFormat;
import flash.display.Sprite;
import flash.display.Shape;
import flash.display.SimpleButton;
import flash.display.BitmapData;
import flash.display.Bitmap;

/**
 * DisplayObjectの子供たちを簡単に指定するためのクラス
 */
class Create{
	public static var defaultTextFormat:TextFormat = new TextFormat();
	
	public static function newSimpleButton(... args):SimpleButton {
		
		var propObj:Object = { x:0, y:0, width:0, height:0, color:0xFFFFFF, alpha:1, round:0, lineSize:0, lineColor:0, lineAlpha:1, ellipseWidth:0, ellipseHeight:0, text:"" };
		
		if(args){
			for (var i:int = 0; i < args.length; i++) {
				for (var str:String in args[i]) {
					propObj[str] = args[i][str];
				}
			}
		}
		
		if (propObj.text) {
			var tf:TextField = newTextField( { y:2, text:propObj.text, setTextFormat:[ { font:"_sans", align:"center" } ], autoSize:"center" } );
		}
		
		if (!(propObj.width)) {
			propObj.width = tf.width + 16;
		}
		if (!(propObj.height)) {
			propObj.height = tf.height + 4;
		}
		
		
		
		var upState:Sprite = newSprite( { x:propObj.x, y:propObj.y }, drawRect( { color:RGBtone(propObj.color,(0xCC/0xFF)), width:propObj.width, height:propObj.height, round:8 } ) );
		upState.addChild(newShape( { x:2, y:2 }, drawRect( { color:RGBtone(propObj.color,(0xE5/0xFF)), width:propObj.width - 4, height:propObj.height - 4, round:6 } )));
		var overState:Sprite = newSprite( { x:propObj.x, y:propObj.y }, drawRect( { color:RGBtone(propObj.color,(0xBB/0xFF)), width:propObj.width, height:propObj.height, round:8 } ));
		overState.addChild(newShape( { x:2, y:2 }, drawRect( { color:RGBtone(propObj.color,(0xEE/0xFF)), width:propObj.width - 4, height:propObj.height - 4, round:6 } )));
		var downState:Sprite = newSprite( { x:propObj.x, y:propObj.y }, drawRect( { color:RGBtone(propObj.color,(0xAA/0xFF)), width:propObj.width, height:propObj.height, round:8 } ));
		downState.addChild(newShape( { x:2, y:2 }, drawRect( { color:RGBtone(propObj.color,(0xDD/0xFF)), width:propObj.width - 4, height:propObj.height - 4, round:6 } )));
		var hitTestState:Shape = newShape( { x:propObj.x, y:propObj.y }, drawRect( { width:propObj.width, height:propObj.height, round:8 } ));
		if (propObj.text) {
			upState.addChild(newTextField({y:2,width:propObj.width,height:propObj.height-2,text:propObj.text,setTextFormat:[{font:"_sans",align:"center"}]}));
			overState.addChild(newTextField({y:2,width:propObj.width,height:propObj.height-2,text:propObj.text,setTextFormat:[{font:"_sans",align:"center"}]}));
			downState.addChild(newTextField({y:3,width:propObj.width,height:propObj.height-3,text:propObj.text,setTextFormat:[{font:"_sans",align:"center"}]}));
		}
		var sb:SimpleButton = new SimpleButton(upState, overState, downState, hitTestState);
		
		return sb;
	}
	
	private static function RGBtone(RGB:int, tone:Number):int {
		var r:int = RGB >> 16;//16bit右にずらす。 
		var g:int = RGB >> 8 & 0xff;//8bit右にずらして、下位8bitのみを取り出す 
		var b:int = RGB & 0xff;//下位8bitのみを取り出す
		r  = r * tone;
		g  = g * tone;
		b  = b * tone;
		r = r << 16;
		g = g << 8;
		return r+g+b;
	}
	
	
	/**
	 * drawRectを作ります。
	 * @example drawRwct({x:100,y:100,width:200,height:200});
	 * @return Object
	 * @default { x:0, y:0, width:100, height:100, color:0xFF0000, alpha:1, round:0, lineSize:0, lineColor:0, lineAlpha:1, ellipseWidth:0, ellipseHeight:0 };
	 */
	public static function drawRect(... args):Object {
		var propObj:Object = { x:0, y:0, width:100, height:100, color:0xFF0000, alpha:1, round:0, lineSize:0, lineColor:0, lineAlpha:1, ellipseWidth:0, ellipseHeight:0 };
		
		if(args){
			for (var i:int = 0; i < args.length; i++) {
				for (var str:String in args[i]) {
					propObj[str] = args[i][str];
				}
			}
		}
		if(!(propObj.ellipseWidth)){
			propObj.ellipseWidth = propObj.round;
		}
		if(!(propObj.ellipseHeight)){
			propObj.ellipseHeight = propObj.ellipseWidth;
		}
		
		var resultArray:Array = [];
		resultArray.push({ beginFill:[propObj.color, propObj.alpha] });
		if (propObj.lineSize > 0) {
			resultArray.push( { lineStyle:[propObj.lineSize, propObj.lineColor, propObj.lineAlpha] } );
		}
		if(propObj.round || propObj.ellipseWidth || propObj.ellipseHeight){
			resultArray.push( { drawRoundRect:[propObj.x, propObj.y, propObj.width, propObj.height, propObj.ellipseWidth, propObj.ellipseHeight] } );
		}else {
			resultArray.push( { drawRect:[propObj.x, propObj.y, propObj.width, propObj.height] } );
		}
		return { graphics:resultArray };
	}
	public static function drawCircle(... args):Object {
		var propObj:Object = { x:0, y:0, width:0, height:0, color:0xFF0000, alpha:1, r:100, radius:0, lineSize:0, lineColor:0, lineAlpha:1 };
		
		if(args){
			for (var i:int = 0; i < args.length; i++) {
				for (var str:String in args[i]) {
					propObj[str] = args[i][str];
				}
			}
		}
		if(!(propObj.radius)){
			propObj.radius = propObj.r;
		}
		if(!(propObj.width)){
			propObj.width = propObj.radius;
		}
		if(!(propObj.height)){
			propObj.height = propObj.radius;
		}
		
		var resultArray:Array = [];
		resultArray.push({ beginFill:[propObj.color, propObj.alpha] });
		if (propObj.lineSize > 0) {
			resultArray.push( { lineStyle:[propObj.lineSize, propObj.lineColor, propObj.lineAlpha] } );
		}
		if (propObj.width == propObj.height) {
			resultArray.push( { drawCircle:[propObj.x, propObj.y, propObj.radius] } );
		}else {
			resultArray.push( { drawEllipse:[propObj.x, propObj.y, propObj.width, propObj.height] } );
		}
		
		return { graphics:resultArray };
	}
	
	public static function newShape(... args):Shape {
		var sp:Shape;
		var str:String;
		var length:int = args.length;
		for (var i:int = 0; i < length; i++) {
			var obj:Object = args[i];
			if(i == 0){
				if(obj.Shape){
					sp = obj.Shape;
				}else{
					sp = new Shape();
				}
			}
			if(obj.graphics){
				for (var j:int = 0; j < obj.graphics.length; j++) {
					if(obj.graphics[j]){
						for (str in obj.graphics[j]) {
							sp.graphics[str].apply(null, obj.graphics[j][str]);
						}
					}
				}
			}
			for (str in obj) {
				if(str != "Shape" && str != "graphics"){
					sp[str] = obj[str];
				}
			}
		}
		return sp;
	}
	/**
	 * Spriteを作ります。
	 * @return Sprite
	 */
	public static function newSprite(... args):Sprite {
		var sp:Sprite;
		var str:String;
		var length:int = args.length;
		for (var i:int = 0; i < length; i++) {
			var obj:Object = args[i];
			if(i == 0){
				if(obj.Sprite){
					sp = obj.Sprite;
				}else{
					sp = new Sprite();
				}
			}
			if(obj.graphics){
				for (var j:int = 0; j < obj.graphics.length; j++) {
					if(obj.graphics[j]){
						for (str in obj.graphics[j]) {
							sp.graphics[str].apply(null, obj.graphics[j][str]);
						}
					}
				}
			}
			for (str in obj) {
				if(str != "Sprite" && str != "graphics" && str != "addChild"){
					sp[str] = obj[str];
				}
			}
			if(obj.addChild){
				sp.addChild(obj.addChild);
			}
		}
		return sp;
	}
	public static function newTextField(... args):TextField {
		var ta:TextField = new TextField();
		ta.defaultTextFormat = defaultTextFormat;
		var length:int = args.length;
		for (var i:int = 0; i < length; i++) {
			var obj:Object = args[i];
			for (var str:String in obj) {
				if(str != "setTextFormat"){
					ta[str] = obj[str];
				}
			}
			if(obj.setTextFormat){
				var format:TextFormat = new TextFormat();
				if(obj.setTextFormat[0] is TextFormat){
					format = obj.setTextFormat[0];
				}else{
					for (var tfstr:String in obj.setTextFormat[0]) {
						format[tfstr] = obj.setTextFormat[0][tfstr];
					}
				}
				ta.setTextFormat(format,isNaN(obj.setTextFormat[1])?-1:obj.setTextFormat[1],isNaN(obj.setTextFormat[2])?-1:obj.setTextFormat[2]);
			}
		}
		return ta;
	}
	
	public static function newBitmap(... args):Bitmap {
		var length:int = args.length;
		var bd:BitmapData;
		var bitmap:Bitmap;
		var strObj:Object = { width:100 , height:100, transparent:true, fillColor:0xFFFFFFFF , pixelSnapping:"auto", smoothing:false ,x:0 ,y:0};
		
		var tempDO:DisplayObject;
		for (var i:int = 0; i < length; i++) {
			var obj:Object = args[i];
			for (var str:String in obj) {
				if (str == "draw") {
					tempDO = obj[str];
					strObj.width = obj[str].width;
					strObj.height = obj[str].height;
				}else {
					strObj[str] = obj[str];
				}
			}
		}
		bd = new BitmapData(strObj.width, strObj.height, strObj.transparent, strObj.fillColor);
		
		if (tempDO) {
			bd.draw(tempDO)
		}
		bitmap = new Bitmap(bd, strObj.pixelSnapping, strObj.smoothing);
		bitmap.x = strObj.x;
		bitmap.y = strObj.y;
		return bitmap;
	}
}
