/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mnDz6
 */

// forked from siouxcitizen's Away3D練習2　3種類のMaterialでPlane表示
// forked from siouxcitizen's Away3D練習1　Plane表示
// forked from siouxcitizen's forked from: Away3Dの練習
// forked from ser1zw's Away3Dの練習

package {
  import flash.display.Sprite;
  import flash.events.Event;
  import flash.events.MouseEvent;
  
  import away3d.containers.View3D;
  import away3d.primitives.Sphere;
  import away3d.materials.WireColorMaterial;
  import away3d.materials.ColorMaterial;
  import away3d.materials.WireframeMaterial;

  [SWF(backgroundColor="#337777")]
  public class Away3DPlaneTest extends Sprite {
    private var view:View3D;

    private var sphereWithWireColorMaterial : Sphere;
    private var sphereWithColorMaterial : Sphere;
    private var sphereWithWireframeMaterial : Sphere;

    private var wireframeMaterial:WireframeMaterial;
    private var wireColorMaterial:WireColorMaterial;
    private var colorMaterial:ColorMaterial;

    public function Away3DPlaneTest() {
      view = new View3D();
      view.x = stage.stageWidth >> 1;
      view.y = stage.stageHeight >> 1;
      addChild(view);


      wireframeMaterial = new WireframeMaterial(0x00ff00);
      sphereWithWireframeMaterial = new Sphere({radius:50, segmentW:12, segmentH:9, y:100, x:0, z:0});
      sphereWithWireframeMaterial.material = wireframeMaterial
      view.scene.addChild(sphereWithWireframeMaterial);

      wireColorMaterial = new WireColorMaterial();
      wireColorMaterial.color = 0xff0000;
      wireColorMaterial.wireColor = 0xffff00;
      sphereWithWireColorMaterial = new Sphere({radius:50, segmentW:12, segmentH:9, y:-100, x:0, z:0});
      sphereWithWireColorMaterial.material = wireColorMaterial;
      view.scene.addChild(sphereWithWireColorMaterial);

      colorMaterial = new ColorMaterial();
      colorMaterial.color = 0x0000ff;
      sphereWithColorMaterial = new Sphere({radius:50, segmentW:12, segmentH:9, y:0, x:100, z:0});
      sphereWithColorMaterial.material = colorMaterial;
      view.scene.addChild(sphereWithColorMaterial);

      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }

    private function onEnterFrame(e:Event):void {
      view.scene.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
      view.scene.rotationY = stage.mouseX - (stage.stageWidth >> 1);

      sphereWithWireColorMaterial.rotationX += 3;
      sphereWithWireColorMaterial.rotationY += 3;

      sphereWithColorMaterial.rotationX += 3;
      sphereWithColorMaterial.rotationY += 3;

      sphereWithWireframeMaterial.rotationX += 3;
      sphereWithWireframeMaterial.rotationY += 3;

      view.render();
    }
  }
}
