/**
 * Copyright ton ( http://wonderfl.net/user/ton )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mmAl
 */

// forked from kawamura's 円形ランダム配置
package 
{
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    /**
     * ...
     * @author Jaiko
     */
    public class Main extends Sprite 
    {
        private var blue:Sprite;
        private var red:Sprite;
        private var green:Sprite;
        
        private const N:int = 10000;
        private const MAX_R:int = 200;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            var i:uint;
            var n:uint;
            var r:Number = 200;
            var theta:Number;
            var sprite:Sprite;
            var g:Graphics;
            
            var redButton:Sprite = new Sprite()
            addChild(redButton);
            g = redButton.graphics;
            g.beginFill(0xFF0000);
            g.drawRect(0, 0, 100, 20);
            redButton.x = 5;
            redButton.y = 5;
            redButton.addEventListener(MouseEvent.CLICK, redClickHandler);
            
            var blueButton:Sprite = new Sprite()
            addChild(blueButton);
            g = blueButton.graphics;
            g.beginFill(0x0000FF);
            g.drawRect(0, 0, 100, 20);
            blueButton.x = 110;
            blueButton.y = 5;
            blueButton.addEventListener(MouseEvent.CLICK, blueClickHandler);
            
            var greenButton:Sprite = new Sprite()
            addChild(greenButton);
            g = greenButton.graphics;
            g.beginFill(0x00FF00);
            g.drawRect(0, 0, 100, 20);
            greenButton.x = 215;
            greenButton.y = 5;
            greenButton.addEventListener(MouseEvent.CLICK, greenClickHandler);
            
            red = new Sprite();
            addChild(red);
            blue = new Sprite();
            addChild(blue);
            green = new Sprite();
            addChild(green);
            
            //赤色配置　半径と角度をランダム配置処理
            for (i = 0; i < N; i++)
            {
                sprite = new Sprite();
                red.addChild(sprite);
                g = sprite.graphics;
                g.beginFill(0xFF0000);
                g.drawCircle(0, 0, 1);
                r = MAX_R * Math.random();
                theta = 2 * Math.PI * Math.random();
                sprite.x = stage.stageWidth * 0.5 + r * Math.cos(theta);
                sprite.y = stage.stageHeight * 0.5 + r * Math.sin(theta);
            }
            
            //XYに配置。半径内にないものは再配置処理
            for (i = 0; i < N; i++)
            {
                sprite = new Sprite();
                blue.addChild(sprite);
                g = sprite.graphics;
                g.beginFill(0x0000FF);
                g.drawCircle(0, 0, 1);
                checkPosition(sprite);
            }
            
            //半径として，sqrtにrandom()を与えると綺麗に配置できる
            for (i = 0; i < N; i++)
            {
                sprite = new Sprite();
                green.addChild(sprite);
                g = sprite.graphics;
                g.beginFill(0x00FF00);
                g.drawCircle(0, 0, 1);
                r = Math.sqrt(Math.random()) * MAX_R;
                theta = 2 * Math.PI * Math.random();    
                sprite.x = stage.stageWidth * 0.5 + r * Math.cos(theta);
                sprite.y = stage.stageHeight * 0.5 + r * Math.sin(theta);          
            }
            
            
            blue.visible = false;
        }
        
        private function blueClickHandler(e:MouseEvent):void 
        {
            blue.visible = !blue.visible;
        }
        
        private function redClickHandler(e:MouseEvent):void 
        {
            red.visible = !red.visible;
        }
        
        private function greenClickHandler(e:MouseEvent):void 
        {
            green.visible = !green.visible;
        }
                
        private function checkPosition(sprite:Sprite):void 
        {
            var d:Number
            sprite.x = stage.stageWidth * 0.5 + MAX_R - 2*MAX_R * Math.random();
            sprite.y = stage.stageWidth * 0.5 + MAX_R - 2*MAX_R * Math.random();
            d = Math.sqrt(Math.pow(stage.stageWidth * 0.5 - sprite.x, 2) + Math.pow(stage.stageHeight * 0.5 - sprite.y, 2));
            if (d > MAX_R)
            {
                //半径内にないので再配置。回数制限などしたほうがいいかもね。
                checkPosition(sprite);
            }
            
        }
        
    }
    
}