/**
 * Copyright takky31yrzy ( http://wonderfl.net/user/takky31yrzy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mm4T
 */

// forked from gupon's Search on YouTube
package {
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.utils.escapeMultiByte;
    
    [SWF(width=465,height=465,frameRate=60)]
    public class YouTubePlayer extends Sprite{
        private static const PLAYER_URL:String = "http://www.youtube.com/apiplayer?version=3";
        private static const YOUTUBE_DOMAIN:String = "www.youtube.com";
        private static const SEARCH_URL_BASE:String = "http://gdata.youtube.com/feeds/api/videos?vq=";
        private var player:Object;
        private var loader:Loader;
        private var box:SearchBox; 
    
        
        public function YouTubePlayer() {
            setBlack();
            setPlayer();
            addChild( box = new SearchBox( this ));
            
            addEventListener( Event.ADDED_TO_STAGE, function( event:Event ):void{
                box.setFocus();
            });
        }
        
        public function search( keyword:String ):void{
            keyword.replace(" ", "+")
            keyword.replace("　", "+")
            treasureHunt( escapeMultiByte( keyword ) );
        }
        
        private function setBlack():void{
            graphics.beginFill(0);
            graphics.drawRect( 0, 0, 465, 465 );
        }
        
        private function setPlayer():void{
            Security.allowDomain(YOUTUBE_DOMAIN);
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener( Event.INIT, loaderInitHandler );
            loader.contentLoaderInfo.addEventListener( IOErrorEvent.IO_ERROR, function( event:IOErrorEvent ):void{
                loader.load( new URLRequest(PLAYER_URL));
            });
            loader.load( new URLRequest(PLAYER_URL));
        }
        
        private function loaderInitHandler( event:Event ):void{
            addChildAt( loader, 0 );
            loader.content.addEventListener( "onReady", function( event:Event ):void{
                player = loader.content;
                player.setSize( 465, 465 );
                search("dannybyrd");
                
            });
        }
        
        private function treasureHunt( keyword:String ):void{
            var maxResults:String = "&max-results=" + 1;
            var url:String = SEARCH_URL_BASE + keyword + maxResults;
            var xmlLoader:URLLoader = new URLLoader();
            xmlLoader.addEventListener( Event.COMPLETE, function( event:Event ):void{
                default xml namespace = new Namespace("http://www.w3.org/2005/Atom");
                var str:String = String( xmlLoader.data ).substr( 38 );
                var id:String = String( XML( str ).entry.id ).split("/").pop();
                player.loadVideoById(id);
            });
            xmlLoader.load( new URLRequest( url ));
        }
        
        
    }
}


////////////////////////////////////////
/////////////////////////////////////////////



import flash.events.KeyboardEvent;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.ui.Keyboard;

internal class SearchBox extends TextField {
    private var player:YouTubePlayer;
    public function SearchBox( player:YouTubePlayer ) {
        this.player = player;
        
        var format:TextFormat = new TextFormat("Arial", 18, 0 );
        format.align = TextFormatAlign.CENTER;
        defaultTextFormat = format;
        
        background = true;
        backgroundColor = 0xFFFFFF;
        type = TextFieldType.INPUT;
        
        x = 100;
        y = 465/2-210;
        width = 265;
        height = 25;
    }
    
    public function setFocus():void{
        stage.focus = this;
        text = "Type your favorite song name";
        setSelection( 0, text.length );
        
        stage.addEventListener( KeyboardEvent.KEY_DOWN, function( event:KeyboardEvent ):void{
            if( event.keyCode == Keyboard.ENTER ){
                player.search( text );
                text = "";
            }
        });
    }
    
    
  

}

//////////////////////////////////////////////////

