/**
 * Copyright leemin0830 ( http://wonderfl.net/user/leemin0830 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mlls
 */

// forked from Jacky.Riawan's RGB war!
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.utils.ByteArray;
    import flash.utils.Dictionary;
    import mx.utils.Base64Decoder;
    /**
     * asset: http://opengameart.org/content/wittle-tank-soldier-and-plane
     * ...
     * @author Jacky Riawan
     */
    public class Main extends Sprite 
    {
        public const bitmapList:Dictionary = new Dictionary();
        private const SOLDIER_DIE:String = "iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoV2luZG93cykiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6NTFGOUNGNjkwQjNEMTFFM0I1Q0FENjM1NUVCODIxRkMiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6NTFGOUNGNkEwQjNEMTFFM0I1Q0FENjM1NUVCODIxRkMiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDo1MUY5Q0Y2NzBCM0QxMUUzQjVDQUQ2MzU1RUI4MjFGQyIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDo1MUY5Q0Y2ODBCM0QxMUUzQjVDQUQ2MzU1RUI4MjFGQyIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Pn00og8AAABPSURBVHjahI4BCsAgDAMb8d92L88y1wridAGhhuYakLSTiv0Ieh0hEoaJd3zolbElkx9hqwORigRiKknYdtACL/fJbPojei0XprBK3gIMAKxeHAnrWoX/AAAAAElFTkSuQmCC";
        private const SOLDIER_DOWN:String = "iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoV2luZG93cykiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6RjI2MDM4NDkwQjNDMTFFMzhGNERENTMxREQ1QTdFRTYiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6RjI2MDM4NEEwQjNDMTFFMzhGNERENTMxREQ1QTdFRTYiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDpGMjYwMzg0NzBCM0MxMUUzOEY0REQ1MzFERDVBN0VFNiIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDpGMjYwMzg0ODBCM0MxMUUzOEY0REQ1MzFERDVBN0VFNiIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PtiNU+QAAABFSURBVHjafE5bCgAgCGvSwe3kC0zJBPPHsYcOJMdvkHB2IoISIt3BYp4hvvkL7cJSPSTK0/SiHekaV856wKvYJk3bAgwA27oWhYY7dQAAAAAASUVORK5CYII=";
        private const SOLDIER_UP:String = "iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoV2luZG93cykiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6RUJEMkY5RkMwQjNDMTFFMzk3Q0M5QTNGRThBMzZFQzAiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6RUJEMkY5RkQwQjNDMTFFMzk3Q0M5QTNGRThBMzZFQzAiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDpFQkQyRjlGQTBCM0MxMUUzOTdDQzlBM0ZFOEEzNkVDMCIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDpFQkQyRjlGQjBCM0MxMUUzOTdDQzlBM0ZFOEEzNkVDMCIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PhCTc/EAAAA+SURBVHjalI2LCgAgDAJ3ffn+3GhR9IJKGAM91CTZQWGWLC1mnLt3qAHSQIyi1ADbEHWCZBf9Acyfp4YswADj7xh/vLivrAAAAABJRU5ErkJggg==";
        private const SOLDIER_LEFT:String = "iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoV2luZG93cykiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6MDM0MkQyQTEwQjNEMTFFM0JENEJDOUM4ODc4M0VFMDMiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6MDM0MkQyQTIwQjNEMTFFM0JENEJDOUM4ODc4M0VFMDMiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDowMzQyRDI5RjBCM0QxMUUzQkQ0QkM5Qzg4NzgzRUUwMyIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDowMzQyRDJBMDBCM0QxMUUzQkQ0QkM5Qzg4NzgzRUUwMyIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PjQlS+IAAABHSURBVHjafI5JDgAgCAMdPi4/r0swQUzkVroiqf2OgrOaZbZMKhRKYrucKhlRIXe/nn3iTUhwoqkDQrAq4LPa8nzeCW0IMACn8h37aTrI+gAAAABJRU5ErkJggg==";
        private const SOLDIER_RIGHT:String = "iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoV2luZG93cykiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6RkI0RUFCOTcwQjNDMTFFM0IzOTFGMUQ3RkJCNkRGNUMiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6RkI0RUFCOTgwQjNDMTFFM0IzOTFGMUQ3RkJCNkRGNUMiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDpGQjRFQUI5NTBCM0MxMUUzQjM5MUYxRDdGQkI2REY1QyIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDpGQjRFQUI5NjBCM0MxMUUzQjM5MUYxRDdGQkI2REY1QyIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PtUTaowAAABOSURBVHjafI9BDsAgCAQd04fTl69CbBRMyoEFMoEFSe0vHk+Ay0nyFX1p7NGmVIE9Vuoa7mGeiA2vWeJt9gk4DWhpOsFd06sFyjtDgAEARLgcCCUxd6wAAAAASUVORK5CYII=";
        private const loadingList:Vector.<ByteArray> = new Vector.<ByteArray>();
        private const objects:Vector.<blitObject> = new Vector.<blitObject>();
        public const red_soldiers:Vector.<soldier> = new Vector.<soldier>();
        public const green_soldiers:Vector.<soldier> = new Vector.<soldier>();
        public const blue_soldiers:Vector.<soldier> = new Vector.<soldier>();
        public const red_bullets:Vector.<soldier> = new Vector.<soldier>();
        public const green_bullets:Vector.<soldier> = new Vector.<soldier>();
        public const blue_bullets:Vector.<soldier> = new Vector.<soldier>();
        private const loader:Loader = new Loader();
        //private var bg:BitmapData;
        public var mainScreen:BitmapData;
        private var blitPoint:Point = new Point();
        private var parser:Base64Decoder=new Base64Decoder();
        public function Main():void 
        {
            setupBg();
            decodeAssets();
            addChild(new Bitmap(mainScreen));
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
        }
        private function setupBg():void {
            mainScreen = new BitmapData(stage.stageWidth, stage.stageHeight,false);
            /*bg = new BitmapData(stage.stageWidth, stage.stageHeight, false);
            bg.noise(Math.random() * 100, 200, 255, 7, true);
            const TILE_SIZE:int = 8;
            for (var _x:int = 0; _x < bg.width / TILE_SIZE; _x++) {
                if(_x%2==0){
                    bg.fillRect(new Rectangle(_x * TILE_SIZE, 0, 1, bg.height), 0xB5B5B5);
                }else {
                    bg.fillRect(new Rectangle(_x * TILE_SIZE, 0, 1, bg.height), 0xF7F7F7);
                }
            }*/
        }
        private function completeHandler(e:Event):void 
        {
            switch(loadingList.length) {
                case 4:
                    bitmapList["red_die"] = Bitmap(loader.content).bitmapData;
                    break;
                case 3:
                    bitmapList["red_right"] = Bitmap(loader.content).bitmapData;
                    break;
                case 2:
                    bitmapList["red_left"] = Bitmap(loader.content).bitmapData;
                    break;
                case 1:
                    bitmapList["red_up"] = Bitmap(loader.content).bitmapData;
                    break;
                case 0:
                    bitmapList["red_down"] = Bitmap(loader.content).bitmapData;
                    break;
            }
            if (loadingList.length == 0) {
                parseColor("blue", 0xFF00FFFF);
                parseColor("green", 0xFF00FF00);
                for (var i:int = 0; i < 899; i++) {
                    addSoldier("blue", new Point(stage.stageWidth * Math.random(), stage.stageHeight * Math.random()));
                    addSoldier("red", new Point(stage.stageWidth * Math.random(), stage.stageHeight * Math.random()));
                    addSoldier("green", new Point(stage.stageWidth * Math.random(), stage.stageHeight * Math.random()));
                }
                addEventListener(Event.ENTER_FRAME, mainLoop);
            }else{
                loader.loadBytes(loadingList.pop());
            }
        }
        public function fireBullet(id:String, loc:Point, angle:Number, target:Vector.<soldier>):void {
            var obj:bullet = new bullet(id, loc, angle, target, this);
            objects.push(obj);
        }
        private function addSoldier(id:String, loc:Point):void {
            var obj:soldier = new soldier(id, loc,this);
            objects.push(obj);
            switch(id) {
                case "red":
                    red_soldiers.push(obj);
                    break;
                case "green":
                    green_soldiers.push(obj);
                    break;
                case "blue":
                    blue_soldiers.push(obj);
                    break;
            }
        }
        private function mainLoop(e:Event):void 
        {
            mainScreen.lock();
            blitPoint.x = blitPoint.y = 0;
            //mainScreen.copyPixels(bg, bg.rect, blitPoint);
            var normalizer:Number = 255 / Math.max(red_soldiers.length, green_soldiers.length, blue_soldiers.length);
            mainScreen.fillRect(mainScreen.rect, (red_soldiers.length*normalizer) << 16 | (green_soldiers.length*normalizer) << 8 | (blue_soldiers.length*normalizer));
            updateObjects();
            blitObjects();
            mainScreen.unlock();
        }        
        private function updateObjects():void 
        {
            var le:int = objects.length;
            for (var i:int = 0; i < le; i++) {
                if (objects[i].isDestroy) {
                    objects.splice(i, 1);
                    i--;
                    le--;
                }else{
                    objects[i].update();
                }
            }
        }        
        private function blitObjects():void 
        {
            objects.sort(ysort);
            var le:int = objects.length;
            for (var i:int = 0; i < le; i++) {
                objects[i].blit();
            }
        }        
        private function ysort(a:blitObject,b:blitObject):int 
        {
            if (a.pos.y > b.pos.y) {
                if (a.bottom&&!b.bottom) {
                    return -1;
                }else{
                    return 1;
                }
            }else if (a.pos.y < b.pos.y) {
                if (!a.bottom&&b.bottom) {
                    return 1;
                }else{
                    return -1
                }
            }else {
                return 0;
            }
        }
        private function parseColor(id:String, color:uint):void {
            bitmapList[id + "_die"] = replaceColor(bitmapList["red_die"], color);
            bitmapList[id + "_up"] = replaceColor(bitmapList["red_up"], color);
            bitmapList[id + "_down"] = replaceColor(bitmapList["red_down"], color);
            bitmapList[id + "_left"] = replaceColor(bitmapList["red_left"], color);
            bitmapList[id + "_right"] = replaceColor(bitmapList["red_right"], color);
        }
        private function replaceColor(bitmapData:BitmapData, color:uint):BitmapData {
            var newBitmap:BitmapData = bitmapData.clone();
            for (var _x:int = 0; _x < newBitmap.width; _x++) {
                for (var _y:int = 0; _y < newBitmap.height; _y++) {
                    if (newBitmap.getPixel32(_x, _y) == 0xFFFF0000) {
                        newBitmap.setPixel32(_x, _y, color);
                    }else {
                    }
                }
            }
            return newBitmap;
        }
        private function decodeAssets():void 
        {
            bitmapList["bullet_red"] = new BitmapData(2, 2, false, 0xFF0000);
            bitmapList["bullet_green"] = new BitmapData(2, 2, false, 0x009D00);
            bitmapList["bullet_blue"] = new BitmapData(2, 2, false, 0x0000FF);
            parser.decode(SOLDIER_DOWN);
            loadingList.push(parser.toByteArray());
            parser.decode(SOLDIER_UP)
            loadingList.push(parser.toByteArray());
            parser.decode(SOLDIER_LEFT)
            loadingList.push(parser.toByteArray());
            parser.decode(SOLDIER_RIGHT)
            loadingList.push(parser.toByteArray());
            parser.decode(SOLDIER_DIE)
            loader.loadBytes(parser.toByteArray());
        }
    }    
}
import flash.geom.Point;
class blitObject {
    public var bottom:Boolean = false;
    public var pos:Point
    public var main:Main
    public var isDestroy:Boolean = false;
    public function blitObject(pos:Point,main:Main):void {
        this.pos = pos;
        this.main = main;
    }
    public function update():void {        
    }
    public function blit():void {        
    }
}
class bullet extends blitObject {
    private var id:String;
    private static const rect:Rectangle = new Rectangle(0, 0, 2, 2);
    private var speedX:Number;
    private var speedY:Number;
    private var timer:int = 10;
    private var target:Vector.<soldier>;
    public function bullet(id:String,loc:Point, angle:Number,target:Vector.<soldier>, main:Main):void {
        super(loc, main);
        this.target = target;
        this.id = id;
        pos.x += 2;
        pos.y += 2;
        speedX = Math.cos(angle) * 3;
        speedY = Math.sin(angle) * 3;
    }
    override public function update():void 
    {
        if (timer > 0) {
            var le:Number = target.length;
            for (var i:int = 0; i < le; i++) {
                var tgt:soldier = target[i];
                if (tgt.health == 0) {
                    target.splice(i, 1);
                    i--;
                    le--;
                }else{
                    var dx:int = pos.x - tgt.pos.x;
                    var dy:int = pos.y - tgt.pos.y;
                    var dist:int = dx * dx + dy * dy;
                    if (dist < 150) {
                        tgt.damage();
                        timer = 0;
                        break;
                    }
                }
            }
            pos.x += speedX;
            pos.y += speedY;
            timer--;
        }else {
            isDestroy = true;
        }
        super.update();
    }
    override public function blit():void 
    {
        main.mainScreen.copyPixels(main.bitmapList["bullet_"+id], rect, pos,null,null,true);
        super.blit();
    }
}
import flash.geom.Point;
import flash.geom.Rectangle;
class soldier extends blitObject {
    public var id:String;
    private var animation:String = "_down";
    private static const rect:Rectangle = new Rectangle(0, 0, 8, 8);
    private var target:soldier;
    private var enemies:Vector.<soldier>;
    private var allies:Vector.<soldier>;
    private var firerate:int = Math.random() * 10;
    public var health:int = 20*Math.random()*10;
    private var jump:Number=0
    private var ground:int=0;
    public function soldier(id:String,loc:Point,main:Main):void {
        super(loc,main);
        this.id = id;
        switch(id) {
            case "red":
                allies=main.red_soldiers;
                enemies = main.green_soldiers;
                break;
            case "green":
                allies=main.green_soldiers;
                enemies = main.blue_soldiers;
                break;
            case "blue":
                allies=main.blue_soldiers;
                enemies = main.red_soldiers;
                break;
        }
    }
    public function damage():void {
        if (health > 0) {
            health--;
            if (health == 0) {
                bottom = true;
                animation = "_die";
            }
        }
    }
    override public function update():void 
    {
        if(health>0){
            if (target) {
                if (target.health == 0) {
                    target = null;
                }else{
                    var dx:int = target.pos.x-pos.x;
                    var dy:int = target.pos.y-pos.y;
                    var angle:Number = Math.atan2(dy, dx);
                    var dist:int = dx * dx + dy * dy;
                    if (dist > 150) {
                        pos.x += Math.cos(angle);
                        pos.y += Math.sin(angle);
                        if (Math.abs(dx) > Math.abs(dy)) {
                            if (dx < 0) {
                                animation = "_left";
                            }else {
                                animation = "_right";
                            }
                        }else {
                            if (dy < 0) {
                                animation = "_up";
                            }else {
                                animation = "_down";
                            }
                        }
                        if (pos.x < 0) {
                            pos.x = 0;
                        }else if (pos.x > main.mainScreen.width - 8) {
                            pos.x = main.mainScreen.width-8;
                        }
                        if (pos.y < 0) {
                            pos.y = 0;
                        }else if (pos.y > main.mainScreen.height - 8) {
                            pos.y = main.mainScreen.height-8;
                        }
                        ground=pos.y;
                    }else {
                        if(firerate==0){
                            main.fireBullet(id, pos.clone(), angle, enemies);
                            firerate = 10;
                        }else {
                            firerate--;
                        }
                    }
                }    
            }else {
                if(enemies.length==0){
                    if(allies.length==main.red_soldiers.length+main.green_soldiers.length+main.blue_soldiers.length){
                        animation = "_down";
                        jump+=.06;
                        pos.y=ground+int(jump)%2;
                    }
                }else{
                    findTarget();
                }
            }
        }
        super.update();
    }
    private function findTarget():void {
        var le:int = enemies.length;
        var closestDistance:int = int.MAX_VALUE;
        for (var i:int = 0; i < le; i++) {
            if (enemies[i].health == 0) {
                enemies.splice(i, 1);
                i--;
                le--;
            }else{
                var dx:int = pos.x - enemies[i].pos.x;
                var dy:int = pos.y - enemies[i].pos.y;
                var dist:int = dx * dx + dy * dy;
                if (dist < closestDistance) {
                    target = enemies[i];
                    if(Math.random()<.01){
                        break
                    }else{
                        closestDistance = dist;
                    }
                }
            }
        }
    }
    override public function blit():void
    {
        main.mainScreen.copyPixels(main.bitmapList[id + animation], rect, pos,null,null,true);
        super.blit();
    }
}