/**
 * Copyright codeonwort ( http://wonderfl.net/user/codeonwort )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mked
 */

// forked from mousepancyo's 簡単な集中線
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.geom.ColorTransform;

    [SWF(width = "465",height = "465",frameRate = "60",backgroundColor = "0")]

    public class Main extends Sprite
    {
        private var _canvas:BitmapData;  private var _bm:Bitmap;
        private var _ctf:ColorTransform = new ColorTransform(.88, .87, .95);
        private var cx:Number, cy:Number
        
        public function Main() {
            _canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x0);
            _bm = new Bitmap(_canvas);  addChild(_bm);
            addEventListener(Event.ENTER_FRAME, update);
            cx = stage.stageWidth / 2
            cy = stage.stageHeight / 2
        }
        
        private function update(e:Event):void {
            var line:Shape = new Shape();
            var g:Graphics = line.graphics;
            var pitch:int = 120;
            var len:int = stage.width
            var r:int = 3600;
            
            g.beginFill(0xFFFFFF);
            g.moveTo(-0.5, 0);
            g.lineTo(0.5, 0);
            g.lineTo(0, -0.5);
            g.lineTo(-0.5, 0);
            _canvas.lock();
            _canvas.colorTransform(_canvas.rect, _ctf);
            
            while (0 < r)
            {
                var x:Number = cx + Math.sin(r * Math.PI / 180) * len
                var y:Number = cy + Math.cos(r * Math.PI / 180) * len
                var mtx:Matrix = new Matrix();
                mtx.scale(15, Math.random() * len * 1.6);
                mtx.rotate((-r) * Math.PI / 180);
                mtx.translate(x, y);
                _canvas.draw(line, mtx);
                r -=  Math.round(Math.random() * pitch);
            }
            
            _canvas.unlock();
            _bm.x = (Math.random()-0.5) * 12
            _bm.y = (Math.random()-0.5) * 12
        }
    }
}