/**
 * Copyright pandaz ( http://wonderfl.net/user/pandaz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mkJt
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
 
    public class Main extends Sprite 
    {
        public function Main():void 
        {
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
 
        private function onEnterFrame(event:Event):void 
        {
            Effect.star(this, 1, 232, 232);
        }
    }
}
 
import flash.display.Sprite;
import flash.geom.Point;
import org.libspark.betweenas3.BetweenAS3;
 
class Effect
{
    // addChild先、星の数、x, y
    public static function star(container:Sprite, num:int, x:int, y:int):void
    {
        for (var i:int = 0; i < num; i++)
        {
            var star:Sprite = createPolygon(5, 0, 0, Math.random() * 10 + 5, true);
            star.x = x;
            star.y = y;
            BetweenAS3.serial
            (
                BetweenAS3.addChild(star, container),
                BetweenAS3.tween
                (
                    star,
                    {
                        // ランダムに回転(-360～360度)
                        rotation:Math.random() * 720 - 360,
                        // 消えるまで縮小
                        scaleX:0.0, scaleY:0.0,
                        // ランダムに横移動(-40px～40px)
                        x:star.x + Math.random() * 80 - 40,
                        // ランダムに上移動(-10px～-180px)
                        y:star.y - (Math.random() * 180 + 10)
                    },
                    null,
                    // トゥイーン時間は1～2秒
                    Math.random() + 1
                ),
                BetweenAS3.removeFromParent(star)
            ).play();
        }
    }
 
    private static function createPolygon(vertex:int, x:int, y:int, size:int, star:Boolean = false):Sprite
    {
        if (vertex < 3) vertex = 3;
 
        var points:Array = new Array();
        for (var degree:Number = 0; degree < 360; degree += 360 / vertex)
        {
            var tx:Number = x + Math.cos(degree * Math.PI / 180) * size;
            var ty:Number = y + Math.sin(degree * Math.PI / 180) * size;
            points.push(new Point(tx, ty));
 
            if (star)
            {
                tx = x + Math.cos((degree + 360 / vertex / 2) * Math.PI / 180) * (size / 2);
                ty = y + Math.sin((degree + 360 / vertex / 2) * Math.PI / 180) * (size / 2);
                points.push(new Point(tx, ty));
            }
        }
 
        // Spriteに星を描き、returnで返却
        var polygon:Sprite = new Sprite();
        polygon.graphics.lineStyle(1.0, 0x0); // 輪郭を描く
        polygon.graphics.beginFill(Math.random() * int.MAX_VALUE); // 色はランダム
        polygon.graphics.moveTo(points[0].x, points[0].y);
        for (var i:int = 1; i < points.length; i++)
        {
            polygon.graphics.lineTo(points[i].x, points[i].y);
        }
        polygon.graphics.lineTo(points[0].x, points[0].y);
 
        return polygon;
    }
}
