/**
 * Copyright snuke ( http://wonderfl.net/user/snuke )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mjoN
 */

package {
    import flash.display.Sprite;
    import flash.events.*;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.text.*;
    import flash.media.Sound;
    import flash.net.URLRequest;
    import flash.filters.BlurFilter;
    
    import net.user1.reactor.IClient;
    import net.user1.reactor.Reactor;
    import net.user1.reactor.ReactorEvent;
    import net.user1.reactor.Room;
    import net.user1.reactor.RoomEvent;
    import net.user1.reactor.Attribute;
    import net.user1.reactor.AttributeEvent;
    
    
    [SWF(width="500", height="500", backgroundColor="0xddddff", frameRate="24")]
    
    //ゴミコードなので,読むと目が腐ります
    public class Square extends Sprite { 
        public var spr:Sprite = new Sprite();
        
        public var sqs:int = X.sqs;
        public var datx:Array = X.datx;
        public var daty:Array = X.daty;
        public var datp:Array = X.datp;
        
        public var textF:TextFormat = new TextFormat();
        public var tf0:TextField;
        public var tf1:TextField;
        public var tfinit:TextField;
        public var tfjun:TextField;
        public var tfout:TextField;
        public var tfsc0:TextField;
        public var tfsc1:TextField;
        public var rooms:int = 10;
        public var roomtf:Array = new Array(rooms);
        public var room0tf:Array = new Array(rooms);
        public var room1tf:Array = new Array(rooms);
        public var nowroom:int = 0;
        public var jun:Array = new Array(6);
        public var efe:Vector.<Effect> = new Vector.<Effect>(sqs);
        public var ten:Vector.<Ten> = new Vector.<Ten>(sqs);
        
        public var viewtf:TextField;
        public var saytf:TextField;
        public var sendtf:TextField;
        public var nicktf:TextField;
        public var nametf:TextField;
        public var oktf:TextField;
        public var _name:String;
        
        public var isi:Array = new Array(6);
        public var isic:Array = new Array(6);
        public var turn:int;
        public var score:Array = new Array(2);
        public var nowsc:Array = new Array(2);
        public var addsc:Array = new Array(2);
        
        public var junb:Boolean = true;
        public var redb:Boolean = true;
        public var new0:Boolean = false;
        public var new1:Boolean = false;
        
        public var pl:int = -1;
        
        public var se:Sound;
        
        
        public function Square(){
            this.addChild(spr);
            
            txt_init();
            
            var i:int;
            for(i = 0; i < 6; i++){
                isi[i] = new Array(6);
                isic[i] = new Array(6);
            }
            for(i = 0; i < sqs; i++){
                efe[i] = new Effect();
                spr.addChild(efe[i]);
                ten[i] = new Ten(i);
                spr.addChild(ten[i]);
            }
            
            init();
            
            se = new Sound(new URLRequest("http://www29.atpages.jp/snuke/pati.mp3"));
            
            connect();
            
            this.addEventListener(Event.ENTER_FRAME, main);
            this.addEventListener(KeyboardEvent.KEY_DOWN, key_down);
            this.addEventListener(MouseEvent.MOUSE_DOWN, down);
        }
        
        
        public function init():void{
            var i:int, j:int;
            for(i = 0; i < 6; i++){
                for(j = 0; j < 6; j++){
                    isi[i][j] = 0;
                }
            }
            
            for(i = 0; i < sqs; i++){
                efe[i].kill();
                ten[i].kill();
            }
            
            turn = 0;
            score[0] = score[1] = 0;
            nowsc[0] = nowsc[1] = 0;
            addsc[0] = addsc[1] = 0;
            
            new0 = new1 = false;
            
            jun_init();
            
            frame();
            cal_score();
        }
        
        public function txt_init():void{
            textF.align = "center";
            
            tf0 = createTF(35,300,110,20);
            spr.addChild(tf0);
            tf1 = createTF(180,300,110,20);
            spr.addChild(tf1);
            
            tfsc0 = new TextField();
            tfsc0.x = 20; tfsc0.y = 304; tfsc0.width = 0;
            tfsc0.autoSize = TextFieldAutoSize.CENTER;
            tfsc0.textColor = 0xffffff; tfsc0.selectable = false;
            spr.addChild(tfsc0);
            tfsc1 = new TextField();
            tfsc1.x = 165; tfsc1.y = 304; tfsc1.width = 0;
            tfsc1.autoSize = TextFieldAutoSize.CENTER;
            tfsc1.selectable = false;
            spr.addChild(tfsc1);
            
            
            tfinit = createButton(10,332,80,16);
            tfinit.text = "New game"; tfinit.backgroundColor = 0xffffcc;
            spr.addChild(tfinit);
            tfjun = createButton(95,332,110,16);
            tfjun.text = "手順を表示"+(junb?"する":"しない");
            tfjun.backgroundColor = (junb?0xccffcc:0xffcccc);
            spr.addChild(tfjun);
            tfout = createButton(210,332,80,16);
            tfout.text = "席を立つ"; tfout.backgroundColor = 0xffbbbb;
            spr.addChild(tfout);
            
            
            viewtf = createTF(10,360,280,100);
            viewtf.multiline = true; viewtf.wordWrap = true;
            spr.addChild(viewtf);
            saytf = createTF(10,465,245,16);
            saytf.type = TextFieldType.INPUT;
            spr.addChild(saytf);
            sendtf = createButton(260,465,30,16);
            sendtf.text = "send"; sendtf.backgroundColor = 0xccffcc;
            spr.addChild(sendtf);
            
            nicktf = createButton(310,465,50,16);
            nicktf.text = "名前"; nicktf.backgroundColor = 0xffccee;
            spr.addChild(nicktf);
            nametf = createTF(360,465,100,16);
            nametf.text = "guest"+(int)(Math.random()*100);
            nametf.type = TextFieldType.INPUT;
            nametf.addEventListener(FocusEvent.FOCUS_OUT,nametf_out);
            spr.addChild(nametf);
            _name = nametf.text;
            oktf = createButton(460,465,20,16);
            oktf.text = "ok"; oktf.backgroundColor = 0xccffcc;
            spr.addChild(oktf);
            
            
            var i:int, j:int;
            for(i = 0; i < rooms; i++){
                roomtf[i] = createButton(310,10+i*45,50,36);
                roomtf[i].text = "Room"+(i+1); roomtf[i].backgroundColor = 0xccccff;
                spr.addChild(roomtf[i]);
                
                room0tf[i] = createTF(360,10+i*45,120,18);
                spr.addChild(room0tf[i]);
                room1tf[i] = createTF(360,28+i*45,120,18);
                spr.addChild(room1tf[i]);
            }
            roomtf[nowroom].backgroundColor = 0x9999ff;
            
            
            for(i = 0; i < 6; i++){
                jun[i] = new Array(6);
                for(j = 0; j < 6; j++){
                    jun[i][j] = new TextField();
                    jun[i][j].x = 40*i+50; jun[i][j].y = 40*j+44; jun[i][j].width = 0;
                    jun[i][j].autoSize = TextFieldAutoSize.CENTER;
                    jun[i][j].selectable = false;
                    spr.addChild(jun[i][j]);
                }
            }
        }
        
        
        public function jun_init():void{
            var i:int, j:int;
            for(i = 0; i < 6; i++){
                for(j = 0; j < 6; j++){
                    jun[i][j].text = "";
                }
            }
        }
        public function jun_fill():void{
            var i:int, j:int;
            for(i = 0; i < 6; i++){
                for(j = 0; j < 6; j++){
                    if(isi[i][j] != 0) jun[i][j].text = isi[i][j];
                }
            }
        }
        
        public function createButton(x:int,y:int,w:int,h:int):TextField{
            var tf:TextField = createTF(x,y,w,h);
            tf.selectable = false;
            tf.defaultTextFormat = textF;
            return tf;
        }
        
        public function createTF(x:int,y:int,w:int,h:int):TextField{
            var tf:TextField = new TextField();
            tf.border = true;
            tf.x = x; tf.y = y;
            tf.width = w; tf.height = h;
            tf.background = true;
            return tf;
        }
        
        
        
        public function main(e:Event):void{
            var i:int;
            for(i = 0; i < sqs; i++){
                if(efe[i].live){
                    if(efe[i].move()) addsc[efe[i].te] += datp[i];
                }
                if(ten[i].live) ten[i].move();
            }
            
            for(i = 0; i < 2; i++){
                if(addsc[i] > 0){
                    addsc[i]--;
                    nowsc[i]++;
                }
            }
            
            tfsc0.htmlText = "<font size='10'>"+nowsc[0]+"</font>";
            tfsc1.htmlText = "<font size='10'>"+nowsc[1]+"</font>";
            
            
            var r:int, g:int, b:int;
            g = 255-Math.abs(nowsc[1]-nowsc[0])*2;
            r = 255-Math.max(0,nowsc[1]-nowsc[0])*2;
            b = 255-Math.max(0,nowsc[0]-nowsc[1])*2;
            tf0.backgroundColor = (r<<16)+(g<<8)+b;
            tf1.backgroundColor = (b<<16)+(g<<8)+r;
        }

        
        
        public function frame():void{
            spr.graphics.clear();
            spr.graphics.beginFill(0xffd000);
            spr.graphics.drawRect(10,10,280,280);
            spr.graphics.endFill();
            spr.graphics.lineStyle(1,0x000000);
            
            var i:int, j:int;
            for(i = 0; i < 6; i++){
                spr.graphics.moveTo(i*40+50,50);
                spr.graphics.lineTo(i*40+50,251);
                spr.graphics.moveTo(50,i*40+50);
                spr.graphics.lineTo(250,i*40+50);
            }
            
            for(i = 0; i < 6; i++){
                for(j = 0; j < 6; j++){
                    if(isi[i][j] == 0) continue;
                    
                    if(cal_color(isi[i][j]) == 1){
                        spr.graphics.lineStyle();
                        spr.graphics.beginFill(0x000000);
                        spr.graphics.drawCircle(i*40+50,j*40+50,19);
                        spr.graphics.endFill();
                        jun[i][j].textColor = 0xffffff;
                    } else {
                        spr.graphics.lineStyle(1,0x000000);
                        spr.graphics.beginFill(0xffffff);
                        spr.graphics.drawCircle(i*40+50,j*40+50,19);
                        spr.graphics.endFill();
                        jun[i][j].textColor = 0x000000;
                    }
                    
                    if(isi[i][j] >= (turn>>1<<1)){
                        if(junb){
                            jun[i][j].textColor = 0xff0000;
                        } else {
                            spr.graphics.lineStyle();
                            spr.graphics.beginFill(0xff0000);
                            spr.graphics.drawCircle(i*40+50,j*40+50,3);
                            spr.graphics.endFill();
                        }
                    }
                }
            }
            
            
            spr.graphics.lineStyle();
            spr.graphics.beginFill(0x000000);
            spr.graphics.drawCircle(20,310,10);
            spr.graphics.endFill();
            spr.graphics.lineStyle(1,0x000000);
            spr.graphics.beginFill(0xffffff);
            spr.graphics.drawCircle(165,310,10);
            spr.graphics.endFill();
        }
        
        
        
        public function cal_color(x:int):int{
            if(x<=0) return 0;
            return ((x>>1)&1)+1;
        }
        
        
        public function cal_score():void{
            var i:int, j:int, z:int;
            var c:Array = new Array(3);
            var bl:Boolean;
            score[0] = score[1] = 0;
            
            for(i = 0; i < sqs; i++){
                for(j = 0; j < 3; j++) c[j] = 0;
                bl = false;
                for(j = 0; j < 4; j++){
                    z = isi[datx[i][j]][daty[i][j]];
                    c[cal_color(z)]++;
                    if(z==turn) bl = true;
                }
                
                if(c[1] == 4){
                    score[0] += datp[i];
                    if(bl) play_efe(i,0);
                }
                if(c[2] == 4){
                    score[1] += datp[i];
                    if(bl) play_efe(i,1);
                }
            }
        }
        
        public function play_efe(n:int, teban:int):void{
            efe[n].init(n,teban);
            ten[n].init(n);
        }
        
        
        public function put(x:int, y:int):void{
            if(isi[x][y] != 0) return;
            isi[x][y] = ++turn;
            if(junb) jun[x][y].text = turn;
            se.play();
            cal_score();
        }
        
        private function send_board():void{
            var t:String = "", i:int, j:int;
            
            for(i = 0; i < 6; i++){
                for(j = 0; j < 6; j++){
                    t += String.fromCharCode(isi[i][j]/10+48,isi[i][j]%10+48);
                }
            }
            
            _room[nowroom].setAttribute("board", t);
        }
        
        private function load_board():void{
            var t:String = _room[nowroom].getAttribute("board");
            if(t == null || t.length != 72){
                send_board();
            } else {
                var i:int, j:int, k:int = 0, turnc:int = 0;
                for(i = 0; i < 6; i++){
                    for(j = 0; j < 6; j++){
                        isic[i][j] = parseInt(t.substring(k,k+2));
                        turnc = Math.max(turnc,isic[i][j]);
                        k += 2;
                    }
                }
                
                if(turnc > turn+1){
                    cp_board();
                } else if(turn+1 == turnc){
                    for(i = 0; i < 6; i++){
                        for(j = 0; j < 6; j++){
                            if(turnc == isic[i][j]) put(i,j);
                        }
                    }
                }
                frame();
            }
        }
        
        private function cp_board():void{
            var i:int, j:int;
            turn = 0;
            for(i = 0; i < 6; i++){
                for(j = 0; j < 6; j++){
                    isi[i][j] = isic[i][j];
                    if(junb) jun[i][j].text = (isi[i][j]==0?"":isi[i][j]);
                    turn = Math.max(turn,isi[i][j]);
                }
            }
            cal_score();
            nowsc[0] = score[0];
            nowsc[1] = score[1];
            for(i = 0; i < sqs; i++){
                efe[i].kill();
                ten[i].kill();
            }
        }
        
        
        
        public function down(e:MouseEvent):void{
            var x:int = spr.mouseX, y:int = spr.mouseY;
            if(x>30&&x<270&&y>30&&y<270&&cal_color(turn+1)-1==pl){
                put((x-30)/40,(y-30)/40);
                send_board();
            }
            
            if(text_hit(tfinit,x,y) && pl != -1){
                _room[nowroom].sendMessage("new", true, null, pl);
            }
            if(text_hit(tfjun,x,y)){
                junb = !junb;
                tfjun.text = "手順を表示"+(junb?"する":"しない");
                tfjun.backgroundColor = (junb?0xccffcc:0xffcccc);
                if(junb) jun_fill(); else jun_init();
            }
            if(text_hit(tfout,x,y)){
                if(pl == 0) _room[nowroom].setAttribute("pl0", "");
                if(pl == 1) _room[nowroom].setAttribute("pl1", "");
                pl = -1;
            }
            
            if(text_hit(sendtf,x,y)) send();
            if(text_hit(oktf,x,y)) change_name();            
            if(text_hit(tf0,x,y) && pl == -1){
                load_pl();
                if(tf0.text == "席につく"){
                    pl = 0;
                    _room[nowroom].setAttribute("pl0",_name);
                }
            }
            if(text_hit(tf1,x,y) && pl == -1){
                load_pl();
                if(tf1.text == "席につく"){
                    pl = 1;
                    _room[nowroom].setAttribute("pl1",_name);
                }
            }
            
            var i:int;
            for(i = 0; i < rooms; i++){
                if(text_hit(roomtf[i],x,y)){
                    roomtf[nowroom].backgroundColor = 0xccccff;
                    init();
                    pl = -1;
                    lvroom(nowroom);
                    nowroom = i;
                    roomtf[i].backgroundColor = 0x9999ff;
                    acroom(i);
                    reflesh();
                }
            }
            
            frame();
        }
        public function text_hit(t:TextField, x:int, y:int):Boolean{
            return x>t.x && x<t.x+t.width && y>t.y && y<t.y+t.height;
        }
        
        
        
        private function key_down(e:KeyboardEvent):void{
            if(e.keyCode == Keyboard.ENTER){
                if(stage.focus == saytf) send();
                if(stage.focus == nametf) change_name();
            }
        }
        
        
        private function send():void{
            if(saytf.text.length != 0 && saytf.text.length < 50){
                var t:String = _room[nowroom].getAttribute("texts");
                if(t == null || t.length == 0) t = viewtf.htmlText;
                t += "<font size='12' color='#"+(pl==-1?"999999":"555555")+"'>"+_name+" : </font><font size='14'>"+saytf.text+"</font><br>";
                
                var cut:int;
                while(t.length > 1000){
                    cut = t.search("<br>");
                    if(cut == -1) break;
                    t = t.substring(cut+4,t.length);
                }
                
                _room[nowroom].setAttribute("texts", t);
                viewtf.htmlText = t;
                viewtf.scrollV = viewtf.maxScrollV;
                
                saytf.text = "";
            }
        }
        private function load_text():void{
            var t:String = _room[nowroom].getAttribute("texts");
            if(t == null || t.length == 0){
                _room[nowroom].setAttribute("texts",viewtf.htmlText);
            } else {
                viewtf.htmlText = t;
                viewtf.scrollV = viewtf.maxScrollV;
            }
        }
        
        private function nametf_out(e:FocusEvent):void{
            change_name();
        }
        
        private function change_name():void{
            if(nametf.text.length != 0 && nametf.text.length <= 12 && nametf.text != "席につく"){
                _name = nametf.text;
                
                if(pl==0) _room[nowroom].setAttribute("pl0",_name);
                if(pl==1) _room[nowroom].setAttribute("pl1",_name);
            } else nametf.text = _name;
        }
        
        private function load_pl():void{
            var t:String = _room[nowroom].getAttribute("pl0");
            if(t == null || t.length == 0){
                if(pl!=0){
                    tf0.text = "席につく";
                    _room[0].sendMessage("pl", true, null, nowroom, 0, "");
                }
                if(pl==0) _room[nowroom].setAttribute("pl0",_name);
            } else {
                tf0.text = t;
            }
            
            t = _room[nowroom].getAttribute("pl1");
            if(t == null || t.length == 0){
                if(pl!=1){
                    tf1.text = "席につく";
                    _room[0].sendMessage("pl", true, null, nowroom, 1, "");
                }
                if(pl==1) _room[nowroom].setAttribute("pl1",_name);
            } else {
                tf1.text = t;
            }
        }
        
        
        
        //union (いまいち分からぬ・・・故,ただ動くだけのコードに・・・)
        
        private var _reactor:Reactor;       
        private var _room:Array = new Array(rooms);
        
        
        private function connect():void{
            _reactor = new Reactor();
            _reactor.addEventListener(ReactorEvent.READY, reactor_ready);
            _reactor.connect("tryunion.com", 80);
        }
        
        private function reactor_ready(e:ReactorEvent):void{
            nicktf.text = "cone";
            join();
        }
        
        private function join():void{
            var i:int;
            for(i = 0; i < rooms; i++){
                _room[i] = _reactor.getRoomManager().createRoom("room"+i+"nanounagi");
                _room[i].join();
            }
            _room[nowroom].addEventListener(RoomEvent.JOIN, room_join);
            _room[0].addMessageListener("pl", mes_pl);
            acroom(nowroom);
        }
        
        private function room_join(e:RoomEvent):void{
            reflesh();
        }
        
        private function reflesh():void{
            _room[nowroom].setAttribute("texts", "");
            _room[nowroom].setAttribute("pl0", "");
            _room[nowroom].setAttribute("pl1", "");
        }
        
        private function lvroom(rm:int):void{
            _room[rm].removeEventListener(AttributeEvent.UPDATE, attr_Listener);
            _room[rm].removeMessageListener("new", mes_new);
            _room[rm].removeEventListener(RoomEvent.ADD_OCCUPANT, join_someone);
            if(pl != -1) _room[0].sendMessage("pl", true, null, nowroom, pl, "");
        }
        private function acroom(rm:int):void{
            _room[rm].addEventListener(AttributeEvent.UPDATE, attr_Listener);
            _room[rm].addMessageListener("new", mes_new);
            _room[rm].addEventListener(RoomEvent.ADD_OCCUPANT, join_someone);
        }
        
        private function attr_Listener(e:AttributeEvent):void{
            load_text();
            load_board();
            load_pl();
            if(pl != -1) _room[0].sendMessage("pl", true, null, nowroom, pl, _name);
        }
        
        private function join_someone(e:RoomEvent):void{
            if(pl != -1){
                _room[0].sendMessage("pl", true, null, nowroom, pl, _name);
                send_board();
            }
        }
        
        private function activate():void{
            stage.addEventListener(KeyboardEvent.KEY_DOWN, key_down);
        }
        
        private function mes_new(fromClient:IClient, npl:int):void{
            if(npl == 0) new0 = true;
            if(npl == 1) new1 = true;
            if(new0 && new1) init();
            tfinit.textColor = 0x0;
            if((pl == 0 && new0) || (pl == 1 && new1)) tfinit.textColor = 0x888888;
        }
        
        private function mes_pl(fromClient:IClient, rm:int, npl:int, plname:String):void{
            if(npl == 0){
                room0tf[rm].text = plname;
            } else {
                room1tf[rm].text = plname;
            }
        }
    }
}


class X{
    public static const sqs:int = 105;
    public static const datx:Array = [
    [0,1,1,0],[0,1,1,0],[0,1,1,0],[0,1,1,0],[0,1,1,0],[1,2,2,1],[1,2,2,1],[1,2,2,1],[1,2,2,1],[1,2,2,1],[2,3,3,2],[2,3,3,2],[2,3,3,2],[2,3,3,2],[2,3,3,2],[3,4,4,3],[3,4,4,3],[3,4,4,3],[3,4,4,3],[3,4,4,3],[4,5,5,4],[4,5,5,4],[4,5,5,4],[4,5,5,4],[4,5,5,4],
    [0,1,2,1],[0,1,2,1],[0,1,2,1],[0,1,2,1],[1,2,3,2],[1,2,3,2],[1,2,3,2],[1,2,3,2],[2,3,4,3],[2,3,4,3],[2,3,4,3],[2,3,4,3],[3,4,5,4],[3,4,5,4],[3,4,5,4],[3,4,5,4],
    [0,2,2,0],[0,2,2,0],[0,2,2,0],[0,2,2,0],[1,3,3,1],[1,3,3,1],[1,3,3,1],[1,3,3,1],[2,4,4,2],[2,4,4,2],[2,4,4,2],[2,4,4,2],[3,5,5,3],[3,5,5,3],[3,5,5,3],[3,5,5,3],
    [0,2,3,1],[0,2,3,1],[0,2,3,1],[1,3,4,2],[1,3,4,2],[1,3,4,2],[2,4,5,3],[2,4,5,3],[2,4,5,3],
    [0,1,3,2],[0,1,3,2],[0,1,3,2],[1,2,4,3],[1,2,4,3],[1,2,4,3],[2,3,5,4],[2,3,5,4],[2,3,5,4],
    [0,2,4,2],[0,2,4,2],[1,3,5,3],[1,3,5,3],
    [0,3,3,0],[0,3,3,0],[0,3,3,0],[1,4,4,1],[1,4,4,1],[1,4,4,1],[2,5,5,2],[2,5,5,2],[2,5,5,2],
    [0,3,4,1],[0,3,4,1],[1,4,5,2],[1,4,5,2],
    [0,1,4,3],[0,1,4,3],[1,2,5,4],[1,2,5,4],
    [0,3,5,2],[0,2,5,3],
    [0,4,4,0],[0,4,4,0],[1,5,5,1],[1,5,5,1],
    [0,4,5,1],[0,1,5,4],[0,5,5,0]];
    public static const daty:Array = [
    [0,0,1,1],[1,1,2,2],[2,2,3,3],[3,3,4,4],[4,4,5,5],[0,0,1,1],[1,1,2,2],[2,2,3,3],[3,3,4,4],[4,4,5,5],[0,0,1,1],[1,1,2,2],[2,2,3,3],[3,3,4,4],[4,4,5,5],[0,0,1,1],[1,1,2,2],[2,2,3,3],[3,3,4,4],[4,4,5,5],[0,0,1,1],[1,1,2,2],[2,2,3,3],[3,3,4,4],[4,4,5,5],
    [1,0,1,2],[2,1,2,3],[3,2,3,4],[4,3,4,5],[1,0,1,2],[2,1,2,3],[3,2,3,4],[4,3,4,5],[1,0,1,2],[2,1,2,3],[3,2,3,4],[4,3,4,5],[1,0,1,2],[2,1,2,3],[3,2,3,4],[4,3,4,5],
    [0,0,2,2],[1,1,3,3],[2,2,4,4],[3,3,5,5],[0,0,2,2],[1,1,3,3],[2,2,4,4],[3,3,5,5],[0,0,2,2],[1,1,3,3],[2,2,4,4],[3,3,5,5],[0,0,2,2],[1,1,3,3],[2,2,4,4],[3,3,5,5],
    [1,0,2,3],[2,1,3,4],[3,2,4,5],[1,0,2,3],[2,1,3,4],[3,2,4,5],[1,0,2,3],[2,1,3,4],[3,2,4,5],
    [2,0,1,3],[3,1,2,4],[4,2,3,5],[2,0,1,3],[3,1,2,4],[4,2,3,5],[2,0,1,3],[3,1,2,4],[4,2,3,5],
    [2,0,2,4],[3,1,3,5],[2,0,2,4],[3,1,3,5],
    [0,0,3,3],[1,1,4,4],[2,2,5,5],[0,0,3,3],[1,1,4,4],[2,2,5,5],[0,0,3,3],[1,1,4,4],[2,2,5,5],
    [1,0,3,4],[2,1,4,5],[1,0,3,4],[2,1,4,5],
    [3,0,1,4],[4,1,2,5],[3,0,1,4],[4,1,2,5],
    [2,0,3,5],[3,0,2,5],
    [0,0,4,4],[1,1,5,5],[0,0,4,4],[1,1,5,5],
    [1,0,4,5],[4,0,1,5],[0,0,5,5]];
    public static const datp:Array = [
    1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
    2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
    4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
    5,5,5,5,5,5,5,5,5,
    5,5,5,5,5,5,5,5,5,
    8,8,8,8,
    9,9,9,9,9,9,9,9,9,
    10,10,10,10,
    10,10,10,10,
    13,13,
    16,16,16,16,
    17,17,25];
    public static const col:Array = [,0x969696,0xc89600,,0x0000ff,0x00ff00,,,0xffff00,0x00ffff,0xff0000,
    ,,0xff00ff,,,0x96ff00,0x00ff96,,,,,,,,0xd2c8c8];
}



import flash.display.Sprite;
import flash.filters.GlowFilter;
import flash.text.*;

class Effect extends Sprite {
    public var te:int;
    public var tx:Number, ty:Number, ax:Number, ay:Number, dx:Number, dy:Number, a:Number;
    public var live:Boolean;
    
    public function Effect(){
    }
    
    public function init(n:int,teban:int):void{
        te = teban;
        graphics.lineStyle(2, X.col[X.datp[n]]);
        live = true;
        
        x = (X.datx[n][0]+X.datx[n][2])*20+50; y = (X.daty[n][0]+X.daty[n][2])*20+50;
        tx = 23+teban*145; ty = 315;
        dx = tx-x; dy = ty-y; a = Math.sqrt(dx*dx+dy*dy);
        ax = dx/a; ay = dy/a; a = -6;
        scaleX = scaleY = 1; rotation = 0; alpha = 0;
        
        var i:int = 1;
        graphics.moveTo((X.datx[n][0]*40+50)-x,(X.daty[n][0]*40+50)-y);
        while(1){
            graphics.lineTo((X.datx[n][i]*40+50)-x,(X.daty[n][i]*40+50)-y);
            i = (i+1)%4;
            if(i == 1) break;
        }
        
        filters = [new GlowFilter(X.col[X.datp[n]],1,10,10)];
    }
    
    public function move():Boolean{
        a += 1;
        if(a < 0){
            alpha += 0.2;
        } else {
            x += ax*a;
            y += ay*a;
            rotation += a;
            scaleX = scaleY = (tx-x)/dx;
            if(y > ty){ kill(); return true;}
        }
        return false;
    }
    
    public function kill():void{
        live = false;
        graphics.clear();
    }
}


class Ten extends Sprite {
    public var live:Boolean, a:int;
    public var tf:TextField;
    
    public function Ten(n:int){
        tf = new TextField();
        tf.autoSize = TextFieldAutoSize.CENTER;
        tf.x = 0; tf.y = -12; tf.width = 0;
        tf.textColor = X.col[X.datp[n]];
        tf.htmlText = "<font size='24'>"+X.datp[n]+"</font>";
        tf.selectable = false;
        addChild(tf);
    }
    
    public function init(n:int):void{
        live = true;
        x = (X.datx[n][0]+X.datx[n][2])*20+50; y = (X.daty[n][0]+X.daty[n][2])*20+50;
        scaleX = scaleY = 1;
        alpha = 0;
        a = -6;
    }
    
    public function move():void{
        a += 1;
        if(a>0){
            alpha -= 0.05;
            scaleX -= 0.03; scaleY -= 0.03;
            y -= 5;
            if(scaleX < 0) kill();
        } else {
            alpha += 0.2;
            y += 1;
        }
    }
    
    public function kill():void{
        live = false;
        scaleX = scaleY = 0;
    }
}