/**
 * Copyright jamasian ( http://wonderfl.net/user/jamasian )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mjHI
 */

/*
      _                           _             
     | |                         (_)            
     | | __ _ _ __ ___   __ _ ___ _  __ _ _ __  
 _   | |/ _` | '_ ` _ \ / _` / __| |/ _` | '_ \ 
| |__| | (_| | | | | | | (_| \__ \ | (_| | | | |
 \____/ \__,_|_| |_| |_|\__,_|___/_|\__,_|_| |_|

Copyright 2010, Kaiyi Chan
*/

/*
-> Bugs notifier:
Button: can't access to Object (Dot)
Current Algorithm: Brute-Force (BAD, SLOW)
Liquids go through elements
*/
package
{
    import flash.text.TextFormat;
    import flash.text.Font;
    import flash.utils.Proxy;
    import flash.geom.Point;
    import flash.display.Graphics;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    
    [SWF(frameRate='40', BackgroundColor='0x000000')]
    
    public class dots extends Sprite {
        
        /* Background Bitmapscreen */
        public var    bmd:BitmapData;
        public var    bm:Bitmap;
        
        /* createDot() MOUSE_CLICK Handler */
        public var    MOUSE_ACTIVATE:Boolean;
        
        /* Element Dots */
        public var    elements:Elements    = new Elements();
        public var    getDot:Array         = new Array();
        public var    countDots:int;
        
        /* Mainframe TextField*/
        public var    input:TextField;
        
        /* User Configureables */
        public const  maxDots:int            =        1000;
        public var    Density:Number         =        1;
        public var    inputSetText:String    =        "";
        
        /* Boundary Box */
        public const  BOXLEFT:int            =        0;
        public const  BOXRIGHT:int           =        460;
        
        public const  BOXUP:int              =        0; 
        public const  BOXDOWN:int            =        370; //460

        /* -----Constructor----- */        
        public function dots()
        {
            //initialization Bitmapscreen
            bmd    = new BitmapData(465, 465, false, 0x000000);
            bm     = new Bitmap(bmd);
            addChild(bm);
            
            //create mainframe
            this.input = mainframe();
            this.input.defaultTextFormat=LetterType("Georgia", 11);
            
            //create updater
            stage.addEventListener(Event.ENTER_FRAME, update);
            
            //dot placer
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseClickDown);
            
            //buttons
            ElementButton(BOXLEFT, BOXDOWN+00, elements.Sand());
            ElementButton(BOXLEFT, BOXDOWN+15, elements.Stone());
            ElementButton(BOXLEFT, BOXDOWN+30, elements.Water());
            ElementButton(BOXLEFT, BOXDOWN+45, elements.Gas());
        }
        
        private function update(evt:Event):void
        {
            //update mainframe
            this.input.text = "coord: ["+mouseX+", "+mouseY+"]\nDots:"+this.countDots;
            this.input.appendText("\nType: "+this.elements.type.name);
            if (this.inputSetText!="") this.input.text=this.inputSetText;
            
            //element creation
            if (MOUSE_ACTIVATE == true) createDot();
            
            //emit pixel color
            this.bmd.fillRect(this.bmd.rect, 0x000000);
            
            var n:Dot;
            for (var i:int = 0; i < this.countDots; i++)
            {
                n = this.getDot[i];    
                this.bmd.setPixel(n.posx, n.posy, n.color);
            }
            
            //Gravity Handler
            Gravity();
        }
        
        private function mouseClickDown(evt:Event):void
        {
            this.MOUSE_ACTIVATE = true;
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseClickUp);
            stage.removeEventListener(MouseEvent.MOUSE_DOWN, mouseClickDown);
        }

        private function mouseClickUp(evt:Event):void
        {
            this.MOUSE_ACTIVATE = false;
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseClickDown);
            stage.removeEventListener(MouseEvent.MOUSE_UP, mouseClickUp);
        }

        private function createDot():void
        {
            //sprayer
            var d:int = this.Density;
            
            if (mouseX > BOXLEFT && mouseX < BOXRIGHT && mouseY > BOXUP && mouseY < BOXDOWN) {
            for (var i:int = 0;i<=d;i++)
            {
                //dot placer + saver
                if (this.countDots < this.maxDots) {
                    this.getDot[this.countDots]         =    this.elements[this.elements.type.name].call();
                    this.getDot[this.countDots].posx    =    mouseX + (Math.random()*d)-(Math.random()*d);
                    this.getDot[this.countDots].posy    =    mouseY + (Math.random()*d)-(Math.random()*d);
                    
                    this.countDots+=1;
                }
            }
            }
        }
        
        private function Gravity():void
        {
            var velocity:Number = 9.81;
            var variable:Number = 0;
            var n:Object;
            
            var particles:Array = new Array();
            var particle:Point;
            for (var a:int=0; a < this.countDots; a++)
            {
                particle    = new Point(this.getDot[a].posx, this.getDot[a].posy);
                particles.push(particle);
            }
            
            for (var i:int=0; i<this.countDots; i++) {
                n    =    this.getDot[i];
                
                var oldx:int    =    n.posx;
                var oldy:int    =    n.posy;
                var newx:int    =    n.posx;
                var newy:int    =    n.posy;
                
                //gravitational effect
                variable=velocity * n.mass;
                variable += this.getRand(3);
                variable=variable / 5;
                newy = oldy + variable;
                
                //borders
                if (newx > 460) newx = 0;
                if (newy >= 370) newy = 370;

                /*
                element blocker
                v3.0
                */
                
                /*
                //fall method
                var search:Point =new Point(newx, newy);
                var match:int    =particles.indexOf(newx);
                if (match > 0)
                {
                    if (oldy < particles[match].y)
                    {
                        if (newy >= particles[match].y) newy-=1;
                    }
                }
                */
                /*
                element blocker
                v1.x
                */
                
                var m:Object;
                var getColor:uint=n.color;
                for (var e:int=0; e<this.countDots; e++)
                {
                    m =    getDot[e];
                    if (n != m) {
                    if (m.posx == oldx)
                    {
                        if (variable < 0)
                        {
                            if (oldy > m.posy)
                            {
                                if (oldy-1 <= m.posy) newy=oldy-1;
                                if (newy <= m.posy) newy=oldy;
                            }
                        }else{
                            if (oldy < m.posy)
                            {
                                if (newy >= m.posy)
                                {
                                    newy=oldy;
                                    if (oldy+1.5 < m.posy) newy=oldy+1.5;
                                }
                            }
                        }
                    }
                    }
                }
                //*/
                //liquid (vanderwaals) effect
                if (n.movable == true) {
                    if (newy == oldy) {
                        variable = this.getRand(n.mass+2);
                        if (oldx - variable != m.posx)
                        {
                            newx = oldx - variable;
                        }
                    }
                }
                
                if (newx < 0) newx = 460;
                if (newy < 0) newy = 0;
                
                n.posx=newx;
                n.posy=newy;
            }
        }

        
        private function mainframe():TextField
        {
            //mainframe
            var mainframe:TextField = new TextField();
            mainframe.x           =    0;
            mainframe.y           =    0;
            mainframe.width       =    460;
            mainframe.height      =    60;
            mainframe.textColor   =    0xFFFFFF;
            
            mainframe.background  =    true;
            mainframe.backgroundColor = 0x333333;
            addChild(mainframe);
            
            return mainframe;
        }
        
        private function getRand(x:Number):Number {
            var y:Number = Math.random() * x;
            var z:Number = Math.random() * x;
            
            return y-z;
        }
        
        private function ElementButton(x:Number, y:Number, e:Object):Sprite
        {
            var txt:TextField           =    new TextField();
            var gfx:Sprite              =    new Sprite();
            var parent:Sprite           =    new Sprite();
            
            gfx.graphics.beginFill(0x300000);
            gfx.graphics.drawRect(0, 0, 100, 17);
            gfx.graphics.endFill();
            gfx.buttonMode =    false;
            gfx.visible    =    false;
            
            txt.defaultTextFormat    =    LetterType("Verdana");
            
            txt.text       =    e.name;
            txt.width      =    100;
            txt.height     =    17;
            txt.textColor  =    e.color;
            txt.selectable =    false;
            
            parent.x       =    x;
            parent.y       =    y;
            
            parent.addChild(gfx);
            parent.addChild(txt);
            
            addChild(parent);
            parent.addEventListener(MouseEvent.ROLL_OVER, function ():void { gfx.visible = true; });            
            parent.addEventListener(MouseEvent.ROLL_OUT, function ():void  { gfx.visible = false; });            
            parent.addEventListener(MouseEvent.CLICK, function ():void     { elements.type = e; });
            
            return parent;
        }
        
        private function LetterType(myfont:String, size:Number=12, color:uint=0xFFFFFF, underline:Boolean=false):TextFormat
        {
            
            var format:TextFormat =    new TextFormat();
            format.font           =    myfont;
            format.color          =    color;
            format.size           =    size;
            format.underline      =    underline;
            
            return format;
        }

        
    }
}

class Dot
{
    public var name:String     =    "blanco";
    public var color:uint      =    0x000000;
    public var posx:int        =    0;
    public var posy:int        =    0;
    public var mass:Number        =    0;
    public var movable:Boolean =    false;
}

class Elements
{
    public var type:Object = Stone();
    
    public function getType():Object
    {
        return type;
    }

    public function Gas():Dot
    {
        var dot:Dot =    new Dot();
        dot.name    =    "Gas";
        dot.mass    =    -1;
        dot.color   =    0x333333;
        dot.movable =    true;
        return dot;
    }
    
    public function Water():Dot
    {
        var dot:Dot =    new Dot();
        dot.name    =    "Water";
        dot.mass    =    1;
        dot.color   =    0x000088;
        dot.movable =    true;
        return dot;
    }
    
    public function Stone():Dot
    {
        var dot:Dot =    new Dot();
        dot.name    =    "Stone";
        dot.mass    =    5;
        dot.color   =    0x777777;
        return dot;
    }
    
    public function Sand():Dot
    {
        var dot:Dot =    new Dot();
        dot.name    =    "Sand";
        dot.mass    =    1;
        dot.color   =    0xFFCC66;
        return dot;
    }
}












