/**
 * Copyright Etienne.Verhote ( http://wonderfl.net/user/Etienne.Verhote )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mhX4
 */

// forked from Etienne.Verhote's forked from: WaterEffect (4)
// forked from ProjectNya's WaterEffect (4)
////////////////////////////////////////////////////////////////////////////////
// WaterEffect (4)
//
// 置き換えマップ効果 (3)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=480
// BitmapDataでノイズ生成 (3)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=481
// [AS3.0] PerlinNoiseクラスに挑戦！
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1114
//
// 動作を軽くするための方法 (東京てらこ7 @trick7)
// Bitmap.filters を使わず、BitmapData.applyFilter() を用いる
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.events.Event;
    import flash.geom.Rectangle;
    import flash.geom.Matrix;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.display.Bitmap;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var water:WaterEffect;
        private var loader:PhotoLoader;
        //private var filePath:String = "http://www.project-nya.jp/images/flash/sunflare.png";
        private var basePath:String = "http://assets.wonderfl.net/images/related_images/";
        private var filePath:String = "e/e4/e445/e4454672f2d5f1b3079afae9666ec52b8575fde0";
        private var faded:Boolean = true;

        public function Main() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            init();
        }

        private function init():void {
            graphics.beginFill(0xFFFFFF);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            var rect:Rectangle = new Rectangle(0, 0, 465, 465);
            water = new WaterEffect(rect);
            addChild(water);
            water.addEventListener(WaterEffect.COMPLETE, complete, false, 0, true);
            loader = new PhotoLoader();
            loader.addEventListener(Event.INIT, initialize, false, 0, true);
            loader.load(basePath + filePath, true);
        }
        private function initialize(evt:Event):void {
            var bitmap:Bitmap = Bitmap(evt.target.content);
            var matrix:Matrix = new Matrix();
            matrix.translate(32, 32);
            water.setup(bitmap, matrix, 400);
            water.wave(0.8, 0.8);
        }
        private function complete(evt:Event):void {
            var timer:Timer = new Timer(1000, 1);
            timer.addEventListener(TimerEvent.TIMER_COMPLETE, exchange, false, 0, true);
            timer.start();
        }
        private function exchange(evt:TimerEvent):void {
            evt.target.removeEventListener(TimerEvent.TIMER_COMPLETE, exchange);
            faded = !faded;
            if (faded) {
                water.wave(0.8, 0.8);
            } else {
                water.wave(0.8, 0.8);
            }
        }

    }

}


//////////////////////////////////////////////////
// WaterEffectクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.DisplayObject;
import flash.events.Event;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.Matrix;
import flash.geom.ColorTransform;
import flash.events.Event;
import flash.filters.DisplacementMapFilter;
import flash.display.BitmapDataChannel;
import flash.filters.DisplacementMapFilterMode;
import flash.filters.BlurFilter;
import flash.display.BlendMode;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.easing.Linear;
import org.libspark.betweenas3.easing.Quad;
import frocessing.color.ColorHSV;

class WaterEffect extends Sprite {
    private var rect:Rectangle;
    private var noise:PerlinNoise;
    private static var octaves:uint = 1;
    private static var channel:uint = BitmapDataChannel.RED;
    private var speeds:Array;
    private var target:DisplayObject;
    private var container:Bitmap;
    private var bitmapData:BitmapData;
    private var mapfilter:DisplacementMapFilter;
    private var blurfilter:BlurFilter;
    private var matrix:Matrix;
    private static var baseScale:Number;
    private var _scale:Number = 0;
    private var _size:Number = 0;
    private static var time:Number = 2;
    private var colorTrans:ColorTransform;
    private var color:ColorHSV;
    private var hue:Number = 0;
    private var saturation:Number = 8;
    public static const COMPLETE:String = Event.COMPLETE;

    public function WaterEffect(r:Rectangle) {
        rect = r;
        init();
    }

    private function init():void {
        noise = new PerlinNoise(rect, 32, 32, octaves, false, channel);
        speeds = new Array();
        for (var n:uint = 0; n < octaves; n++) {
            var sx:Number = (Math.random() - 0.5)*3;
            var sy:Number = (Math.random() - 0.5)*3 + 2.5;
            speeds.push(new Point(sx, sy));
        }
        bitmapData = new BitmapData(rect.width, rect.height, true, 0x000000);
        container = new Bitmap(bitmapData);
        addChild(container);
        map = 0;
        blur = 0;
        colorTrans = new ColorTransform(1);
        color = new ColorHSV(1, 0.8);
        colorTrans.color = color.value;
    }
    public function setup(t:DisplayObject, m:Matrix = null, bs:Number = 0):void {
        target = t;
        matrix = m;
        bitmapData.fillRect(rect, 0x000000);
        bitmapData.draw(target, matrix, colorTrans, BlendMode.ADD, null, true);
        container.bitmapData = bitmapData.clone();
        baseScale = bs;
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    public function wave(from:Number = 0, to:Number = 1):void {
        tween(from, to);
    }
    private function tween(from:Number = 0, to:Number = 1):void {
        var itween:ITween = BetweenAS3.parallel(
            BetweenAS3.tween(container, {alpha: to}, {alpha: from}, time, Linear.easeNone), 
            BetweenAS3.tween(this, {map: to}, {map: from}, time, Quad.easeOut), 
            BetweenAS3.tween(this, {blur: to}, {blur: from}, time, Linear.easeNone)
        );
        itween.addEventListener(TweenEvent.COMPLETE, complete, false, 0, true);
        itween.play();
    }
    private function update(evt:Event):void {
        noise.update(speeds);
        bitmapData.lock();
        container.bitmapData.lock();
        bitmapData.fillRect(rect, 0x000000);
        bitmapData.draw(target, matrix, colorTrans, BlendMode.ADD, null, true);
        container.bitmapData.applyFilter(bitmapData, bitmapData.rect, new Point(), mapfilter);
        container.bitmapData.applyFilter(container.bitmapData, bitmapData.rect, new Point(), blurfilter);
        bitmapData.unlock();
        container.bitmapData.unlock();
        color.h = 195 + Math.sin(hue*Math.PI/180)*15;
        colorTrans.color = color.value;
        hue ++;
    }
    private function complete(evt:TweenEvent):void {
        dispatchEvent(new Event(COMPLETE));
    }
    public function get map():Number {
        return _scale;
    }
    public function set map(param:Number):void {
        _scale = param;
        var scale:Number = baseScale*(1 - _scale);
        mapfilter = new DisplacementMapFilter(noise, new Point(), channel, channel, scale, scale, DisplacementMapFilterMode.COLOR);
    }
    public function get blur():Number {
        return _size;
    }
    public function set blur(param:Number):void {
        _size = param;
        var size:Number = baseScale*(1 - _size)/10;
        blurfilter = new BlurFilter(size, size, 3);
    }

}


//////////////////////////////////////////////////
// PerlinNoiseクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.ColorTransform;

class PerlinNoise extends BitmapData {
    private var bx:uint;
    private var by:uint;
    private var octaves:uint;
    private var seed:uint;
    private var stitch:Boolean = true;
    private var fractalNoise:Boolean = true;
    private var channel:uint = 0;
    private var grayScale:Boolean = true;
    private var offsets:Array = new Array();

    public function PerlinNoise(rect:Rectangle, x:uint, y:uint, o:uint = 1, g:Boolean = true, c:uint = 0, s:uint = 1, st:Boolean = false, f:Boolean = true) {
        super(rect.width, rect.height, false, 0x000000);
        bx = x;
        by = y;
        octaves = o;
        grayScale = g;
        channel = c;
        if (grayScale) channel = 0;
        for (var n:uint = 0; n < octaves; n++) {
            var point:Point = new Point();
            offsets.push(point);
        }
        stitch = st;
        fractalNoise = f;
        create(s, offsets);
    }

    private function create(s:uint, o:Array = null):void {
        seed = s;
        offsets = o;
        if (offsets == null) offsets = [new Point()];
        lock();
        perlinNoise(bx, by, octaves, seed, stitch, fractalNoise, channel, grayScale, offsets);
        draw(this);
        unlock();
    }
    public function update(speeds:Array):void {
        for (var n:uint = 0; n < octaves; n++) {
            var offset:Point = offsets[n];
            var speed:Point = speeds[n];
            offset.x += speed.x;
            offset.y += speed.y;
        }
        lock();
        perlinNoise(bx, by, octaves, seed, stitch, fractalNoise, channel, grayScale, offsets);
        draw(this);
        unlock();
    }

}


//////////////////////////////////////////////////
// PhotoLoaderクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.display.Bitmap;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.system.LoaderContext;

class PhotoLoader extends Sprite {
    private var loader:Loader;
    private var info:LoaderInfo;
    public var content:*;
    private var smoothing:Boolean;
    public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
    public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
    public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
    public static const INIT:String = Event.INIT;
    public static const COMPLETE:String = Event.COMPLETE;

    public function PhotoLoader() {
        loader = new Loader();
        info = loader.contentLoaderInfo;
    }

    public function load(file:String, s:Boolean = false):void {
        smoothing = s;
        info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        info.addEventListener(Event.INIT, initialize, false, 0, true);
        info.addEventListener(Event.COMPLETE, complete, false, 0, true);
        try {
            loader.load(new URLRequest(file), new LoaderContext(true));
        } catch (err:Error) {
            trace(err.message);
        }
    }
    public function unload():void {
        loader.unload();
    }
    private function ioerror(evt:IOErrorEvent):void {
        loader.unload();
        dispatchEvent(new Event(PhotoLoader.IO_ERROR));
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        dispatchEvent(new Event(PhotoLoader.HTTP_STATUS));
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        dispatchEvent(new Event(PhotoLoader.SECURITY_ERROR));
    }
    private function initialize(evt:Event):void {
        if (smoothing) {
            content = Bitmap(info.content);
            content.smoothing = true;
        } else {
            content = info.content;
        }
        dispatchEvent(new Event(PhotoLoader.INIT));
    }
    private function complete(evt:Event):void {
        info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        info.removeEventListener(Event.INIT, initialize);
        info.removeEventListener(Event.COMPLETE, complete);
        addChild(loader);
        dispatchEvent(new Event(PhotoLoader.COMPLETE));
    }

}
