/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mhOL
 */

// forked from siouxcitizen's Away3D練習4　3種類のMaterialでCube表示
// forked from siouxcitizen's Away3D練習3　3種類のMaterialでSphere表示
// forked from siouxcitizen's Away3D練習2　3種類のMaterialでPlane表示
// forked from siouxcitizen's Away3D練習1　Plane表示
// forked from siouxcitizen's forked from: Away3Dの練習
// forked from ser1zw's Away3Dの練習
//
//以下のサイトとコードを参考にさせていただきました
//サイト
//Away3D Basics 6 - The Color Materials
//http://www.flashmagazine.com/tutorials/detail/away3d_basics_6_-_materials_and_light_part_1/
//コード
//http://www.flashmagazine.com/articlefiles/away3d/ExPhongColorMaterial.as

package {
  import flash.display.Sprite;
  import flash.events.Event;
  import flash.events.MouseEvent;
  import flash.geom.Vector3D;

  import away3d.containers.View3D;
  import away3d.primitives.Cone;
  import away3d.materials.ShadingColorMaterial;
  import away3d.materials.PhongColorMaterial;
  import away3d.lights.DirectionalLight3D

  [SWF(frameRate="60", backgroundColor="#ffffff")]
  public class Away3DTest extends Sprite {
    private var view:View3D;

    private var shadingColorCone : Cone;
    private var phongColorCone : Cone;
    
    private var shadingColorMaterial:ShadingColorMaterial;
    private var phongColorMaterial:PhongColorMaterial;
    private var light:DirectionalLight3D;
    
    public function Away3DTest() {

      view = new View3D();
      view.x = stage.stageWidth >> 1;
      view.y = stage.stageHeight >> 1;
      addChild(view);

      shadingColorMaterial = new ShadingColorMaterial(0x0000ff);
      phongColorMaterial = new PhongColorMaterial(0x0000ff);

      shadingColorCone = new Cone({radius:100, height:200});
      phongColorCone = new Cone({radius:100, height:200});

      shadingColorCone.material = shadingColorMaterial;
      phongColorCone.material = phongColorMaterial;

      shadingColorCone.x = -100;
      phongColorCone.x = 100;

      view.scene.addChild(shadingColorCone);
      view.scene.addChild(phongColorCone);

      light = new DirectionalLight3D();
      light.direction = new Vector3D(500,-300,200);
      view.scene.addLight(light);

      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }

    private function onEnterFrame(e:Event):void {
      shadingColorCone.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
      shadingColorCone.rotationY = stage.mouseX - (stage.stageWidth >> 1);

      phongColorCone.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
      phongColorCone.rotationY = stage.mouseX - (stage.stageWidth >> 1);

      view.render();
    }
  }
}
            