/**
 * Copyright qaddodi ( http://wonderfl.net/user/qaddodi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mhNz
 */

package
{
    import flash.display.Sprite;
    import flash.display.StageQuality;
    import flash.events.Event;
    
    public class Fireball extends Sprite
    {
        public var i:int;
        public var j:int;
        public var blockWidth:Number = 50;
        public var numberOfBlocks:int;
        public var rows:int = 5;
        public var numberOfFlames:int = 13;
        public var colors:Array = new Array();
        
        public var bar:Bar = new Bar(100);
        public var ball:Ball = new Ball(5,7,7);
        public var blocks:Array = new Array();
        public var flames:Array = new Array();
        
        public var background:Sprite = new Sprite();
        public function Fireball()
        {
            background.graphics.beginFill(0);
            background.graphics.drawRect(0,0,stage.stageWidth, stage.stageHeight);
            background.graphics.endFill();
            addChild(background);
            drawFlames();
            drawBar();
            drawBlocks(rows);
            drawBall();
            addEventListener(Event.ENTER_FRAME,loop);
        }
        
        public function loop(e:Event):void{
            bar.xSpeed = (mouseX -bar.gfx.x - bar.gfx.width/2)/4;
            bar.gfx.x+=bar.xSpeed;
            
            ball.gfx.x += ball.xSpeed;
            ball.gfx.y += ball.ySpeed;
            moveFlames();
            hitTests();
            
        }
        
        public function hitTests():void{
            if(ball.gfx.y>stage.stageHeight){removeChild(ball.gfx);drawBall()};
            if(ball.gfx.hitTestObject(bar.gfx)){
                ball.xSpeed = (ball.gfx.x-(bar.gfx.x+bar.gfx.width/2))/(bar.gfx.width/2)*7;
                ball.ySpeed *= -1;
            }
            if(ball.gfx.x>stage.stageWidth){ball.xSpeed*=-1};
            if(ball.gfx.x<0){ball.xSpeed*=-1};
            if(ball.gfx.y<0){ball.ySpeed*=-1};
            for (i=0;i<(stage.stageWidth/blockWidth)-2;i++){
                for(j=0;j<rows;j++){
                    if(blocks[i][j].hit == false){
                        if(ball.gfx.hitTestObject(blocks[i][j].gfx)){
                            ball.xSpeed = (ball.gfx.x-(blocks[i][j].gfx.x+blocks[i][j].gfx.width/2))/(blocks[i][j].gfx.width/2)*7;
                            ball.ySpeed*=-1;
                            blocks[i][j].hit = true;
                        }
                    }else{
                        if(blocks[i][j].gfx.alpha>0){blocks[i][j].gfx.alpha -= .2};
                    }
                }
            }
        }
        
        public function drawBar():void{
            bar.gfx.x = stage.stageWidth/2-bar.gfx.width/2;
            bar.gfx.y = stage.stageHeight - bar.gfx.height - 5;
            addChild(bar.gfx);
            
        }
        public function drawBlocks(rows:Number):void{
            numberOfBlocks = 0;
            for(i=0;i<(stage.stageWidth/blockWidth)-3;i++){
                blocks[i] = new Array();
                for(j=0; j<rows; j++){
                    blocks[i][j] = new Block(blockWidth);
                    blocks[i][j].gfx.x = 30 + i*(blocks[i][j].gfx.width+10);
                    blocks[i][j].gfx.y = 20 + j* (blocks[i][j].gfx.height+5);
                    addChild(blocks[i][j].gfx);
                    numberOfBlocks++;
                }
            }
        }
        
        public function drawBall():void{
            ball.gfx.x = stage.stageWidth/2;
            ball.gfx.y = stage.stageHeight/2;
            addChild(ball.gfx);
        }
        
        public function drawFlames():void{
            for(i=0;i<numberOfFlames;i++){
                flames[i] = new Flame((numberOfFlames-i)*0.5,0xFF0000,0xFFFF00,0.5);
                addChild(flames[i].gfx);
            }
        }
        public function moveFlames():void{
            for(i=0;i<numberOfFlames;i++){
                if(i==0){
                    flames[i].xSpeed = (ball.gfx.x - flames[i].gfx.x)/1;
                    flames[i].ySpeed = (ball.gfx.y - flames[i].gfx.y)/1;
                }else{
                    flames[i].xSpeed = (flames[i-1].gfx.x-flames[i].gfx.x)/1.5;
                    flames[i].ySpeed = (flames[i-1].gfx.y-flames[i].gfx.y)/1.5;
                }
                
                flames[i].gfx.x+=flames[i].xSpeed;
                flames[i].gfx.y+=flames[i].ySpeed;
            }
        }
        
        
    }
}
import flash.display.Sprite;

class Bar{
    public var xSpeed:Number;
    public var ySpeed:Number;
    public var gfx:Sprite = new Sprite();
    public function Bar(w:Number){
        gfx.graphics.beginFill(0xFF0000,0.5);
        gfx.graphics.drawRoundRect(0,-3,w,10,10);
        gfx.graphics.endFill();
        gfx.graphics.beginFill(0xFFFFFF);
        gfx.graphics.drawRoundRect(0,0,w,10,10);
        gfx.graphics.endFill();
    }
}

class Block{
    public var hit:Boolean = false;
    public var gfx:Sprite = new Sprite();
    public function Block(w:Number){
        gfx.graphics.beginFill(Math.random()*0xFFFFFF);
        gfx.graphics.drawRect(0,0,w,20);
        gfx.graphics.endFill();
    }
}

class Ball{
    public var xSpeed:Number;
    public var ySpeed:Number;
    public var gfx:Sprite = new Sprite();
    public function Ball(r:Number,xSp:Number, ySp:Number){
        xSpeed = xSp;
        ySpeed = ySp;
        gfx.graphics.beginFill(0xFFFFFF);
        gfx.graphics.drawCircle(0,0,r);
        gfx.graphics.endFill();
    }
}
class Flame{
    public var xSpeed:Number;
    public var ySpeed:Number;
    public var gfx:Sprite = new Sprite();
    public function Flame(r:Number, c1:Number, c2:Number, a:Number){
        gfx.graphics.beginFill(c1,a);
        gfx.graphics.drawCircle(0,0,r);
        gfx.graphics.endFill();
        gfx.graphics.beginFill(c2,a);
        gfx.graphics.drawCircle(0,2,r);
        gfx.graphics.endFill();
    }
}