/**
 * Copyright turipat ( http://wonderfl.net/user/turipat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mgyo
 */

package {
	import flash.events.*;
	import flash.ui.Keyboard;
	import flash.display.*;
	import flash.events.Event;
	import org.papervision3d.core.math.Number2D;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.view.Viewport3D;
	import org.papervision3d.cameras.Camera3D;

    public class HelloEvent extends Sprite {
        
        	private var camera: Camera3D;
		private var scene: Scene3D;
		private var viewport: Viewport3D;
		private var renderer: BasicRenderEngine;
		private var cube :Cube;
        
        public function HelloEvent() {
            // write as3 code here..
            		camera = new Camera3D();
			scene = new Scene3D();
			viewport = new Viewport3D(stage.stageWidth, stage.stageHeight);
			renderer = new BasicRenderEngine();
			addChild( viewport );
			var materials :MaterialsList = new MaterialsList( { all : new ColorMaterial(0xD7261C) } );
			cube = new Cube( materials );
			scene.addChild( cube );
			
			stage.addEventListener( KeyboardEvent.KEY_DOWN, onKeyDown );

			renderer.renderScene( scene, camera, viewport );
            
        }
        
        public function onKeyDown(e:KeyboardEvent) :void {
			var len_move:Number = 20;
			switch (e.keyCode) {
				case Keyboard.RIGHT:
					cube.rotationY -= len_move;
					break;
				case Keyboard.LEFT:
					cube.rotationY += len_move;
					break;
				case Keyboard.UP:
					cube.rotationX += len_move;
					break;
				case Keyboard.DOWN:
					cube.rotationX -= len_move;
					break;
					}
			renderer.renderScene( scene, camera, viewport );
	}
}
}