/**
 * Copyright fladdict ( http://wonderfl.net/user/fladdict )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mgwP
 */

package {
    import flash.system.LoaderContext;
    import flash.net.URLRequest;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.display.*;
    public class FlashTest extends Sprite {
        
        public var numberOfBoids:int = 10;
        public var boids:Array = [];
        
        public var mx:int;
        public var my:int;
        public var cursor:Sprite;
        public var file:Sprite;
        public var vx:Number = 0;
        public var vy:Number = 0;
        public var l:Number = 150;
        public var lines:Array = [];
        
        
        public function FlashTest() {
            // write as3 code here..
            this.addEventListener(Event.ENTER_FRAME, enterFrameHandler, false, 0, true);
            this.addEventListener(MouseEvent.MOUSE_MOVE,mouseMoveHandler,false,0,true);
            
            cursor = new Sprite();
            /*
            cursor.graphics.beginFill(0xff0000,1);
            cursor.graphics.drawCircle(0,0,10);
            cursor.graphics.endFill();*/
            this.addChild(cursor);
            
            file = new Sprite();
            file.graphics.beginFill(0xcccccc,1);
            file.graphics.drawRect(-15,0,30,40);
            file.graphics.endFill();
            this.addChild(file);
            
            
            
            createLine(file,cursor);
            
            for(var i:int=0; i<numberOfBoids; i++){
                var mc:MovieClip = new MovieClip();
                /*
                mc.graphics.beginFill(0x000000,1);
                mc.graphics.drawCircle(0,0,10);
                mc.graphics.endFill();*/
                mc.vx = 0;
                mc.vy = 0;
                mc.x = Math.random()*480;
                mc.y = Math.random()*480;
                
                var bird:Loader = new Loader();
                bird.load(new URLRequest("https://dl.dropbox.com/u/262233/exp/bird.png"));
                bird.contentLoaderInfo..addEventListener(Event.COMPLETE, loadedHandler, false, 0, true);
                bird.scaleX = bird.scaleY = Math.random()*0.2+0.15;
                bird.x -=80*0.5;
                bird.y -=56*0.5;
                mc.addChild(bird);
                
                this.boids.push(mc);
                
                createLine(mc, file);
                this.addChild(mc);
            }

        }
        
        public function loadedHandler(e:Event):void
        {
            var o:Object = e.target;
        }

        
        public function enterFrameHandler(e:Event):void
        {
            cursor.x = this.mouseX;
            cursor.y = this.mouseY;
            
            //Spring file
            var dx:Number = file.x - cursor.x;
            var dy:Number = file.y - cursor.y;
            var dist:Number = Math.sqrt(dx*dx+dy*dy);
            var f:Number;
            if(dist<1){
                f = 0;
            }else{
                f = (l - dist);
            }
            vx = vx*0.5 + dx/dist*f;
            vy = vy*0.5 + dy/dist*f + 3;

            file.x += vx;
            file.y += vy;
            file.rotation = Math.atan2(dy,dx)*180/Math.PI-90;
            this.updateBoids();
            this.updateLines();
        }
        
        public function updateBoids():void
        {
            for(var i:int=0; i<boids.length; i++)
            {
                var b0:MovieClip = boids[i];
                var fx:Number = 0;
                var fy:Number = 0;
                for(var j:int=0; j<boids.length;j++)
                {
                    var b1:MovieClip = boids[j];
                    if(b0==b1) continue;
                    
                    
                    
                    var dx:Number = b1.x - b0.x;
                    var dy:Number = b1.y - b0.y;
                    var dist:Number = Math.sqrt(dx*dx+dy*dy);
                    var area:Number = Math.random()*50+70;
                    if(dist<area){
                        fx -= dx / dist*1.5;  
                        fy -= dy / dist*1.5;
                    }else{
                        fx += dx / dist*1.5;
                        fy += dy / dist*1.5;
                    }

                    
                }
                dx = cursor.x - b0.x;
                dy = cursor.y - b0.y;
                dist= Math.sqrt(dx*dx+dy*dy);
                fx += dx/dist*1.5;
                fy += dy/dist*1.5;
                b0.vx = b0.vx*0.9 + fx;
                b0.vy = b0.vy*0.9 + fy;
                b0.x += b0.vx;
                b0.y += b0.vy;
            }

        }

        public function createLine(t0:Sprite, t1:Sprite):void
        {
            var l:Sprite = new Sprite();
            l.graphics.lineStyle(0,0xaaaaaa,1);
            l.graphics.moveTo(0,0);
            l.graphics.lineTo(100,100);
            l.graphics.endFill();
            this.addChild(l);
            
            var line:Object = {};
            line.target1 = t0;
            line.target2 = t1;
            line.sprite = l;
            lines.push(line);
        }

        
        public function updateLines():void
        {
            for(var i:int=0; i<lines.length; i++){
                var l:Object = lines[i];
                l.sprite.x = l.target1.x;
                l.sprite.y = l.target1.y;
                l.sprite.scaleX = (l.target2.x - l.target1.x)/100;
                l.sprite.scaleY = (l.target2.y - l.target1.y)/100;
            }

        }


        public function mouseMoveHandler(e:MouseEvent):void
        {
            this.mx = this.mouseY;
            this.my = this.mouseY;
        }

    }
    
   
}

