/**
 * Copyright makc3d ( http://wonderfl.net/user/makc3d )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mgVa
 */

// forked from makc3d's ff: glowing arcs (test)
// forked from makc3d's glowing arcs + mp3
package {
	import flash.display.*;
	import flash.events.*;
	import flash.media.*;
	import flash.net.*;
	import flash.system.*;
	import flash.utils.ByteArray;

	/**
	 * FFT (above) vs native spectrum calculator (below)
	 */
	public class Swirling extends Sprite {
		public var player:*;
		public function Swirling () {
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, function (e:Event):void {
				loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, arguments.callee);
				player = loader.contentLoaderInfo.content;
				player.loadFromURL("http://www.takasumi-nagai.com/soundfiles/sound001.mp3");
				stage.addEventListener (Event.ENTER_FRAME, loop);
			});
			loader.load(
				new URLRequest("http://makc.github.io/wum/player.swf"),
				new LoaderContext(true, ApplicationDomain.currentDomain)
			);
		}
		public var ba:ByteArray = new ByteArray;
		public function loop (e:Event):void {
			var v:Number, i:int;

			graphics.clear();
			graphics.beginFill (0); graphics.drawRect (0, 0, 465, 465);

			graphics.beginFill(0x3799fc);

			if (!player.magic.areSoundsInaccessible()) {
				player.magic.computeSpectrum(ba, true);
				for (i = 0; i < 256; i++) {
					v = ba.readFloat();
					graphics.drawRect(20 + 1.6 * i, 240 - 100 * v, 1.6, 100 * v);
				}
			}

			graphics.beginFill(0x2669ae);

			if (!SoundMixer.areSoundsInaccessible()) {
				SoundMixer.computeSpectrum(ba, true);
				for (i = 0; i < 256; i++) {
					v = ba.readFloat();
					graphics.drawRect(20 + 1.6 * i, 245, 1.6, 100 * v);
				}
			}
		}
	}
}

