/**
 * Copyright dakkie ( http://wonderfl.net/user/dakkie )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mgAs
 */

package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
        
    public class comeBall extends Sprite {
            private var sunny:Ball;
            private var speed:Number = 10;
            
            public function comeBall(){
                init();
            }
            
            private function init():void {
                stage.scaleMode = StageScaleMode.NO_SCALE;
                stage.align = StageAlign.TOP_LEFT;
                sunny = new Ball();
                sunny.x = stage.stageWidth / 2;
                sunny.y = stage.stageHeight / 2;
                addChild(sunny);
                addEventListener(Event.ENTER_FRAME, onEnterFrame);
            }
            
            private function onEnterFrame(event:Event):void {
                var dx:Number = mouseX - sunny.x;
                var dy:Number = mouseY - sunny.y;
                var angle:Number = Math.atan2(dy, dx);
                sunny.rotation = angle * 180 / Math.PI;
                var vx:Number = Math.cos(angle) * speed;
                var vy:Number = Math.sin(angle) * speed;
                sunny.x += vx;
                sunny.y += vy;
                var left:Number = 0;
                var right:Number = stage.stageWidth;
                var top:Number = 0;
                var bottom:Number = stage.stageHeight;
                
                if (sunny.x + sunny.radius > right) {
                    sunny.x = right - sunny.radius;
                    vx *= -1;
                }
                else if (sunny.x - sunny.radius < left) {
                    sunny.x = left + sunny.radius;
                    vx *= -1;
                }
                if (sunny.y + sunny.radius > bottom) {
                    sunny.y = bottom - sunny.radius;
                    vy *= -1;
                }
                else if (sunny.y - sunny.radius < top) {
                    sunny.y = top + sunny.radius;
                    vy *= -1;
                }
            }
    }
}

import flash.display.Sprite;

class Ball extends Sprite {
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var radius:Number = 20;
    
    public function Ball(){
        init();
    }
        
    public function init():void {
        graphics.beginFill(0xff0000);
        graphics.drawCircle(0,0,20);
        graphics.endFill();
  }
}