/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mg4p
 */

// forked from gaina's soundtest17
package 
{
    import com.bit101.components.Label;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.media.SoundMixer;
    import flash.utils.ByteArray;
    
    /**
     * ...
     * @author gaina
     */
    
    [SWF(width="465",height="465")]
    public class Main extends Sprite 
    {
        private var _sound:SoundPlay;
        private var _arr:Array;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            _sound = new SoundPlay("http://www.takasumi-nagai.com/","soundfiles/sound005.mp3");
            _sound.load();
            _sound.addEventListener(Event.COMPLETE, Completed);
            
            _arr = SquereArray();
        }
        
        private function Completed(e:Event):void 
        {
            _sound.play();
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void 
        {
            var _byte:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(_byte, false, 0);
            
            for (var i:int = 0; i < 16; i++) {
                _byte.position = i * 32;
                
                //var _sp:Sprite = _arr[i][0] as Sprite;
                
                for (var j:int = 0; j < 4; j++) {
                    var _s:Sprite = _arr[i][1][j] as Sprite;
                    _s.x = 0;
                    _s.y = 0;
                    
                    _s.x =  (_byte.readFloat() + _byte.readFloat() + _byte.readFloat() + _byte.readFloat()) * 10;
                    _s.y =  (_byte.readFloat() + _byte.readFloat() + _byte.readFloat() + _byte.readFloat()) * 10;
                }
            }
        }
        
        private function SquereArray():Array
        {
            
            var arr:Array = [];
            
            for ( var i:int = 0; i < 16; i++)
            {
                var _array:Array = [];
                var _sp:Sprite = new Sprite();
                _sp.graphics.lineStyle(1, 0);
                _sp.graphics.drawRoundRect( -55, -55, 110, 110, 0);
                _sp.graphics.endFill();
                
                _sp.x = 60 + 115 * (i % 4);
                _sp.y = 60 + 115 * Math.floor(i / 8); // original 4
                
                addChild(_sp);
                _array.push(_sp);
                
                var array:Array = [];
                
                for (var j:int = 0; j < 4; j++)
                {
                    var _child:Sprite = new Sprite();
                    _child.graphics.lineStyle(1, 0);
                    _child.graphics.drawCircle(0, 0, 25);
                    _child.graphics.endFill();
                    
                    _sp.addChild(_child);
                    
                    array.push(_child);
                }
                _array.push(array);
                
                arr.push(_array);
                
                var _label:Label = new Label(_sp, -4, 35, (i + 1).toString());
            }
            
            return arr;
        }
        
    }
    
}
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.IOErrorEvent;
import flash.events.ProgressEvent;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundLoaderContext;
import flash.media.SoundTransform;
import flash.net.URLRequest;
import flash.system.Security;


class SoundPlay extends EventDispatcher
{
    private var _sound:Sound;
    private var _channel:SoundChannel;
    private var _url:String;
    
    public function SoundPlay(_domain:String , url:String)
    {
        Security.allowDomain(_domain);        
        
        _url = _domain+url;
        _sound = new Sound();
    }
    
    public function load():void
    {
        var _context:SoundLoaderContext = new SoundLoaderContext(1000, true);
        _sound.load(new URLRequest(_url), _context);
        _sound.addEventListener(ProgressEvent.PROGRESS, onProgress);
        _sound.addEventListener(IOErrorEvent.IO_ERROR, onIOError);
        _sound.addEventListener(Event.COMPLETE, SoundLoaded);
    }
    
    public function play():void
    {
        _sound.play(0, 100, new SoundTransform(0.4, 0));
    }
    
    private function onIOError(e:IOErrorEvent):void 
    {
        dispatchEvent(new IOErrorEvent(IOErrorEvent.IO_ERROR));
    }
    
    private function onProgress(e:ProgressEvent):void 
    {
        dispatchEvent(new ProgressEvent(ProgressEvent.PROGRESS));
    }
    
    private function SoundLoaded(e:Event):void 
    {
        _sound.removeEventListener(IOErrorEvent.IO_ERROR, onIOError);
        _sound.removeEventListener(ProgressEvent.PROGRESS, onProgress);
        _sound.removeEventListener(Event.COMPLETE, SoundLoaded);
        dispatchEvent(new Event(Event.COMPLETE));
    }
}