/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mfOK
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix3D;
    import flash.geom.Point;
    import flash.geom.Utils3D;
    import flash.geom.Vector3D;
    
    public class Triangles_test extends Sprite
    {
        
        private var vertices1:Vector.<Number>;
        private var indices:Vector.<int>;
        private var uv:Vector.<Number>;
        
        private var rot:Number = 0;
        
        private var bd1:BitmapData;
        private var bd2:BitmapData;
        
        private var bd:BitmapData;
        
        private var s:Shape;
        private var g:Graphics;
        
        public function Triangles_test()
        {
            vertices1 = new <Number>[0,0,0, 100,100,0, -100,100,0, 0,0,10, 100,100,10, -100,100,10];
            
            indices = new <int>[];
            uv = new <Number>[1/2,1/2,0, 0/2,1/2,0, 1/2,0/2,0];
            uv.push(1/2+1/2,1/2+1/2,0, 0/2+1/2,1/2+1/2,0, 1/2+1/2,0/2+1/2,0);
            
            bd1 = new BitmapData(128,128, false, 0);
            addChild( new Bitmap( bd1 ));
            bd2 = new BitmapData(128,128, false, 0);
            addChild( new Bitmap( bd2 )).y=128;
            
            bd = new BitmapData(256,128, false, 0);
            addChild( new Bitmap(bd) ).y = 256;
            
            addChild( (s = new Shape()) );
            this.g = s.graphics;
            
            for( var b:int = 0; b <= 128; b++)
            {
                for( var g:int = 0; g <= 128; g++)
                {
                    bd1.setPixel( g,b, ((g*2) << 8) | (b*2));
                }
            }
            for(g = 0; g<128; g++)
            {
                for(var r:int = 0; r<128; r++)
                {
                    bd2.setPixel( r,g, ((r*2) << 16) | ((g*2)<<8));
                }
            }
            
            bd.copyPixels( bd1, bd1.rect, new Point(0,0));
            bd.copyPixels( bd2, bd2.rect, new Point(128,0) );
            
            addEventListener(Event.ENTER_FRAME, onEnter);
        }
        private function onEnter(e:Event):void
        {
            rot++;
            var m:Matrix3D = new Matrix3D();
            m.appendRotation( rot, Vector3D.Y_AXIS);
            m.appendTranslation( 232, 121, 0 );
            var pv1:Vector.<Number> = new Vector.<Number>();
            var _blank:Vector.<Number> = new Vector.<Number>();            
            
            Utils3D.projectVectors(m, vertices1, pv1, uv);
            
            g.clear();
            g.lineStyle( 1, 0xFF0000 );
            
            g.beginBitmapFill( bd );
            g.drawTriangles(pv1, null, uv);
            g.endFill();
            
        }
    }
}