/**
 * Copyright kikiroom ( http://wonderfl.net/user/kikiroom )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mfHh
 */

// forked from kawamura's 岡本太郎的な何か
package {
    import flash.display.MovieClip;
    import flash.events.MouseEvent;
    import flash.events.Event;
    public class Main extends MovieClip{
        private var k:Number = 0.005;
        private var u:Number = 0.008
        private var hand_list:Vector.<Hand>;
        
        public function Main():void{
            this.buttonMode = true;
            var bg_mc:MovieClip = new MovieClip();
            addChild( bg_mc );
            bg_mc.graphics.beginFill(0xFF0000,0);
            bg_mc.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            bg_mc.addEventListener(MouseEvent.CLICK,bg_click);
            //
            var i:uint ;
            var hand:Hand ;
            hand_list = new Vector.<Hand>();
            for( i = 0; i < 4 ; i++){
                hand = new Hand();
                addChild( hand );
                hand.init(i);
                hand.y =  50 + 10* Math.random() + 120*i  ;
                hand.sy = hand.y;
                hand.vy=1 * Math.cos(2*Math.PI * Math.random());
                hand.wave_click();
                hand.addEventListener(Event.ENTER_FRAME,hand_enterframe);
                hand_list.push(hand);
            }
        }
        public function shock_hand(hand:Hand):void{
            hand.vy=1 * Math.cos(2*Math.PI * Math.random());
            
        }
        private function bg_click(event:MouseEvent):void{
            var i:uint = 0;
            var n:uint = hand_list.length;
            for( i=0 ;i<n ;i++){
                var hand:Hand = hand_list[i];
                hand.wave_click();
                shock_hand(hand);
            }
        }
        private function hand_enterframe(event:Event):void{
            var hand:Hand = Hand(event.currentTarget);
            var ay :Number = k * ( hand.sy - hand.y);
            hand.vy +=  ay - u*hand.vy; 
            hand.y += hand.vy;
        }
    }
}

import flash.display.MovieClip;
import flash.display.Graphics;
import flash.events.Event;
import flash.events.MouseEvent;
class Hand extends MovieClip{
    public var vy:Number = 0;
    public var sy:Number;
    private var id:uint;
    private var stage_width:uint;
    private var stage_height:uint;
    private var g:Graphics;
    private var lag : Number;
    private var wave_speed:Number;
    private var cnt_speed:Number;
    private var wave_height:Number;
    private var wave_under:Number;
    private var wave_length:Number;
    private var long_length :Number ;
    private var long_height:Number
    private var cnt:Number = 2*Math.PI*Math.random();
    private var wave_cnt:Number =2*Math.PI*Math.random();
    private var shock_speed:Number = 0;
    public function Hand(){
        lag = 1.4+ 0.6*Math.random();
        wave_speed =0.01 +0.01 *Math.random();
        cnt_speed = 0.01 + 0.01 *  Math.random();
        wave_height = 20 +5* Math.random();
        wave_under = 1+ 4 * Math.random();
        wave_length =0.010 + 0.015*Math.random();
        long_length = 0.008 + 0.004*Math.random();
        long_height = 8 + 2 * Math.random();
        //
        this.addEventListener(MouseEvent.CLICK,wave_click,false,0,false);
    }
    public function init(value :uint):void{
        id  = value;
        stage_width = stage.stageWidth;
        stage_height = stage.stageHeight;
        g = this.graphics;
        addEventListener(Event.ENTER_FRAME,enter_frame);
    }
    public function wave_click(event:Event = null):void{
        Main(this.parent).shock_hand(this);
        shock_speed = 0.15 + 0.2 * Math.random();
    }
    private function enter_frame(event:Event):void{
        shock_speed *= 0.975
        wave_cnt += wave_speed
        cnt += cnt_speed + (cnt_speed *0.75)* Math.sin(wave_cnt) + shock_speed;
        draw_line(cnt)
    }
    private function draw_line(cnt:Number):void{
        g.clear();
        g.beginFill( 0XB60000);
        var small_height:Number = (10 + 20 * shock_speed);
        var i:int;
        var _height:Number ; 
        if( id%2 ==0){
            _height = -1*wave_height + long_height * Math.sin( cnt * 3)  + small_height * Math.sin( cnt );
        }else{
            _height = -1 * ( wave_height - wave_under) - long_height * Math.sin( cnt*3 )  -  small_height * Math.sin( cnt );
        }
        g.moveTo(0 ,  _height);
        for( i = 1 ;  i <= stage_width ;i++){
            if( id%2 ==0){
                g.lineTo(i, -1 * wave_height + wave_under * (i/stage_width) + long_height *Math.sin( i* long_length + cnt * 3)  + small_height * Math.sin( i * wave_length + cnt ) );
            }else{
                g.lineTo(i, -1 * ( wave_height - wave_under) - 1*wave_under * (i/stage_width) - long_height *Math.sin( i * long_length + cnt * 3 )  -  small_height * Math.sin( i * wave_length + cnt) );
            }
        }
        for( i = stage_width ;  i >= 0 ;i--){
            if( id%2 ==0){
                g.lineTo(i, wave_height - 1 * wave_under * (i/stage_width) + long_height *Math.sin(  i* long_length +cnt*3 + lag *0.2) +  small_height * Math.sin(i * wave_length + cnt + lag));
            }else {
                g.lineTo(i, ( wave_height - wave_under) + wave_under * (i/stage_width) - long_height *Math.sin(0.5*Math.PI + i* long_length +cnt*3 + lag *0.2)  -  small_height * Math.sin(i * wave_length + cnt + lag) );
            }
        }
        g.endFill();
    }
}