/**
 * Copyright potix2 ( http://wonderfl.net/user/potix2 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mf42
 */

// forked from potix2's PE002
// forked from potix2's PE001
//@see http://projecteuler.net/index.php?section=problems&id=3
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.events.Event;
    
    public class PE003 extends Sprite {
        private function main():void {
        	
        		var primes:Vector.<int> = getPrimes(10000);
        		var target:Number = 600851475143;
        		log('target=' + target);
        		var primeFactors:Vector.<int> = primes.filter(function(item:int, index:uint, v:Vector.<int>):Boolean {
        			return (target % item) == 0;
        		});
        		dumpVector(primeFactors);
        }
        
        private function isPrime(n:int):Boolean {
        		return smallestDivisor(n) == n;
        }
        
        private function smallestDivisor(n:int):int {
        		return findDivisor(n, 2);
        }

        private function findDivisor(n:int, testDivisor:int):int {
        		var sq:int = testDivisor * testDivisor;
        		if ( sq > n ) {
        			return n;
        		}
        		else if ( (n % testDivisor) == 0 ) {
        			return testDivisor;
        		}
        		else {
        			return findDivisor(n, testDivisor + 1);
        		}
        }
        
        private function getPrimes(dest:int):Vector.<int> {
        		return VectorUtil.range(1, dest).filter(function(item:int, index:uint, v:Vector.<int>):Boolean {
        			return isPrime(item);
        		}, this);
        }
        
        
        // setup
    		private var _console:TextField;
        public function PE003() {
        		addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(event:Event):void {
        	    	_console = new TextField();
        	    	_console.multiline = true;
        	    	_console.selectable = true;
        	    	_console.autoSize = TextFieldAutoSize.LEFT;
        		addChild(_console);
        		main();
        }
         
        private function log(msg:String):void {
        		_console.appendText("\n" + msg);
        }
        
        private function dumpVector(v:Vector.<int>):void {
        		v.forEach(function (item:int, index:uint, vect:Vector.<int>):void {
        			this.log(item);
        		}, this);       	
        }
        
    }
}
class VectorUtil {
	public static function range(min:int, max:int):Vector.<int> {
		var ret:Vector.<int> = new Vector.<int>(max - min + 1);
		var i:int = 0;
		while(i + min <= max ) {
			ret[i] = min + i;
			i++;
		}
		return ret;
	}
}

