/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/meqn
 */

// forked from tkinjo's JigLibFlash Test
package  
{
	/**
	 * 地面を Box で構成
	 */
	
	import flash.display.Sprite;
	import flash.events.Event;
	import jiglib.physics.RigidBody;
	import jiglib.plugin.papervision3d.Papervision3DPhysics;
	import org.papervision3d.core.proto.CameraObject3D;
	import org.papervision3d.core.proto.MaterialObject3D;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.view.AbstractView;
	import org.papervision3d.view.BasicView;
	
	[SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#ffffff")]
	
	/**
	 * ...
	 * @author tkinjo
	 */
	public class Main extends Sprite
	{
		private const speed:Number = 10;
		
		private var view:AbstractView;
		private var scene:Scene3D;
		private var camera:CameraObject3D;
		private var cameraTarget:DisplayObject3D;
		
		private var physics:Papervision3DPhysics;
		
		/**
		* 
		*/
		public function Main() 
		{
			view = new BasicView( stage.stageWidth, stage.stageHeight );
			addChild( view );
			
			scene = view.scene;
			camera = view.camera;
			
			
			
			/** --------------------------------------------------
			 * カメラ設定
			 */
			camera.x = 1000
			camera.y = 1000;
			
			cameraTarget = new DisplayObject3D();
			camera.lookAt( cameraTarget );
			
			
			
			/** --------------------------------------------------
			 * jiglib 設定
			 */
			physics = new Papervision3DPhysics( scene, speed );
			
			
			// マテリアルの準備
			var wireframeMaterial:WireframeMaterial = new WireframeMaterial( 0 );
			var materials:MaterialsList = new MaterialsList();
			materials.addMaterial( wireframeMaterial, "all" );
			
			// 地面の作成
			var ground:RigidBody = physics.createCube( materials, 100, 100, 0 );
			ground.movable = false;
			
			// ボックスの作成
			var box:RigidBody;
			for (var i:int = 0; i < 5; i++) {
				box = physics.createCube( materials, 100, 100, 100 );
				box.y = 300 * ( i + 1 );
			}
			
			/** --------------------------------------------------
			 * レンダリング
			 */
			addEventListener( Event.ENTER_FRAME, enterFrameHandler );
			view.startRendering();
		}
		
		/**
		 * 
		 * @param	event
		 */
		private function enterFrameHandler( event:Event ):void {
			
			physics.step();
		}
	}
}