/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mdGB
 */

package {
    import flash.utils.Dictionary;
    import flash.geom.Rectangle;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private var c:CLI;
        private var balls:Dictionary;
        
        public function FlashTest() {
            // write as3 code here..
            
            balls = new Dictionary(true);
            
            c = new CLI(this,0,1,256);
            c.display();
            c.appendText("Keyboard '~' - to hide show console, type 'list' to list all commands");
            c.setCommand("list","traceOutCommnads");
            c.setCommand("new","createNewBall");
            c.setCommand("move", "changeBallSpeed");
            c.setCommand("moveAll", "changeAllBallsSpeed");
            c.setCommand("remove", "removeBall");
            c.setCommand("removeAll", "removeAllBalls");
            
            createNewBall("Ball1");
            createNewBall("Ball2");
            createNewBall("Ball3");
        }
        
        public function traceOutCommnads():void
        {
            c.appendText("");
            c.appendText("List of all commands:");
            
            c.appendText(" > new [objectName : String]");
            c.appendText("\t\tCreate a new moving object with a custome name. Example:");
            c.appendText("\t\t > new    Ball235");
            
            c.appendText(" > move [objectName : String] [dirX : Number] [dirY : Number]");
            c.appendText("\t\tChange the movment direction of object with selected name. Example:");
            c.appendText("\t\t > move   Ball2   5   -4");
            
            c.appendText(" > moveAll [dirX : Number] [dirY : Number]");
            c.appendText("\t\tChange the speed and moving direction of all the objects on stage. Example:");
            c.appendText("\t\t > moveAll   5   -4");
            
            c.appendText(" > remove [objectName : String]");
            c.appendText("\t\tRemove object with the given name from stage. Example:");
            c.appendText("\t\t > remove yourBalls");
            
            c.appendText(" > removeAll");
            c.appendText("\t\tRemove all objects from stage");
            c.appendText("");
        }
        
        public function removeBall(name:String):void
        {
            c.appendText("Removing object [" + name + "] from stage");
            if(balls[name])
            {
                removeChild(balls[name]);
                balls[name] = null;
                delete balls[name];
                c.appendText("Done.");
                
            } else {
                
                c.appendText("No such object was found, try again");
            }


        }
        public function removeAllBalls():void
        {
            c.appendText("Remoiving all objects from stage");
            
            for(var s:String in balls)
            {
                removeChild(balls[s]);
                delete balls[s];
            }
            c.appendText("Done.");
        }


        
        public function createNewBall(name:String):void
        {
            var ball:MovingObject = new MovingObject(name);
            addChildAt(ball,0);
            ball.x = 100;
            ball.y = 300;
            balls[name] = ball;
            ball.space = new Rectangle(0,256,stage.stageWidth, stage.stageHeight - 256);
        }
        
        public function changeAllBallsSpeed(dx:String, dy:String):void
        {
            if(balls.length < 1) c.appendText("No objects were found, add some objects first then try again");
            
            for(var s:String in balls)
                balls[s].moveTo(Number(dx), Number(dy));
        }
 
        
        public function changeBallSpeed(ball:String, sx:String, sy:String):void
        {
            balls[ball].moveTo(Number(sx), Number(sy));
        }



    }
}

import flash.geom.Rectangle;
import flash.text.TextFieldAutoSize;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.KeyboardEvent;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.utils.Dictionary;
 
 
class MovingObject extends Sprite
{    
    private var dx:Number = 0;
    private var dy:Number = 0;
    private var r:Number;
    
    public var space:Rectangle;

    public function MovingObject(name:String)
    {
        graphics.lineStyle(4, 0x0);
        graphics.beginFill(0xFFFFFF * Math.random());
        
        r = Math.random() * 10 + 15;
        
        graphics.drawCircle(0,0,r);
        graphics.endFill();
        drawStringToSprite(this, name, 0, -(r + 18), 14, 0x0);
        
        dx = Math.random() * 10 - 5;
        dy = Math.random() * 10 - 5;
        
        space = null;
        
        addEventListener(Event.ENTER_FRAME, loop);
        addEventListener(Event.REMOVED_FROM_STAGE,dispose);
    }
    
    private function dispose(e:Event):void
    {
        removeEventListener(Event.ENTER_FRAME, loop);
    }

    
    private function loop(e:Event):void
    {
        this.x += dx;
        this.y += dy; 
        
        if(space)
        {
            if(dx < 0 && x + r < space.left) x = space.right - r;
            if(dx > 0 && x - r > space.right) x = space.left + r;
            if(dy < 0 && y + r < space.top) y = space.bottom + r;
            if(dy > 0 && y - r > space.bottom) y = space.top - r;
        }
   
    }

    
    public function moveTo(dirX:Number, dirY:Number):void
    {
        this.dx = dirX;
        this.dy = dirY;
    }

    
}

 
 
/**
 * Command Line Interface
 * @author Ian Reichert-Watts
 * www.shadowhelm.com
 */
class CLI extends Sprite
{
    private var _parent:Object;
    private var _prompt:TextField = new TextField();
    private var _cmd:TextField = new TextField();
    private var _view:TextField = new TextField();
    private var _format:TextFormat = new TextFormat("sans", 12, 0xFFFFFF);
 
    private var _color:uint;
    private var _alpha:Number;
    private var _height:int;
 
    private var _commands:Dictionary = new Dictionary();
 
    public function CLI(parent:Object, color:uint = 0x000000, alpha:Number = .7, height:int = 64) {
        _parent = parent;
        _color = color;
        _alpha = alpha;
        _height = height;
        this.graphics.beginFill(color, _alpha);
        this.graphics.drawRect(0, 0, _parent.stage.stageWidth, _height);
        this.addChild(_prompt);
        _prompt.autoSize = "left";
        _prompt.y = _height - 20;
        _prompt.defaultTextFormat = _format;
        _prompt.text = ">";
        _prompt.selectable = false;
        this.addChild(_cmd);
        _cmd.height = 20;
        _cmd.width = _parent.stage.stageWidth;
        _cmd.y = _height - 20;
        _cmd.x = 10;
        _cmd.defaultTextFormat = _format;
        _cmd.type = "input";
        this.addChild(_view);
        _view.height = 20;
        _view.width = _parent.stage.stageWidth;
        _view.wordWrap = true;
        _view.autoSize = "left";
        _view.y = _height - _view.height - 20;
        _view.defaultTextFormat = _format;
        _view.selectable = false;
        _parent.addChild(this);
        this.visible = false;
        listen();
    }
 
    public function listen():void {
        _parent.stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp, false, 0, true);
    }
 
    public function silence():void {
        _parent.stage.removeEventListener(KeyboardEvent.KEY_UP, onKeyUp);
    }
 
    public function display():void {
        this.visible = true;
        _parent.stage.focus = _cmd;
        _cmd.setSelection(_cmd.text.length, _cmd.text.length);
    }
 
    public function clear():void {
        if (_cmd.text.slice(_cmd.text.length - 1, _cmd.text.length) == "`") {
            _cmd.text = _cmd.text.slice(0, _cmd.text.length-1);
        }
        this.visible = false;
    }
 
    public function toggle():void {
        if(!this.visible) display();
        else clear();
    }
 
    public function setCommand(command:String, functionName:String):void {
        _commands[command] = functionName;
    }
 
    public function appendText(text:String):void {
        _view.appendText("\n"+text);
        _view.y = _height - 20 - _view.height;
    }
 
    private function onKeyUp(e:KeyboardEvent):void {
        switch (e.keyCode) {
            case 192: 
                toggle();
                break;
            case 13:
                var func:Array = _cmd.text.split(" ");
                _view.appendText("\n~ "+_cmd.text);
                _view.y = _height - 20 - _view.height;
                _cmd.text = "";
                if (_commands[func[0]]) {
                    var command:Function = _parent[_commands[func[0]]] as Function;
                    switch (func.length) {
                        case 1:
                            command();
                            break;
                        case 2:
                            command(func[1]);
                            break;
                        case 3:
                            command(func[1],func[2]);
                            break;
                        case 4:
                            command(func[1],func[2],func[3]);
                            break;
                        case 5:
                            command(func[1],func[2],func[3],func[4]);
                            break;
                        case 6:
                            command(func[1],func[2],func[3],func[4],func[5]);
                            break;
                        case 7:
                            command(func[1],func[2],func[3],func[4],func[5],func[6]);
                            break;
                        case 8:
                            command(func[1],func[2],func[3],func[4],func[5],func[6],func[7]);
                            break;
                        case 9:
                            command(func[1],func[2],func[3],func[4],func[5],func[6],func[7],func[8]);
                            break;
                    }
 
                }
                break;
        }
    }
}

// Text utility functions.
const DEFAULT_FONT_NAME:String = "_typewriter";
function createTextField(x:int, y:int, size:int, color:int, hasSpacing:Boolean = true):TextField {
    var fm:TextFormat = new TextFormat(DEFAULT_FONT_NAME), fi:TextField = new TextField;
    fm.size = size; fm.color = color; fm.leftMargin = 0; fm.bold = false;
    if (hasSpacing) fm.letterSpacing = 3;
    fi.defaultTextFormat = fm;
    fi.autoSize = TextFieldAutoSize.CENTER;
    fi.x = x; fi.y = y; fi.selectable = false;
    return fi;
}
function drawStringToSprite(sp:Sprite, s:String, x:int, y:int, size:int, color:int, hasSpacing:Boolean = true):void {
    var t:TextField = createTextField(x, y, size, color, hasSpacing);
    t.text = s;
    sp.addChild(t);
}