/**
 * Copyright simultechnology ( http://wonderfl.net/user/simultechnology )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mcmH
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.media.Sound;
	import flash.net.URLRequest;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.utils.Timer;
	
	[SWF(backgroundColor="0x000000")]
	public class Flashup extends Sprite
	{
		// 最初にテキストが表示された後は、trueにする。
		private var _first_text_end:Boolean = false;
		
		public function Flashup()
		{
			this.addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
		}
		
		private function init(e:Event):void {
			
			// サウンドの再生
			var snd:Sound = new Sound();
			snd.load(new URLRequest("http://simultechnology.blendmix.jp/flash/oo39_ys012.mp3"));
			snd.addEventListener(Event.COMPLETE, function(e:Event):void {
				snd.play(0, 1000);
			});
		
			this.removeEventListener(Event.ADDED_TO_STAGE, init);
			// 最初のテキストの表示
			showText();
		
			var fileArray :Array = [
				"http://assets.wonderfl.net/images/related_images/6/64/6474/64740d580bd0cb78a13d0d2e0ffc1fdbefcf5851",
				"http://assets.wonderfl.net/images/related_images/3/35/35b3/35b33283e0fd38fe3dbfa3785984d80b0f8fb27b",
				"http://assets.wonderfl.net/images/related_images/4/4e/4efe/4efe7a54be952cd5ed9b47a5e1d2bf5a42f922ec",
				"http://assets.wonderfl.net/images/related_images/1/1f/1f44/1f448bcdd41fb3b4367eb5c58c4fd911ca34137a",
				"http://assets.wonderfl.net/images/related_images/a/a9/a94a/a94ae401cbb1edb37df1135d1c149a7214a81a9f",
				"http://assets.wonderfl.net/images/related_images/6/60/608b/608be8901a07a1285bf2275bea764914e1ac9157",
				"http://assets.wonderfl.net/images/related_images/d/d6/d6f4/d6f42ba245422e56312b24cf13ebb6c0661377d8",
				"http://assets.wonderfl.net/images/related_images/4/42/4224/42240f07b166ba8e230cedda17fb446a0d0cf1a8",
				"http://assets.wonderfl.net/images/related_images/6/62/6229/62293a35b6033e0b2316286dfd8390187c6856af",
			];
			
			var len:int = fileArray.length;
			
			var sp:Image;
			var i:int = 0;
			this.addEventListener(Event.ENTER_FRAME,function (e:Event) :void {
				if (_first_text_end && sp == null) {
					sp = new Image(fileArray[i],0, 0);
					addChild(sp);
				}
				if (_first_text_end && sp.getBmAlpha() < 0) {
					if (i >= len - 1) {
						sp.removeChildAt(0);
						
						for (var j:int = 0; j < numChildren; j++) {
							removeChildAt(j);
						}
						sp = null;
						i = 0
					}
					else {
						sp.removeChildAt(0);
						removeChildAt(numChildren -1);
						sp = null;
						i += 1;
					}
				}
			});
		}
		
		/*
		*　テキスト表示のメソッド
		*/
		private function showText():void {
			var tf:TextField;
			
			var timer:Timer = new Timer(0, 1);
			timer.addEventListener(TimerEvent.TIMER, function(e:TimerEvent):void {
				trace("START!!");
				// 文字列フォーマットの指定
				var tm:TextFormat = new TextFormat();
				tm.color = 0xFFFFFF;
				tm.bold = true;
				tm.size = 60;
				// 文字列の作成
				tf = new TextField();
				tf.defaultTextFormat = tm;
				tf.width = 300;
				tf.text = "START!!";
				tf.alpha = 0;
				tf.x = 100;
				tf.y = 100;
				addChildAt(tf, 0);
				// テキストのalphaが1.0になったら、trueにする。その判断フラグ。
				var flg:Boolean = false;
				addEventListener(Event.ENTER_FRAME, function(e:Event):void {
					if (!flg && tf.alpha < 1) {
						tf.alpha += 0.05;
					}
					else if (!flg && 1 <= alpha) {
						flg = true;
						removeEventListener(TimerEvent.TIMER, arguments.callee);
						removeEventListener(Event.ENTER_FRAME, arguments.callee);
					}
				});
			});
			timer.start();
			
			// 3秒後から透明にさせていく。
			var timer2:Timer = new Timer(3000, 1);
			timer2.addEventListener(TimerEvent.TIMER, function(e:TimerEvent):void {
				addEventListener(Event.ENTER_FRAME, function(e:Event):void {
					tf.alpha -= 0.05;
					if (tf.alpha < 0) {
						_first_text_end = true;
						removeEventListener(TimerEvent.TIMER, arguments.callee);
						removeEventListener(Event.ENTER_FRAME, arguments.callee);
					}
				});
			});
			timer2.start();
		}
	}
}

import flash.display.Bitmap;
import flash.display.Loader;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.events.TimerEvent;
import flash.external.ExternalInterface;
import flash.net.URLRequest;
import flash.system.LoaderContext;
import flash.utils.Timer;

class Image extends Sprite
{
	private var _url:String;
	private var _id:Number;
	private var _bm:Bitmap;
	
	public function Image(url:String, x:int, y:int)
	{
		this._url = url;
		this.x = x;
		this.y = y;
		
		var loader:Loader = new Loader();
		var uRLRequest:URLRequest = new URLRequest(url);
		// ポリシーファイルチェックをtrue
		loader.load(uRLRequest, new LoaderContext(true));
		loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeListener, false, 0, true);
		
		var timer:Timer = new Timer(3000, 1);
		timer.addEventListener(TimerEvent.TIMER, function(e:TimerEvent):void {
			addEventListener(Event.ENTER_FRAME, function(e:Event):void {
				_bm.alpha -= 0.05;
				if (_bm.alpha < 0) {
					removeEventListener(TimerEvent.TIMER, arguments.callee);
					removeEventListener(Event.ENTER_FRAME, arguments.callee);
				}
			});
		});
		timer.start();
	}
	
	protected function completeListener(e:Event):void
	{
		_bm = new Bitmap(e.target.content.bitmapData);
		_bm.alpha = 0;
		
		addChild(_bm);
		var flg:Boolean = false;
		this.addEventListener(Event.ENTER_FRAME, function(e:Event):void {
			if (!flg && _bm.alpha < 1) {
				_bm.alpha += 0.05;
			}
			else if (!flg && 1 <= alpha) {
				flg = true;
				removeEventListener(Event.ENTER_FRAME, arguments.callee);
			}
		});
	}
		
	// 子オブジェクトであるbitmapのalphaを返すgetter
	public function getBmAlpha():Number
	{
		if (_bm != null) {
			return this._bm.alpha;
		}
		else {
			return 0;
		}
	}
}
