/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mceq
 */

// forked from Aquioux's YIQ Color Plane
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.*;
    import flash.events.*;
    
    [SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "#FFFFFF")]
    
    /**
     * YIQ Color Plane
     * @see http://en.wikipedia.org/wiki/YIQ
     * @author YOSHIDA, Akio (Aquioux)
     */
    public class Main extends Sprite {
        public  const SW:int = stage.stageWidth;
        public  const SH:int = stage.stageHeight;
        public  const CX:int = SW / 2;
        public  const CY:int = SH / 2;

        public function Main() 
        {
            addEventListener(Event.ENTER_FRAME, loop); 
            
            
            var bmd:BitmapData = new BitmapData(SW, SH, false);
            var bm:Bitmap = new Bitmap(bmd);
            for (var h:int = 0; h < SH; h++) {
                for (var w:int = 0; w < SW; w++) {
                    var i:Number = w / CX - 1;
                    var q:Number = h / CY - 1;
                    var color:uint = yiqToRgb(0.5, i, q);
                    bmd.setPixel(w, h, color);
                }
            }
            bm.scaleY = -1;
            bm.y = SH;
            addChild(bm);
            
            function loop(event:Event):void
            {
                this.rotationZ = rotationZ++;
            }

            
        }
        
        private function yiqToRgb(y:Number, i:Number, q:Number):uint {
            var r:Number = y + 0.9563 * i + 0.6210 * q;
            var g:Number = y - 0.2721 * i - 0.6474 * q;
            var b:Number = y - 1.1070 * i + 1.7046 * q;
            r *= 255;
            g *= 255;
            b *= 255;
            r >> 0;
            g >> 0;
            b >> 0;
            if (r < 0) r = 0;
            if (g < 0) g = 0;
            if (b < 0) b = 0;
            if (r > 255) r = 255;
            if (g > 255) g = 255;
            if (b > 255) b = 255;
            return r << 16 | g << 8 | b;
        }
    }
}