/**
 * Copyright bongiovi015 ( http://wonderfl.net/user/bongiovi015 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mcbD
 */

package {
    import flash.display.Sprite;
    import caurina.transitions.Tweener;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.utils.Timer;
    import frocessing.color.ColorHSV;
    
    public class Invaders extends Sprite {
        public const X_TOTAL : int = 10;
        public const Y_TOTAL : int = 10;
        private var __bmpd : BitmapData;
        private var __pDown : Point;
        private var __invaders  : Array = [];
        private var __timer : Timer;
        
        public function Invaders() {
            graphics.beginFill(0, 1);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            addEventListener(Event.ADDED_TO_STAGE, __init);
        }
        
        
        private function __init(e:Event=null) : void {
            removeEventListener(Event.ADDED_TO_STAGE, __init);
            
            __bmpd = new BitmapData( X_TOTAL * Invader.INTERVAL, Y_TOTAL * Invader.INTERVAL, true, 0);
            addChild(new Bitmap(__bmpd)).alpha = 0;
            render();
        }
        
        
        public function render(e:Event=null) : void {
            var i:int, j:int, count:int =0;;
            var tx:Number, ty:Number;
            var mtx:Matrix = new Matrix;
            var color:ColorHSV = new ColorHSV(0, .2, 1);
            
            
            while(i<10){
                tx = Math.floor(Math.random() * __bmpd.width / Invader.INTERVAL / 2) * Invader.INTERVAL * 2;
                ty = Math.floor(Math.random() * __bmpd.height / Invader.INTERVAL / 2) * Invader.INTERVAL * 2;
                var bmpdBig:BitmapData = new BitmapData(Invader.INTERVAL * 2, Invader.INTERVAL * 2, true, 0);
                mtx.identity();
                mtx.translate(-tx, -ty);
                bmpdBig.draw(__bmpd, mtx);
                
                if(bmpdBig.getColorBoundsRect(0xFF000000, 0x00000000, false).width < Invader.W) {
                    color.h = Math.random() * 360;
                    var bigInvader:Invader = new Invader(color.value);
                    var bmpdMap:BitmapData = new BitmapData(bmpdBig.width, bmpdBig.height, true, 0xFF990000);
                    __bmpd.copyPixels(bmpdMap, bmpdMap.rect, new Point(tx, ty));
                    addChild(bigInvader).alpha = 0;
                    bigInvader.scaleX = bigInvader.scaleY = 2;
                    bigInvader.x = tx + 1;
                    bigInvader.y = ty + 1;
                    __invaders.push(bigInvader);
                    Tweener.addTween(bigInvader, {time:.5, transition:"easeOutSine", alpha:1, delay:count++*.05});
                }
                
                i++;
            }
            
            i = 0;
            
            
            for(j=0;j<Y_TOTAL;j++) {
                for(i=0;i<X_TOTAL;i++) {
                    mtx.identity();
                    tx = i*Invader.INTERVAL;
                    ty = j*Invader.INTERVAL;
                    mtx.translate(-tx, -ty);
                    var bmpd:BitmapData = new BitmapData(Invader.WIDTH, Invader.WIDTH, true, 0);
                    bmpd.draw(__bmpd, mtx);
                    
                    if(bmpd.getColorBoundsRect(0xFF000000, 0x00000000, false).width < Invader.W) {
                        var inv:Invader = new Invader(brightnessColor(0xFFFFFF, .3 + Math.random()));
                        __bmpd.copyPixels(inv.bmpd, inv.bmpd.rect, new Point(tx, ty));
                        addChild(inv).alpha = 0;
                        inv.x = tx;
                        inv.y = ty;
                        __invaders.push(inv);
                        Tweener.addTween(inv, {time:.5, transition:"easeOutSine", alpha:1, delay:count++*.005});
                    }
                }
            }
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, __onDownaHandler);
        }
        
        
        private function __remove(target:DisplayObject) : void {
            if(target.parent) target.parent.removeChild(target);
        }
        
        
        private function __onDownaHandler(e:MouseEvent) : void {
            stage.addEventListener(MouseEvent.MOUSE_UP, __onUpHandler);
            __pDown = new Point(stage.mouseX, stage.mouseY);
        }
        
        private function __onUpHandler(e:MouseEvent) : void {
            stage.removeEventListener(MouseEvent.MOUSE_UP, __onUpHandler);
            stage.removeEventListener(MouseEvent.MOUSE_DOWN, __onDownaHandler);
            var tx:Number = Math.floor( (stage.mouseX - __pDown.x) / Invader.INTERVAL / 2 ) * Invader.INTERVAL * 2;
            var ty:Number = Math.floor( (stage.mouseY - __pDown.y) / Invader.INTERVAL / 2) * Invader.INTERVAL * 2;
            //            var ty:Number = 0;
            
            var bmpd:BitmapData = __bmpd.clone();
            __bmpd.fillRect(__bmpd.rect, 0);
            var mtx:Matrix = new Matrix;
            mtx.translate(tx, ty);
            __bmpd.draw(bmpd, mtx);
            var temp:Array = [];
            
            for each ( var inv:Invader in __invaders) {
                var ttx:Number = inv.x + tx;
                var tty:Number = inv.y + ty;
                var a:Number = ( ttx < 0 || tty < 0 || ttx >= X_TOTAL * Invader.INTERVAL || tty >= Y_TOTAL * Invader.INTERVAL ) ? 0 : 1; 
                Tweener.addTween(inv, {time:.5, transition:"easeOutSine", x:ttx, y:tty, alpha:a, onComplete:a==0 ? __remove : null, onCompleteParams:a==0?[inv]:null});
                if(a == 1) temp.push(inv);
            }
            
            __invaders = temp;
            
            //Scheduler.delay(this, render, [], .5);
            if(__timer != null) {
                __timer.removeEventListener(TimerEvent.TIMER, render);
            }
            
            __timer = new Timer(500, 1);
            __timer.addEventListener(TimerEvent.TIMER, render);
            __timer.start();

        }
        
        
        public static function brightnessColor(color:uint, level:Number) : uint {
            var a:uint = color >> 24 & 0xFF; 
            var r:uint = color >> 16 & 0xFF; 
            var g:uint = color >> 8 & 0xFF; 
            var b:uint = color & 0xFF;
            
            r *= level;
            g *= level;
            b *= level;
            
            if(r > 0xFF) r = 0xFF;
            if(g > 0xFF) g = 0xFF;
            if(b > 0xFF) b = 0xFF;
            
            var newColor:uint = a << 24 | r << 16 | g << 8 | b;
            return newColor;
        }
    }
}




import flash.display.BitmapData;
import flash.display.Sprite;


class Invader extends Sprite {
    
    public static const W : int = 10;
    public static const WIDTH : int = W*5;
    public static const INTERVAL : int = WIDTH + 2;
    
    public var color : uint;
    public var bmpd : BitmapData;
    private var __ary : Array = [];
    
    public function Invader(color:uint) : void {
        this.color = color;
        __init();
    }
    
    
    private function __init() : void {
        var i:int=0, j:int=0;
        var tx:Number, ty:Number;
        
        for(i=0; i<2; i++) {
            for(j=0; j<5; j++) {
                tx = i*W;
                ty = j*W;
                if( Math.random() > .5 ) {
                    graphics.beginFill(color, 1);
                    graphics.drawRect(tx, ty, W, W);
                    graphics.endFill();
                    
                    graphics.beginFill(color, 1);
                    graphics.drawRect(W*4 - tx, ty, W, W);
                    graphics.endFill();
                }
            }
        }
        
        
        for(j=0; j<5; j++) {
            tx = 2*W;
            ty = j*W;
            if( Math.random() > .5 ) {
                graphics.beginFill(color, 1);
                graphics.drawRect(tx, ty, W, W);
                graphics.endFill();
            }
        }
        
        
        bmpd = new BitmapData(WIDTH, WIDTH, true, 0xFF990000);
    }
    
}