/**
 * Copyright tjoen ( http://wonderfl.net/user/tjoen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mbvv
 */

// forked from yama3's flash on 2011-4-8
package {
    import com.adobe.serialization.json.JSON;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.events.Event;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    
    [SWF(backgroundColor="#000000", frameRate="31", width="700", height="400")]
    
    public class FlashTest extends Sprite {
        private const APIURL:String = 'http://gdata.youtube.com/feeds/api/videos?start-index=1&max-results=10&orderby=published&alt=json&vq=';//'http://gdata.youtube.com/feeds/api/videos?alt=json&orderby=published&format=5';
        private const KEYWORD : String = 'Leiden Virtueel';
        private var _w : int;
        private var _h : int;
        private var _jsonObject : Object;
        public var _bollon : Balloon;
        private var _base:Sprite;
        
        public function FlashTest() {
            if(stage) initialize();
            else addEventListener(Event.ADDED_TO_STAGE, initialize);            
        }
        
        private function initialize(event:Event=null):void {
            removeEventListener(Event.ADDED_TO_STAGE, initialize);
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            _w = stage.stageWidth;
            _h = stage.stageHeight;
            var bmd : BitmapData = new BitmapData(_w, _h, false, 0x000000);
            addChild(new Bitmap(bmd));
            
            _base = new Sprite();
            addChild(_base);
            
            _bollon = new Balloon(0, 0, _w, _h);
            addChild(_bollon);
            
            var urlLoader:URLLoader = new URLLoader();
            urlLoader.addEventListener(Event.COMPLETE, urlLoadCompleteHandler);
            urlLoader.load(new URLRequest(APIURL + KEYWORD));
        }
        
        private function urlLoadCompleteHandler(event:Event):void {
            _jsonObject = JSON.decode(event.currentTarget.data);
            for(var i:String in _jsonObject['feed']['entry']) {
                var url:String = "http://www.youtube.com/watch?v=" + String(_jsonObject['feed']['entry'][i]['id']['$t']).replace('http://gdata.youtube.com/feeds/api/videos/', '');
                var thumbURL : String = _jsonObject['feed']['entry'][i]['media$group']['media$thumbnail'][0]['url'];
                var title:String = _jsonObject['feed']['entry'][i]['title']['$t'];
                var thum:ThumbImage = new ThumbImage(thumbURL, url, title);
                var c:int = Math.ceil(_w / 134);
                var cy:int = int(i) / c;
                var cx:int = int(i) - cy * c;
                var dx:Number = 134 * cx;
                var dy:Number = 101 * cy;
                
                
                thum.x = dx;
                thum.y = dy;
                
                
                
                
                _base.addChild(thum);
            }
        }
    }
}

import flash.display.Bitmap;
import flash.display.Loader;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.net.URLRequest;
import flash.net.navigateToURL;
import flash.system.LoaderContext;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;

class ThumbImage extends Sprite {
    private var _img:String;
    private var _url:String;
    private var _title:String;
    
    public function ThumbImage(imageURL:String, youtubeURL:String, title:String) {
        _img = imageURL;
        _url = youtubeURL;
        _title = title;
        buttonMode = true;
        if(stage) initialize();
        else addEventListener(Event.ADDED_TO_STAGE, initialize);
    }
    private function initialize(event:Event=null):void {
        removeEventListener(Event.ADDED_TO_STAGE, initialize);
        
        var loader:Loader = new Loader();
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadCompleteHandler);
        loader.load(new URLRequest(_img), new LoaderContext(true));
        addEventListener(MouseEvent.CLICK, onMouseClick);
        addEventListener(MouseEvent.ROLL_OVER, onRollOver);
        addEventListener(MouseEvent.ROLL_OUT, onRollOut);
        
    }
    
    private function onRollOut(event:MouseEvent):void {
        var t:FlashTest = this.parent.parent as FlashTest;
        t._bollon.hide();
    }
    private function onRollOver(event:MouseEvent):void {
        var t:FlashTest = this.parent.parent as FlashTest;
        t._bollon.show(_title);
    }
    private function onMouseClick(event:MouseEvent):void {
        navigateToURL(new URLRequest(_url), '_blink');
    }
    
    private function loadCompleteHandler(event:Event):void {
        var bm:Bitmap = event.target.loader.content as Bitmap;
        var scale:Number = 100 / bm.height;
        bm.height = 100;
        bm.scaleX = scale;
        bm.smoothing = true;
        addChild(bm);
    }
}

class Balloon extends Sprite {
    private var _tl:TextField;
    private var _top:int;
    private var _left:int;
    private var _right:int;
    private var _bottom:int;
    private var _sp:Sprite;
    
    public function Balloon(top:int, left:int, right:int, bottom:int) {
        _sp = new Sprite();
        _sp.graphics.lineStyle(0.1, 0xffffff);
        _sp.graphics.beginFill(0x000000);
        _sp.graphics.drawRect(0, 0, 124, 20);
        _sp.graphics.endFill();
        _sp.x = _sp.y = 10;
        addChild(_sp);
        _tl = new TextField();
        _tl.wordWrap = true;
        _tl.autoSize = TextFieldAutoSize.LEFT;
        _tl.width = 180;
        _tl.textColor = 0xffffff;
        _tl.x = _tl.y = 10;
        addChild(_tl);
        
        _top = top;
        _left = left;
        _right = right;
        _bottom = bottom;
        visible = false;
        mouseEnabled = false;
        mouseChildren = false;
    }
    
    public function show(text:String):void {
        _tl.text = text;
        _sp.width = _tl.width + 4;
        _sp.height = _tl.textHeight + 8;
        visible = true;
        addEventListener(Event.ENTER_FRAME, enterFrameHandler);
    }
    
    public function hide():void {
        removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
        visible = false;
    }
    
    private function enterFrameHandler(event:Event):void {
        x = stage.mouseX + 5;
        y = stage.mouseY + 5;
        if(x > _right - width) x = x - width - 5;
        if(y > _bottom - height) y = y - height -5;
    }




}
