/**
 * Copyright yuuganisakase ( http://wonderfl.net/user/yuuganisakase )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mbrh
 */

//
//  based on http://abandonedart.org/
//
package
{
	import com.flashdynamix.motion.TweensyGroup;
	import com.flashdynamix.motion.effects.core.ColorEffect;
	import com.flashdynamix.motion.effects.core.FilterEffect;
	import com.flashdynamix.motion.layers.BitmapLayer;
	
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	
	[SWF(width=465, height=465, frameRate=12, backgroundColor=0xffdddd)]
	public class sketch2 extends Sprite
	{
		private var tween:TweensyGroup = new TweensyGroup();
		private var layer:BitmapLayer = new BitmapLayer(Util.WID, Util.HEI);
		private var holder:Sprite = new Sprite();
		
		public var cArray:Array = new Array();
		
		
		
		public function sketch2()
		{
			super();
			if(stage != null){
				stage.addEventListener(Event.ENTER_FRAME, onEnter);
				stage.addEventListener(MouseEvent.CLICK, onClick);
			}
			
			layer.draw(holder);
			
			layer.add(new ColorEffect(new ColorTransform(1,1,1,0.99)));
			layer.add(new FilterEffect(new BlurFilter(2,2)));
			addChild(layer);
			
			for(var i:int = 0 ; i < Util.cNum; i++)
			{
				addParticle();
			}
		}
		private function addParticle():void
		{
			var xx:Circle = new Circle(holder);
			xx.drawMe();
			cArray.push(xx);
			
		}
		private function onEnter(e:Event):void
		{
			holder.graphics.clear();
			var num:int = Util.cNum;
			
			for each(var cir:Circle in cArray)
			{
				cir.updateMe(cArray);
				cir.drawMe();
			}
		}
		private function onClick(e:MouseEvent):void
		{
			var big:BigCircle = new BigCircle(e.stageX, e.stageY,holder);
			cArray.push(big);
			big.addEventListener("eraseMe", eraseBig);
		}
		private function eraseBig(e:Event):void
		{
			trace("erase big");
			for(var i:int = 0; i < cArray.length; i++)
			{
				if(cArray[i] is BigCircle){
					(cArray[i] as BigCircle).removeEventListener("eraseMe", eraseBig);
					cArray.splice(i,1);
                                        break;
				}
			}
		}
	}
}
import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Point;

import frocessing.core.GraphicsEx;

class Util
{
	public static const WID:int = 465;
	public static const HEI:int = 465;
	public static const cNum:int = 32;
	public static const speed:Number = 6;
}

class Circle extends Sprite
{
	public var pos:Point;
	public var vel:Point;
	internal var radius:Number;
	private var alp:Number;
	internal var fillCol:uint;
	internal var target:Sprite
	internal var gra:GraphicsEx;
	internal var random1:Number;
	internal var random2:Number;
	internal var random3:Number;
	internal var random4:Number;
	internal var random5:Number;
	internal var random6:Number;
	public function Circle(_target:Sprite)
	{
		target = _target;
		pos = new Point(Math.random() * Util.WID, Math.random() * Util.HEI);
		vel = new Point(Math.random() * (Util.speed*2) - Util.speed, Math.random() * (Util.speed*2) - Util.speed);
		trace("vel = " + vel);
		radius = 25 + Math.random() * 45;
		alp = 1;//Math.random();
		var xx:int = 255;
		var yy:int = xx -50 - Math.random()*30;
		fillCol = ((xx<<16)|(yy<<8)|(yy));
		gra = new GraphicsEx(target.graphics);
		var randomScale:Number = 0;
		random1 = 1-(Math.random()-0.5)*randomScale;
		random2 = 1-(Math.random()-0.5)*randomScale;
		random3 = 1-(Math.random()-0.5)*randomScale;
		random4 = 1-(Math.random()-0.5)*randomScale;
		random5 = 1-(Math.random()-0.5)*randomScale;
		random6 = 1-(Math.random()-0.5)*randomScale;
		
	}
	public function drawMe():void
	{
		target.graphics.lineStyle();
		target.graphics.beginFill(fillCol,0.2);
		target.graphics.drawCircle(pos.x, pos.y, radius*2);
	}
	public function updateMe(ar:Array):void
	{
		pos.x += vel.x;
		pos.y += vel.y;
		
		if (pos.x > (Util.WID + radius)) { pos.x = 0 - radius; }
		if (pos.x < (0-radius)) { pos.x = Util.WID + radius; }
		if (pos.y > (Util.HEI + radius)) { pos.y = 0 - radius; }
		if (pos.y < (0-radius)) { pos.y = Util.HEI + radius; }
		
		
		var len:int = Util.cNum;
		
		for(var i:int = 0; i < len; i++)
		{
			var another:Circle = ar[i];
			
			if(this != another)
			{
				var dis:Number = Point.distance(this.pos, another.pos);
				var overlap:Number = dis - radius - another.radius;
				if(overlap < 0)
				{
					var center:Point = Point.interpolate(this.pos, another.pos, 0.5);
					overlap *= -1;
					drawCollision(center.x, center.y, overlap);
				}
			}
		}
	}
	
	private function drawCollision(xx:int, yy:int, rad:Number):void
	{
		
		var sca:Number = (rad * 0.007);
		drawHeart(xx,yy,sca);
	}
	
	internal function drawHeart(xx:int, yy:int, sca:Number):void
	{
		var rad:Number = 40*sca;
		var size:Number = 50*sca;
		var posScale:Number = 0;
		var p1:Point = new Point(xx+random5*posScale, yy+size+random6*posScale);
		var p3:Point = new Point(xx+random1*posScale, yy-size+random3*posScale);
		var p2:Point = new Point(xx-size*1.4*random2, yy-size+random4*posScale);
		var p4:Point = new Point(xx+size*1.4*random3, yy-size+random5*posScale);
		
		var c1:Point = new Point(xx-rad*0.5*random1, yy);
		var c3:Point = new Point(xx-size-rad*0.5*random2, yy-size-rad);
		var c2:Point = Point.interpolate(c3,p2,-0.8);
		var c4:Point = new Point((p2.x+p3.x)/2+rad*0.4*random3, yy-size-rad*1.5);
		
		var c8:Point = new Point((p3.x+p4.x)/2-rad*0.4*random4, yy-size-rad*1.5);
		var c7:Point = new Point(xx+size+rad*0.5*random5, yy-size-rad);
		var c6:Point = Point.interpolate(c7,p4,-0.8);
		var c5:Point = new Point(xx+rad*0.5*random6, yy);
		/*var ar1:Array = [p1,p2,p3,p4];
		var ar2:Array = [c1,c2,c3,c4,c5,c6,c7,c8]
		for(var i:int = 0;i < ar1.length; i++)
		{
		this.graphics.beginFill(0xff0000,0.5);
		this.graphics.drawCircle(ar1[i].x, ar1[i].y,5);				
		this.graphics.endFill();
		}
		for(var i:int = 0;i < ar2.length; i++)
		{
		this.graphics.beginFill(0x0000ff,0.5);
		this.graphics.drawCircle(ar2[i].x, ar2[i].y,5);				
		this.graphics.endFill();
		}*/
		
		gra.lineStyle(4,0xcc0000,0.8);
		gra.moveTo(p1.x, p1.y);
		gra.bezierTo(c1.x, c1.y, c2.x, c2.y, p2.x, p2.y);
		gra.bezierTo(c3.x, c3.y, c4.x, c4.y, p3.x, p3.y);
		
		gra.bezierTo(c8.x, c8.y, c7.x, c7.y, p4.x, p4.y);
		gra.bezierTo(c6.x, c6.y, c5.x, c5.y, p1.x, p1.y);
		
	}
	
	
	
}
class BigCircle extends Circle
{
	private var count:int = 0;
	public function BigCircle(xx:int, yy:int,_target:Sprite)
	{
		super(_target);
		pos = new Point(xx,yy);
		vel = new Point(0,0);
		radius = 40;
		
	}
	override public function updateMe(ar:Array) : void
	{
		super.updateMe(ar);
		count += 1;
		radius += 0.5;
		if(count > 50){
			dispatchEvent(new Event("eraseMe") );
		}
	}
	override public function drawMe() : void
	{
		
		
			target.graphics.lineStyle();
			target.graphics.beginFill(0x330000,0.2);
			target.graphics.drawCircle(pos.x, pos.y, radius*2);
		
	}
	override internal function drawHeart(xx:int, yy:int, sca:Number) : void
	{
		var rad:Number = 40*sca;
		var size:Number = 50*sca;
		var posScale:Number = 0;
                var p1:Point = new Point(xx, yy+size);
		var p3:Point = new Point(xx, yy-size);
		var p2:Point = new Point(xx-size*1.4, yy-size);
		var p4:Point = new Point(xx+size*1.4, yy-size);
		
		var c1:Point = new Point(xx-rad*0.5*random1, yy);
		var c3:Point = new Point(xx-size-rad*0.5*random2, yy-size-rad);
		var c2:Point = Point.interpolate(c3,p2,-0.8);
		var c4:Point = new Point((p2.x+p3.x)/2+rad*0.4*random3, yy-size-rad*1.5);
		
		var c8:Point = new Point((p3.x+p4.x)/2-rad*0.4*random4, yy-size-rad*1.5);
		var c7:Point = new Point(xx+size+rad*0.5*random5, yy-size-rad);
		var c6:Point = Point.interpolate(c7,p4,-0.8);
		var c5:Point = new Point(xx+rad*0.5*random6, yy);		/*var ar1:Array = [p1,p2,p3,p4];
		var ar2:Array = [c1,c2,c3,c4,c5,c6,c7,c8]
		for(var i:int = 0;i < ar1.length; i++)
		{
		this.graphics.beginFill(0xff0000,0.5);
		this.graphics.drawCircle(ar1[i].x, ar1[i].y,5);				
		this.graphics.endFill();
		}
		for(var i:int = 0;i < ar2.length; i++)
		{
		this.graphics.beginFill(0x0000ff,0.5);
		this.graphics.drawCircle(ar2[i].x, ar2[i].y,5);				
		this.graphics.endFill();
		}*/
		
		gra.beginFill(0xffffff,0.8);
		gra.moveTo(p1.x, p1.y);
		gra.bezierTo(c1.x, c1.y, c2.x, c2.y, p2.x, p2.y);
		gra.bezierTo(c3.x, c3.y, c4.x, c4.y, p3.x, p3.y);
		
		gra.bezierTo(c8.x, c8.y, c7.x, c7.y, p4.x, p4.y);
		gra.bezierTo(c6.x, c6.y, c5.x, c5.y, p1.x, p1.y);
	}
}



