/**
 * Copyright aruerula ( http://wonderfl.net/user/aruerula )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/maOP
 */

package
{
    //http://www40.atwiki.jp/spellbound/pages/198.html
    
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.system.Security;
    import frocessing.color.ColorRGB;
 
    public class Main extends Sprite
    {
        private const WIDTH:int = 150; // 幅
        private const HEIGHT:int = 150; // 高さ
 
        public function Main()
        {            
            stage.scaleMode = "noScale";
            Security.loadPolicyFile("http://farm3.static.flickr.com/crossdomain.xml");
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.INIT, initHandler);
            loader.load(new URLRequest("http://farm3.static.flickr.com/2205/2532926223_6b2745185b.jpg"), new LoaderContext(true)); // 読み込みたい画像URL
        }
 
        private function initHandler(event:Event):void
        {
            var loader:Loader = event.currentTarget.loader;
 
            var matrix:Matrix = new Matrix();
            matrix.scale(WIDTH / loader.width, HEIGHT / loader.height); // 設定したいサイズ / 元サイズ
 
            var bd:BitmapData = new BitmapData(WIDTH, HEIGHT); // 設定したいサイズ
            bd.draw(loader, matrix);
            addChild(new Bitmap(pixelization(bd, 20)));
        }
 
        private function pixelization(bd:BitmapData, size:int = 10):BitmapData
        {
            var dest:BitmapData = bd.clone();
            var color:ColorRGB = new ColorRGB();
 
            for (var y:int = 0; y < bd.height; y += size)
            {
                for (var x:int = 0; x < bd.width; x += size)
                {
                    var count:int = 0;
                    var r:int = 0;
                    var g:int = 0;
                    var b:int = 0;
 
                    for (var yy:int = 0; yy < size; yy++)
                    {
                        for (var xx:int = 0; xx < size; xx++)
                        {
                            if (x + xx < 0 || bd.width <= x + xx ||
                                y + yy < 0 || bd.height <= y + yy) continue;
 
                            count++;
 
                            color.value = bd.getPixel(x + xx, y + yy);
                            r += color.r;
                            g += color.g;
                            b += color.b;
                        }
                    }
 
                    color.r = r / count;
                    color.g = g / count;
                    color.b = b / count;
 
                    for (yy = 0; yy < size; yy++)
                    {
                        for (xx = 0; xx < size; xx++)
                        {
                            if (x + xx < 0 || bd.width <= x + xx ||
                                y + yy < 0 || bd.height <= y + yy) continue;
 
                            dest.setPixel(x + xx, y + yy, color.value);
                        }
                    }
                }
            }
 
            return dest;
        }
    }
}
 