/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ma8Y
 */

/*現時点ではただの円運動ですが
このコードをベースに拡張しつつ
今週中には何かを作ります。*/
package{
    import flash.display.Sprite
    import flash.events.Event;
    import flash.geom.Point;
    
    [SWF(width=465, height=465, backgroundColor=0,frameRate=30)]
    
    public class Main extends Sprite{
        
        private var _circleList:Vector.<Circle> = new Vector.<Circle>()
        private var _motionList:Vector.<CircleMotion> = new Vector.<CircleMotion>()
        private const _sizeList:Vector.<int> = Vector.<int>([4, 6, 8, 8, 23, 32, 18, 10])
        private const _speedList:Vector.<Number> = Vector.<Number>([10, 7, 1, 1.2, 0.8, 0.5, 0.1, 0.05])
        private const _radList:Vector.<int> = Vector.<int>([10, 30, 50, 80, 120, 190, 250,320])
        private const _circleColor:int = 0x0FF9FF
        
        public function Main(){
            var base:Base = new Base(0, stage.stageWidth, stage.stageHeight)
            addChild(base)
            for(var i:int=0; i<_sizeList.length; i++){
                var col:int = 0xFCCFE3
                createPlanet(_circleColor<<i+2, _sizeList[i], _speedList[i], _radList[i])
                _circleList[i].addEventListener(Event.ENTER_FRAME, update)
                base.graphics.lineStyle(2, col<<i+2)
                base.graphics.drawCircle(stage.stageWidth/2, stage.stageHeight/2, _radList[i])    
            }
        }
        
        private function createPlanet(color:int, size:int, speed:Number, rad:Number):void{
            var circle:Circle = new Circle(color, size, speed, rad)
            _circleList.push(circle)
            circle.x = stage.stageWidth/2
            circle.y = stage.stageHeight/2
            circle.pos = new Point(circle.x, circle.y)
            addChild(circle)
        }
        
        private function update(e:Event):void{
            e.target.x = e.target.motion.setPos(e.target.pos).x
            e.target.y = e.target.motion.setPos(e.target.pos).y
        }
    }
}

//class Circle
import flash.display.Sprite;
import flash.geom.Point;

class Circle extends Sprite{
    private var _pos:Point = new Point()
    private var _speed:Number
    private var _radius:Number
    private var _motion:CircleMotion;
    
    public function Circle(color:int,r:int, speed:Number, rad:Number):void{
        graphics.beginFill(color, 1)
        graphics.drawCircle(0,0,r)
        graphics.endFill()
        //
        _speed = speed
        _radius = rad
        //
        _motion = new CircleMotion(_speed, _radius)
    }
    
    public function get motion():CircleMotion{
        return _motion
    }
    public function set pos(p:Point):void{
        _pos = p
    }
    public function get pos():Point{
        return _pos
    }
    public function set speed(s:Number):void{
        _speed = s
    }
    public function get speed():Number{
        return _speed
    }
    public function set radius(r:Number):void{
        _radius = r
    }
    public function get radius():Number{
        return _radius
    }
}

//class CircreMotion
import flash.geom.Point;

class CircleMotion{
   private var _angle:Number = 0;
   private var _speed:Number;
   private var _radius:Number;
   private var _point:Point = new Point()
   
   public function CircleMotion(speed:Number, rad:Number){
       _speed = speed
       _radius = rad
   }
    
    public function setPos(pos:Point):Point{
        var radian:Number = _angle * Math.PI / 180;
        _point.x = pos.x + _radius * Math.cos(radian);
        _point.y = pos.y + _radius * Math.sin(radian);
        _angle += _speed;
        return _point
    }
    
    public function set speed(speed:Number):void{
        _speed = speed;
    }
    public function get speed():Number{
        return _speed;
    }
    public function set radius(rad:Number):void{
        _radius = rad;
    }
    public function get radius():Number{
        return _radius;
    }
}

//class Base
import flash.display.Sprite
class Base extends Sprite{
    public function Base(color:int,w:int,h:int):void{
        graphics.beginFill(color, 1)
        graphics.drawRect(0,0,w,h)
        graphics.endFill()
    }
}