/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mZti
 */

// forked from lizhi's brush
package  
{
    import flash.display.Sprite;
    import flash.events.*;
    import flash.geom.Point;
    /**
     * ...
     * @author lizhi
     */
    [SWF(width=465,height=465,backgroundColor=0xffffff,frameRate=60)]
    public class BezierDraw extends Sprite{
        private var lines:Object = new Object();
        private var ps:Array = [];//座標点配列
        private var smoothLength:int = 2;
        private var halfPenWidth:Number = 10;//線の太さ
        
        //エントリ
        public function BezierDraw(){
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            
        }
        
        private function onMouseDown(e:MouseEvent):void{
            stage.addEventListener(Event.ENTER_FRAME, onMouseMove);
        }
        
        private function onMouseUp(e:MouseEvent):void{
            stage.removeEventListener(Event.ENTER_FRAME, onMouseMove);
        }
        
        //カーソル移動
        private function onMouseMove(e:Event):void{
            var p:Point = new Point(mouseX, mouseY);//カーソル座標
            ps.push(p);
            draw();
            
        }
        
        //描画処理
        private function draw():void{
            
            var cx:Number;
            var cy:Number;
                   
            var tx:Number;
            var ty:Number;
                    
            var a:Number;
                    
            var dx:Number;
            var dy:Number;
                    
            var cx0:Number;
            var cx1:Number;
                    
            var cy0:Number;
            var cy1:Number;
                    
            var tx0:Number;
            var tx1:Number;
                    
            var ty0:Number;
            var ty1:Number;
            
            graphics.clear();
            graphics.lineStyle(0);
            graphics.beginFill(0);
            
            
            if (ps.length > 1){
                var lx0:Number = ps[0].x / 2 + ps[1].x / 2;
                var ly0:Number = ps[0].y / 2 + ps[1].y / 2;
                var lx1:Number = lx0;
                var ly1:Number = ly0;
                graphics.moveTo(tx, ty);
            }
            var i:int = 0;
            
            for (i = 0; i < ps.length - 2; i++ ){
                var length:Number = Point.distance(ps[i], ps[i + 1]);
                if (length > smoothLength) {
                    
                    cx = ps[i].x;
                    cy = ps[i].y;
                    
                    tx = ps[i].x / 2 + ps[i + 1].x / 2;
                    ty = ps[i].y / 2 + ps[i + 1].y / 2;
                    
                    a = Math.atan2(ty - cy, tx - cx);
                    
                    dx = Math.sin(a - Math.PI / 2) * halfPenWidth/length;
                    dy = Math.cos(a - Math.PI / 2) * halfPenWidth/length;
                    
                    cx0 = cx + dx;
                    cx1 = cx - dx;
                    
                    cy0 = cy + dy;
                    cy1 = cy - dy;
                    
                    tx0 = tx + dx;
                    tx1 = tx - dx;
                    
                    ty0 = ty + dy;
                    ty1 = ty - dy;
                    
                    graphics.moveTo(lx0, ly0);
                    graphics.curveTo(cx0, cy0 , tx0 , ty0 );
                    graphics.lineTo(tx1, ty1);
                    graphics.curveTo(cx1, cy1, lx1, ly1);
                    graphics.lineTo(lx0, ly0);
                    
                    lx0 = tx0;
                    ly0 = ty0;
                    lx1 = tx1;
                    ly1 = ty1;
                }
            }
            
            
            
            if (ps.length > 1) {
                cx = ps[i].x;
                cy = ps[i].y;
                tx = ps[i].x / 2 + ps[i + 1].x / 2;
                ty = ps[i].y / 2 + ps[i + 1].y / 2;
                
                a = Math.atan2(ty - cy, tx - cx);
                
                cx0 = cx + dx;
                cx1 = cx - dx;
                cy0 = cy + dy;
                cy1 = cy - dy;
                
                graphics.moveTo(lx0, ly0);
                graphics.curveTo(cx0, cy0 , tx , ty );
                graphics.curveTo(cx1, cy1, lx1, ly1);
                graphics.lineTo(lx0, ly0);
            }
            
        }
    }

}