/**
 * Copyright lenonsun ( http://wonderfl.net/user/lenonsun )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mZhu
 */

// forked from paq's [QuickBox2D] くっついていく
package 
{
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2ContactFilter;
    import com.actionsnippet.qbox.QuickBox2D;
    import com.actionsnippet.qbox.QuickContacts;
    import com.actionsnippet.qbox.QuickObject;
    import flash.display.Graphics;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    
    /**
     * -Controls
     *  Arrow Key: move
     * @author paq
     */
    [SWF(backgroundColor="0xFFFFFF", width=465, height=465, frameRate=60)]
    public class Main extends Sprite
    {
        private var _qbox:QuickBox2D;
        private var _key:Object;
        private var _actor:QuickObject;
        private var _canvas:MovieClip;
        private var _circles:Vector.<QuickObject>;
        private var _chains:Vector.<QuickObject>;
        private var _boxes:Vector.<QuickObject>;
        private var _contacts:QuickContacts;
        
        public function Main():void 
        {
            _init();
        }
        
        private function _init():void 
        {
            _key = {};
            _circles = new Vector.<QuickObject>;
            _chains = new Vector.<QuickObject>;
            _boxes = new Vector.<QuickObject>;
            
            var g:Graphics = graphics;
            g.beginFill(0x222222);
            g.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            
            _canvas = new MovieClip();
            addChild(_canvas);
            
            _qbox = new QuickBox2D(_canvas);
            _qbox.mouseDrag();
            _qbox.start();
            _qbox.setDefault({lineAlpha:0});
            _createWalls();
            
            _contacts = _qbox.addContactListener();
            _contacts.addEventListener(QuickContacts.ADD, _onAdd);

            for (var i:int = 0; i < 20; i++) 
            {
                _boxes.push(_qbox.addBox( { x:Math.random() * 100, y:Math.random() * 14 + 1, width:2 + Math.random() * 3, height:0.5, density:0} ));
            }
            
            for (i = 0; i < 20; i++) 
            {
                _circles.push(_qbox.addCircle( { x:Math.random() * 100, y:Math.random() * 15.5, radius:0.2 + Math.random() / 2, fillColor:0xEEEEEE } ));
            }
            
            _actor = _qbox.addBox( { y: -0.2, width:30 / 30, height:30 / 30, allowSleep:false, fillColor:0x0099CC} );
            _qbox.setDefault({lineAlpha:1, lineColor:0xFFFFFF});
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, _onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, _onKeyUp);
            addEventListener(Event.ENTER_FRAME, _onLoop);
        }
        
        private function _onAdd(e:Event):void 
        {
            var l:Number = _circles.length;
            for (var i:int = 0; i < l; i++)
            {
                var circ:QuickObject = _circles[i];
                if (!circ.params.isJoint && _contacts.isCurrentContact(circ, _actor))
                {
                    if (_chains.length == 0)
                    {
                        _qbox.addJoint( { a:circ.body, b:_actor.body } );
                    }
                    else
                    {
                        _qbox.addJoint( { a:circ.body, b:_chains[_chains.length-1].body } );
                    }
                    _chains.push(circ);
                    
                    circ.params.isJoint = true;
                }
             }
        }
        
        private function _onLoop(e:Event):void 
        {
            var vel:b2Vec2 = _actor.body.GetLinearVelocity();
            var ang:Number = _actor.body.GetAngularVelocity();
            
            if (_key[Keyboard.LEFT])
            {
                vel.x -= 1;
                ang -= 1;
            }
            else if (_key[Keyboard.RIGHT])
            { 
                vel.x += 1;
                ang += 1;
            }
            
            if (_key[Keyboard.UP])
            {
                vel.y = -10;
                ang *= 0.8;
            }
            
            ang *= 0.9;
            vel.x *= 0.9;
            
            _actor.body.SetLinearVelocity(vel);
            _actor.body.SetAngularVelocity(ang);
            
            _canvas.x = -_actor.x * 30 + stage.stageWidth / 2;
            if (_canvas.x > 15) _canvas.x = 15;
            if (_canvas.x < -2535) _canvas.x = -2535;
        }
        
        private function _createWalls():void
        {
            _qbox.addBox( { x:50, y:stage.stageHeight / 30, width:100, height:1, density:0 } );
            //_qbox.addBox( { x:50, y:-0.5, width:100, height:1, density:0 } );
            _qbox.addBox( { x:-0.5, y:stage.stageHeight / 30 / 2, width:1, height:stage.stageHeight / 30, density:0 } );
            _qbox.addBox( { x:100, y:stage.stageHeight / 30 / 2, width:1, height:stage.stageHeight / 30, density:0 } );
        }
        
        private function _onKeyDown(e:KeyboardEvent):void 
        {
            _key[e.keyCode] = true;
        }
        
        private function _onKeyUp(e:KeyboardEvent):void 
        {
            _key[e.keyCode] = false;
        }        
    }
    
}