/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mZ88
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    import Box2D.Dynamics.*
    import Box2D.Collision.*
    import Box2D.Collision.Shapes.*
    import Box2D.Dynamics.Joints.*
    import Box2D.Dynamics.Contacts.*
    import Box2D.Common.Math.*
    import Box2D.Common.Math.b2Vec2; 
    public class FlashTest extends Sprite {

        public var world:b2World;        
        
        public function FlashTest() {
            // write as3 code here..
            var worldAABB:b2AABB = new b2AABB();
              worldAABB.lowerBound.Set(-100.0, -100.0);
              worldAABB.upperBound.Set(100.0, 100.0);
            world = new b2World(worldAABB, new b2Vec2(0,10),true);
            //world.setWarmStarting(true);
            
            var groundBodyDef:b2BodyDef = new b2BodyDef();
              groundBodyDef.position.Set(0.0, -10.0);
            var groundBody:b2Body = world.CreateBody(groundBodyDef);
            var groundShapeDef:b2PolygonDef = new b2PolygonDef();
             groundShapeDef.SetAsBox(50.0, 10.0);
            groundBody.CreateShape(groundShapeDef);
            
            var bodyDef:b2BodyDef = new b2BodyDef();
            bodyDef.position.Set(0.0, -40);
     
             var body:b2Body = world.CreateBody(bodyDef);
            
            var shapeDef:b2PolygonDef = new b2PolygonDef();
               shapeDef.SetAsBox(1.0, 1.0);  
                 shapeDef.density = 1.0;
              shapeDef.friction = 0.3;
               body.CreateShape(shapeDef);
                body.SetMassFromShapes();
            
            
            var debugSprite:Sprite = new Sprite();
            debugSprite.x = 250;
            debugSprite.y = 250;
           addChild(debugSprite);
             
        
            var dbgDraw:b2DebugDraw = new b2DebugDraw();
            
              
           dbgDraw.m_sprite = debugSprite;
            dbgDraw.m_drawScale = 5.0;
           dbgDraw.m_fillAlpha = 0.3;
            dbgDraw.m_lineThickness = 1.0;
            dbgDraw.m_drawFlags = b2DebugDraw.e_shapeBit | b2DebugDraw.e_jointBit;
            world.SetDebugDraw(dbgDraw);
            
            stage.addEventListener(Event.ENTER_FRAME, update);
        }//ctor
        
        public function update(e:Event):void
        {
            world.Step(1/30,10);
        }//update
        
    }//classend
}