/**
 * Copyright mtok ( http://wonderfl.net/user/mtok )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mYlx
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.DisplayObject;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.net.URLRequest;
	
 	public class TwoFacedSpriteTest extends Sprite 
	{
		private var bitmap:Bitmap;
		
		private var _twofaced:TwoFacedSprite;
		
		private var gPos:Point;
		private var bg:Sprite;
		public function TwoFacedSpriteTest():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);

			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			var sw:Number = stage.stageWidth * 0.5;
			var sh:Number = stage.stageHeight * 0.5;
			
			addChild(bg = new Sprite());
			bg.graphics.beginFill(0x000000);
			bg.graphics.drawRect(0, 0, 490, 490);
			bg.graphics.endFill();
			
			gPos = new Point(sw, sh);
			
			_twofaced = new TwoFacedSprite();
			_twofaced.x = sw;
			_twofaced.y = sh;

			addChild(_twofaced);

			_twofaced.frontSide = loadAsset("http://assets.wonderfl.net/images/related_images/2/21/2190/2190dec6671d982d1a5450cc4caeed11214a551d");			
			_twofaced.backSide = loadAsset("http://assets.wonderfl.net/images/related_images/2/29/29f5/29f5a0979b515d482652082c9b72986e872a26f7");		
			addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
		}
		private function loadAsset(url:String):DisplayObject{
			var l:Loader = new Loader();
			l.load(new URLRequest(url));
			l.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
			l.contentLoaderInfo.addEventListener(Event.COMPLETE, function(ev:Event):void{
				l.x = -l.contentLoaderInfo.width * 0.5;
				l.y = -l.contentLoaderInfo.height * 0.5;	
			});
			
			return l;
			
		}
		
		private function ioErrorHandler(e:IOErrorEvent):void 
		{
			trace('io error');
		}
		private function mouseDownHandler(e:MouseEvent):void 
		{
			addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
			startRotation();
		}
		
		private function mouseMoveHandler(e:MouseEvent):void 
		{
			var p:Point = new Point(mouseX, mouseY);
			p = p.subtract(gPos);
			
			_twofaced.rotationX = p.y * 1.5;
			_twofaced.rotationY = p.x * 1.5;
			
			_twofaced.x = mouseX;
			_twofaced.y = mouseY;
		}		
		
		private function mouseUpHandler(e:MouseEvent):void 
		{
			removeEventListener(e.type, arguments.callee);
			stopRotation();
		}
		
		private function startRotation():void
		{
			//gPos = new Point(mouseX, mouseY);
			addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
		}
		private function stopRotation():void
		{
			removeEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
		}
	}
}

import flash.display.DisplayObject;
import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Matrix3D;
import flash.geom.Vector3D;

class TwoFacedSprite extends Sprite {
	private var _frontSide:DisplayObject;
	private var _backSide:DisplayObject;
	private var _zAxis:Vector3D = new Vector3D(0, 0, 1);

	public function  TwoFacedSprite():void 
	{
		super();
		z = 0;
		
		addChild(_frontSide = new Sprite());
		addChild(_backSide = new Sprite());
		_backSide.visible = false;
		
		if (stage) {
			initialize();
		}else {
			addEventListener(Event.ADDED_TO_STAGE, addedToStage);			
		}
	}
	
	private function addedToStage(e:Event):void 
	{
		removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
		initialize();
	}
	
	private function initialize():void
	{		
		addEventListener(Event.RENDER, renderHandler);
		stage.invalidate();
	}
	
	private function renderHandler(e:Event):void 
	{
		_frontSide.visible = isForward();
		_backSide.visible = !_frontSide.visible;
	}
	
	private function isForward():Boolean
	{
		var mat:Matrix3D = transform.getRelativeMatrix3D(root);
		var gZ:Vector3D = mat.deltaTransformVector(_zAxis);
		
		return gZ.dotProduct(_zAxis) > 0;
	}
	
	override public function set rotationX(value:Number):void 
	{
		super.rotationX = value;
		if(stage) stage.invalidate();
	}
	
	override public function set rotationY(value:Number):void 
	{
		super.rotationY = value;
		if(stage) stage.invalidate();
	}
	
	override public function set rotationZ(value:Number):void 
	{
		super.rotationZ = value;
		if(stage) stage.invalidate();
	}
	
	public function get frontSide():DisplayObject { return _frontSide; }
	public function set frontSide(value:DisplayObject):void 
	{
		//null check
		if ( value == null) {
			throw new TypeError('object is null');
		}
		removeChild(_frontSide);
		_frontSide = value;
		addChild(_frontSide);
	}
	
	public function  get backSide():DisplayObject
	{
		return _backSide;
	}
	public function set backSide(value:DisplayObject):void 
	{
		if (value == null) {
			throw new TypeError('object is null');			
		}
		removeChild(_backSide);
		_backSide = value;
		addChild(_backSide);
	}
}