/**
 * Copyright mach51 ( http://wonderfl.net/user/mach51 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mYVl
 */

package 
{
    import flash.display.Sprite;
    
    public class CubeWorld extends Sprite 
    {
        
        private var c:Cube;
        private var p:Vector.<Point3D>; // the projected vectors
        
        public function CubeWorld() 
        {
            // how do I get the shadow of the cube on a plane? how do i project from 3 dimensions to 2?
            
            c = new Cube(new Point3D(stage.width / 2, stage.height / 2, 0), 1);
            createProjection(c);
            
        }
        
        public function createProjection(b:Cube):void // projecting the vectors of the shape onto the vectors (1,0,0) and (0,1,0)
        {
            for(var i:int = 0; i < b.getNumPoints(); i++)
            {
                
            }

        }

    } // end class
    
    
} // end PACKAGE

//It says Point, but imagine it as a vector (2 points and a direction). Think about it, a point is irrelevant without an origin.
class Point3D
{
    
    public var x:Number;
    public var y:Number;
    public var z:Number;
    
    public function Point3D(x:Number, y:Number, z:Number)
    {
        this.x = x;
        this.y = y;
        this.z = z;
    }

} // end POINT

class Cube
{
    
    private var points:Vector.<Point3D> = new Vector.<Point3D>();
    private var sideLength:Number;
    
    public function Cube(bottomLeftFrontCorner:Point3D, length:Number)
    {
        this.sideLength = length;
        
        var x:Number = bottomLeftFrontCorner.x;
        var y:Number = bottomLeftFrontCorner.y;
        var z:Number = bottomLeftFrontCorner.z;
        
        for(var i:int = 0; i < 2; i++) // places points on the front face, then the back face.
        {
            points.push(new Point3D(x, y, z + i * sideLength)); // bottom left corner
            points.push(new Point3D(x + sideLength, y, z + i * sideLength)); // bottom right corner
            points.push(new Point3D(x + sideLength, y + sideLength, z + i * sideLength)); // top right corner
            points.push(new Point3D(x, y + sideLength, z + i * sideLength)); // top left corner
        }

    } // end constructor
    
    public function getPoint(i:int):Point3D
    {
        return points[i];
    }
    
    public function getNumPoints():int
    {
        return points.length;
    }
    
} // end CUBE
