/**
 * Copyright cuegraphix ( http://wonderfl.net/user/cuegraphix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mYUm
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	
	[SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="30")]
	
	/**
	 * ...
	 * @author cue
	 */
	public class Main extends Sprite 
	{
		public static const MOSAIC_SIZE:uint = 5;
		
		private var textField:TextField;
		private var canvas:BitmapData;
		private var bmp:Bitmap;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			textField = new TextField();
            textField.x = 10;
			textField.y = 50;
            textField.autoSize = TextFieldAutoSize.LEFT;
			var tf:TextFormat = new TextFormat( "Verdana", 24 );
			textField.defaultTextFormat = tf;
			textField.text = "文字を選択するとモザイクをかけるよ！";
			textField.addEventListener( MouseEvent.MOUSE_UP, _mouseUp );
			addChild( textField );
			
			canvas = new BitmapData( textField.width + 10, textField.height + 10, true );
			canvas.draw( textField );
			
			textField.border = true;
			
			bmp = new Bitmap( canvas.clone() );
			bmp.x = 10;
			bmp.y = 100;
			addChild( bmp );
			
			stage.focus = textField;
			textField.setSelection( 8, 12 );
			_mouseUp( null );
		}
		
		private function _mouseUp( e:MouseEvent ):void
		{
			var beginIndex:int = textField.selectionBeginIndex;
			var endIndex:int = textField.selectionEndIndex;
			
			trace(beginIndex,endIndex)
			if ( bmp.bitmapData ) { bmp.bitmapData.dispose(); }
			
			var bd:BitmapData;
			if ( beginIndex != endIndex )
			{
				endIndex--;
				var beginRect:Rectangle = textField.getCharBoundaries( beginIndex );
				var endRect:Rectangle   = textField.getCharBoundaries( endIndex );
				// 文字選択範囲矩形の結合
				var pixelizeRect:Rectangle = beginRect.union( endRect );
				bd = pixelization( canvas, MOSAIC_SIZE, pixelizeRect );
			}
			else
			{
				bd = canvas.clone();
			}
			
			bmp.bitmapData = bd;
		}
		
		private function pixelization( bitmapData:BitmapData, size:int = 10, rect:Rectangle = null ):BitmapData
		{
			var bd:BitmapData = bitmapData.clone();
			rect ||= bitmapData.rect;
			
			for ( var y:int = rect.top; y < rect.bottom; y += size )
			{
				for ( var x:int = rect.left; x < rect.right; x += size )
				{
					var pRect:Rectangle = new Rectangle( x, y, size, size )
					var color:uint = getAverageColorByRect( bitmapData, pRect );
					bd.fillRect( pRect, color );
				}
			}
			return bd;
		}
		
		private function getAverageColorByRect( bitmapData:BitmapData, rect:Rectangle ):uint
		{
			var interRect:Rectangle = bitmapData.rect.intersection( rect );
			var color:uint;
			var r:uint = 0;
			var g:uint = 0;
			var b:uint = 0;
			for ( var y:int = interRect.top, i:int = 0; y < interRect.bottom; y++ )
			{
				for ( var x:int = interRect.left; x < interRect.right; x++ )
				{
					color = bitmapData.getPixel( x, y );
					r += (color >> 16) & 0xFF;
					g += (color >>  8) & 0xFF;
					b += color         & 0xFF;
					i++;
				}
			}
			r = r / i >> 0;
			g = g / i >> 0;
			b = b / i >> 0;
			return 0xFF << 24 | r << 16 | g << 8 | b;
		}
	}
	
}