/**
 * Copyright suica ( http://wonderfl.net/user/suica )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mYLw
 */

/****************************************************
 * 		円を描画するテスト
 ****************************************************/
package {
	import flash.geom.Matrix;
	import flash.display.Shape;
	import flash.display.ShaderParameter;
	import flash.display.Bitmap;
	import flash.utils.IDataInput;
	import flash.text.TextFormat;
	import flash.text.TextField;
	import flash.display.BitmapData;
	import flash.events.Event;
    import flash.display.Sprite;
	
    public class Main extends Sprite {
		//		出現した円が完全に透明になるまでの値:0.0～１.0
		public static const alpha:Number = 0.05;
		//		Scale x,y	1.0～
		public static const scaleX:Number = 1.0;
		public static const scaleY:Number = 1.0;
		//		背景色
		public static const fillColor:uint = 0xFFFFFFFF;
		//		出現する円の最大値
		public static const maxCircle:int = 100;
		//		拡大する円の最大値
		public static const maxScale:int = 200;
		public static const w:int = 465;
		public static const h:int = 465;
		
		private var cycle:int = 0;
		private var display:Bitmap;
		private var canvas:Vector.<CircleShape>;

        public function Main() {
            display = new Bitmap(new BitmapData(w,h,false,fillColor));
            canvas = new Vector.<CircleShape>();
			canvas.push(new CircleShape());
			CircleShape.drawCanvas = display.bitmapData;
            stage.addChild(display);
            
            addEventListener(Event.ENTER_FRAME, rainbowFlower);
        }
        
        private function rainbowFlower(ev:Event):void
        {
			display.bitmapData.fillRect(display.bitmapData.rect, fillColor);
			for each(var cir:CircleShape in canvas)
			{
				if ( !cir.draw() )
				{
					var idx:int = canvas.indexOf(cir);
					canvas[idx] = null;
					canvas.splice(idx, 1);
				}
			}
			canvas.push(new CircleShape());
        }
    }
}

	import flash.display.Shape;
	import flash.display.BitmapData;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	import flash.geom.Matrix;
	import flash.display.BlendMode;
	class CircleShape
	{
		private static var canvas:BitmapData;
		private static const am:Number = Main.alpha;
		private static const sx:Number = Main.scaleX;
		private static const sy:Number = Main.scaleY;
		private var ct:ColorTransform;
		private var s:Shape;
		private var matrix:Matrix;
		
		public static function set drawCanvas(can:BitmapData):void
		{
			canvas = can;
		}
		
		public function CircleShape()
		{
			s = new Shape();
			ct = new ColorTransform(1, 1, 1, 1);
			var r:Number = Main.maxCircle * Math.random();
			var p:Point = new Point(465 * Math.random(), 465 * Math.random());
			matrix = new Matrix();
			matrix.tx = p.x;
			matrix.ty = p.y;
			
			s.graphics.beginFill(0xFFFFFFFF*Math.random());
			s.graphics.drawCircle(0,0,r);
			s.graphics.endFill();
		}
		
		public function draw():Boolean
		{
			canvas.draw(s, matrix, ct, BlendMode.NORMAL);
			ct.alphaMultiplier -= am;
			matrix.scale(sx, sy);
			return ct.alphaMultiplier > 0.0;
		}
	}