/**
 * Copyright sakef ( http://wonderfl.net/user/sakef )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mYKE
 */

/*
    マイクの音をwavファイルとしてローカルに保存
*/
package
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.ActivityEvent;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.SampleDataEvent;
    import flash.media.Microphone;
    import flash.net.FileReference;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.utils.ByteArray;
    import flash.utils.Endian;
    
    public class Microphone_test02 extends Sprite
    {
        // 録音時間
        private static const record:int = 15;
        
        private var mic:Microphone;
        private var micBytes:ByteArray;
        private var wavBytes:ByteArray;
        private var tf:TextField;
        private var startTIme:Number;
        
        public function Microphone_test02():void
        {
            // ステージの設定
            stage.align=StageAlign.TOP_LEFT;
            stage.scaleMode=StageScaleMode.NO_SCALE;
            
            // データを保存するByteArray
            micBytes=new ByteArray;
            
            // マイクの設定
            mic=Microphone.getMicrophone();
            mic.rate=44;
            mic.gain = 100;
            mic.setSilenceLevel(0, 0);
            mic.setUseEchoSuppression(true);
            mic.setLoopBack(true);
            mic.addEventListener(SampleDataEvent.SAMPLE_DATA, micSampleData);
            mic.addEventListener(ActivityEvent.ACTIVITY, onStart);
        }
        
        private function onStart(e:ActivityEvent):void
        {
            // 時間を測る
            tf=addChild(new TextField)as TextField;
            tf.autoSize=TextFieldAutoSize.LEFT;
            tf.scaleX=tf.scaleY=2;
            tf.x=tf.y=10;
            startTIme=(new Date).getTime();
            addEventListener(Event.ENTER_FRAME, onFrame);
        }
        
        private function micSampleData(e:SampleDataEvent):void
        {
            micBytes.writeBytes(e.data);
        }
        
        private function onFrame(e:Event):void
        {
            var now:Number=(new Date).getTime();
            var diff:int=(now - startTIme) * 0.001;
            tf.text=record.toString()+"秒、録音を行います。\n" + createTimeText(diff);
            
            if (diff >= record)
            {
                removeEventListener(Event.ENTER_FRAME, onFrame);
                mic.removeEventListener(SampleDataEvent.SAMPLE_DATA, micSampleData);
                mic.setLoopBack(false);
                
                // wav用に変換
                var wave:ByteArray=new ByteArray;
                wave.endian = Endian.LITTLE_ENDIAN;
                var len:int=micBytes.length * 0.25;
                micBytes.position=0;
                for(var i:int=0; i < len; i++)
                {
                    var data:int=micBytes.readFloat() * 32767;
                    wave.writeShort(data);
                    wave.writeShort(data);
                }
                
                //wav用ByteArrayの作成
                wavBytes=new ByteArray;
                wavBytes.endian=Endian.LITTLE_ENDIAN;
                wave.position=0;
                len=wave.length;
                
                wavBytes.writeUTFBytes("RIFF");
                wavBytes.writeInt(len + 36);
                wavBytes.writeUTFBytes("WAVE");
                wavBytes.writeUTFBytes("fmt ");
                wavBytes.writeInt(16);
                wavBytes.writeShort(1);
                wavBytes.writeShort(2);
                wavBytes.writeInt(44100);
                wavBytes.writeInt(176400);
                wavBytes.writeShort(4);
                wavBytes.writeShort(16);
                wavBytes.writeUTFBytes("data");
                wavBytes.writeInt(len);
                wavBytes.writeBytes(wave);
                
                tf.text="wavファイルを保存します。\n画面をクリックしてください。"
                stage.addEventListener(MouseEvent.CLICK, onClick);
            }
        }
        
        
        // wavファイルをセーブするイベント
        private function onClick(e:MouseEvent):void
        {
            stage.removeEventListener(MouseEvent.CLICK, onClick);
            var fr:FileReference=new FileReference();
            fr.addEventListener(Event.COMPLETE, onComplete);
            fr.save(wavBytes, "data.wav");
        }
        
        // ダウンロード終了時に表示
        private function onComplete(e:Event):void
        {
            tf.text = "ダウンロードが終了しました。";
        }
        
        // 秒数を時間表示用 mm:ss に整形する関数
        private function createTimeText(time:int):String
        {
            var m:int=(time / 60) >> 0;
            var s:int=(time % 60) >> 0;
            var str:String=((m < 10) ? ("0" + m.toString()) : (m.toString()));
            str+=":" + ((s < 10) ? ("0" + s.toString()) : (s.toString()));
            
            return str;
        }
    }
}

