/**
 * Copyright t2421 ( http://wonderfl.net/user/t2421 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mYDA
 */

package
{
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.geom.Point;
    import frocessing.display.F5MovieClip2DBmp;
    
    /**
     * ...
     * @author taiga
     */
    public class MainCircleMenu extends F5MovieClip2DBmp
    {
        private var stage_width:Number = 465;
        private var stage_height:Number = 465;
        private var radius:Number = 150;
        private var centerPoinnt:Point;
        private var degree:Number = 0;
        private const NUM_POINT:uint = 100;
        private var interval:uint;
        private var myRadian:Number;
        private var count:uint;
        
        public function MainCircleMenu()
        {
            super();
        }
        
        public function setup():void
        {
            trace("setUP");
            centerPoinnt = new Point(232, 232);
            size(stage_width, stage_height);
            background(0);
            stroke(255);
            interval = uint(360 / NUM_POINT);
        
        }
        
        private function translateRadian(degree:Number):Number
        {
            var radian:Number = degree * Math.PI / 180;
            return radian;
        }
        
        public function draw():void
        {
                if (isMousePressed) background(0, 1);
                degree += interval;
                myRadian = translateRadian(degree);
                var targetPoint:Point = new Point(centerPoinnt.x + radius * Math.cos(myRadian), centerPoinnt.y + radius * Math.sin(myRadian));
                //drawCircle(centerPoinnt.x, centerPoinnt.y, radius);
                //drawCircle(centerPoinnt.x, centerPoinnt.y, 2);
                var hosenKatamuki:Number = getHosenKatamuki(targetPoint, centerPoinnt);
                var leftSide:Number = (getYpoint(hosenKatamuki, radius * Math.cos(myRadian) + centerPoinnt.x, radius * Math.sin(myRadian) + centerPoinnt.y, 0));
                var rightSide:Number = (getYpoint(hosenKatamuki, radius * Math.cos(myRadian) + centerPoinnt.x, radius * Math.sin(myRadian) + centerPoinnt.y, width));
                line(0, leftSide, width, rightSide);
            
        }
        
        private function getHosenKatamuki(targetPoint:Point, basePoint:Point):Number
        {
            var katamuki:Number = (targetPoint.x - basePoint.x) / (targetPoint.y - basePoint.y);
            //trace("katamuki : " + katamuki);
            return -katamuki;
        }
        
        private function getYpoint(a:Number = 1, b:Number = 0, c:Number = 0, x:Number = 1):Number
        {
            return a * (x - b) + c;
        }
    
    }

}