/**
 * Copyright o8que ( http://wonderfl.net/user/o8que )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mXqD
 */

/* ---------------------------------------------------------------------------
 * Twitterに投稿するボタンが簡単に作れる！使える！（はず）
 * 
 * 自分のwonderflの作品に、Twitterに投稿する機能を付けたいけど、
 * "よくワカラン"、"何かめんどそう"という方に・・・
 * ---------------------------------------------------------------------------
 * [使い方]
 * ・110行目辺りにある、TwitterButtonクラスを丸ごとコピペするだけです。
 * ---------------------------------------------------------------------------
 * [使用例]
 * 
 * [[Twitter投稿ボタンを作成する]]
 * 
 * var linkURL:String = "http://bit.ly/abcdef"; //投稿時に一緒に表示されるURL
 * var parent:Sprite = this; //ボタンを追加(addChild())する表示オブジェクト
 * var xpos:Number = 50; //ボタンのX座標の位置
 * var ypos:Number = 50; //ボタンのY座標の位置
 * var text:String = "あなたのいちごは100%です！"; //投稿させたい本文の内容
 * var hashTag:String = "#wonderfl"; //投稿時に一緒に表示されるハッシュタグ
 * button = new TwitterButton(linkURL, parent, xpos, ypos, text, hashTag);
 * 
 * [[Twitter投稿ボタンを押した時に、投稿させたい本文の内容を変更する]]
 * 
 * var text:String = "あなたのいちごは100%中の100%です！";
 * button.changeText(text);
 * 
 * ---------------------------------------------------------------------------
 * [補足]
 * ローカル環境で使うには、
 * 「MinimalComps」(http://www.minimalcomps.com/)というライブラリが必要です。
 * もしくは、TwitterButtonクラス内のpostToTwitter()メソッドをコピペしてもOK。
 * ---------------------------------------------------------------------------
 */

 package {
	import com.bit101.components.*;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	
	public class FlashTest extends Sprite {
		private var _textField:TextField;
		private var _twitterID:InputText;
		private var _twitterButton:TwitterButton;
		
		public function FlashTest() {
			graphics.beginFill(0xc0deed);
			graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
			graphics.endFill();
			
			// TwitterIDを入力するフィールドを作成する
			new Label(this, 125, 5, "Twitter ID");
			_twitterID = new InputText(this, 125, 25, "", null);
			// 押すたびに文章を生成するボタンを作成する
			new PushButton(this, 240, 20, "check!", pressedCheckButton);
			// 文章を表示する為のテキストフィールドを作成する
			_textField = new TextField();
			_textField.x = 5, _textField.y = 60;
			_textField.width = 455, _textField.height = 20;
			_textField.background = true, _textField.backgroundColor = 0xffffff;
			_textField.border = true, _textField.borderColor = 0x000000;
			_textField.selectable = false;
			addChild(_textField);
			
			// Twitter投稿ボタンを作成する
			_twitterButton = new TwitterButton("http://bit.ly/a6xGei", this, 155, 90, "", "#wonderfl");
			// 最初は投稿ボタンを隠しておく
			_twitterButton.visible = false;
		}
		
		// 「check!」ボタンを押した時の処理
		private function pressedCheckButton(e:MouseEvent):void {
			// 文章をランダムに生成する
			var text:String = "";
			if (Math.random() < 0.7) {
				text += WORDS1[int(WORDS1.length * Math.random())];
			}else {
				text += WORDS2[int(WORDS2.length * Math.random())];
			}
			text += "すぎる";
			text += WORDS2[int(WORDS2.length * Math.random())];
			text += "、それが";
			if (_twitterID.text != "") {
				text += " @" + _twitterID.text + " さん";
			}else {
				text += "あなた";
			}
			text += "です。 [美人すぎったー]";
			
			// テキストフィールドに文章を表示する
			_textField.text = text;
			
			// 投稿ボタンを押した時に投稿される本文の内容を変更する
			_twitterButton.changeText(text);
			// 投稿ボタンを表示する
			_twitterButton.visible = true;
		}
		
		private static const WORDS1:Array = [
		"とってもかわゆ", "まこと素晴らし", "あっぱれ見事", "トイレが我慢が出来なさ", "正直とんでもなさ", 
		"これはひど", "明らかにやば", "何かわからないがすご", "仏の様に心が広", "存在自体が卑猥",
		"本当に往生際が悪", "無駄にポジティブ", "生まれつき体が弱","異常に速","全身がカチンカチンに硬",
		"自分自身を愛し", "何故か健康", "いくら何でも冗談が", "何もせずに時が", "とにかくエロ",
		"ゴチャゴチャほざき", "見えないオーラが溢れ出", "女子供にも容赦無さ", "全く動じなさ", "パンより米が好き",
		"ポテンシャルを秘め", "あまりに大器晩成", "心の奥に大きな闇を抱え", "実に惨め", "躾がなっていなさ"];
		private static const WORDS2:Array = [
		"美人", "市議", "秘書", "プロ", "市民", "生ゴミ", "奇人", "天才", "う○こ", "金星人",
		"変態", "裸族", "勇者", "ロリコン", "天使", "悪魔", "賢者", "ロボット", "馬鹿", "おっぱい",
		"犬", "猫", "人間", "神", "雑草", "野菜", "果物", "石像", "お肉", "スイーツ", "アレ"];
	}
}

// ここから下をコピペしてください

import com.bit101.components.*;
import flash.display.*;
import flash.events.*;
import flash.net.*
import flash.utils.*;

class TwitterButton extends PushButton {
	private var _text:String;
	private var _footer:String;
	public function changeText(str:String = ""):void { _text = str; }
	
	public function TwitterButton(linkURL:String, parent:DisplayObjectContainer = null, xpos:Number = 0, ypos:Number = 0, text:String = "", hashTag:String = "#wonderfl") {
		super(parent, xpos, ypos, "Post to Twitter", postToTwitter);
		changeText(text);
		_footer = " " + linkURL + " " + hashTag;
		this.scaleX = this.scaleY = 1.5;
	}
	
	private function postToTwitter(e:MouseEvent):void {
		var post:String = _text + _footer; // 投稿する文章
		navigateToURL(new URLRequest("http://twitter.com/home?status=" + escapeMultiByte(post)), "_blank");
	}
}