/**
 * Copyright WeiChih_Lin ( http://wonderfl.net/user/WeiChih_Lin )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mXg9
 */

// forked from andrew.olton's SoundCloud Player
/**
 * Copyright andrew.olton ( http://wonderfl.net/user/andrew.olton )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gJKl
 */

/*
SO this is the somewhat complete version of the track object. 
I built it on wonderfl.net. And so far it works.
I coded it today in work with FDT. Can't wait until I get my lapp back. An issue might be playing mp3's tho.

I have to adjust the size of the rectangle tho. I'm actually surprised the soundcloud refrence worked, 
but praise God anyhow.

To do list: 
    1. Get the right dimensions - To be applied with HTML integration
    2. Progress indicator
    4. making into a re-usable class
    5. Make the player
    6. test with XML. 
    7. Build wav as a form of load progress

You may allow users to change the background color, but the waves will always be black

 * By the way I'm using the Turle in Ocean theme from www.kuler.com to style the wavPlayer
 * 
*/

package 
{
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.media.Sound;
    import flash.utils.ByteArray;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.geom.Rectangle;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.events.MouseEvent;
    import flash.media.SoundChannel;
    import flash.net.URLRequest;
    //For the glass effects
    import flash.display.Shape;

    [SWF(backgroundColor="#000000", width="500", height="80", frameRate="30")]
    
    public class Main extends Sprite
    {    
    //SWF settings
    
    
        //Variable Declaration:
        
            //These variables are for the sounds used
            public var sound:Sound = new Sound();
            public var samples:ByteArray = new ByteArray();
            public var buffer:BitmapData = new BitmapData(500, 80, false,0x026873);
            public var screen:Bitmap = new Bitmap(buffer);
            public var channel:SoundChannel;
            
            //Variables for sound label
            public var label:TextField = new TextField ();
            
            //Variables for GUI:
            public var rect:Rectangle = new Rectangle(0,0,1,0);
            public var playingTime:int;
            public var ratio:Number;
            public var step:int;
            
            //My additions to the GUI
            //1st the glass rectangles
            public var layer1:Shape = new Shape(); //Used for the glass effect
            public var layer2:Shape = new Shape(); //Used for the lower half
            public var layer3:Shape = new Shape(); //Used for the label
            
            public var zone:Rectangle = new Rectangle(0, 0, 1, 80);
            public var cursorBuffer:BitmapData = new BitmapData(500,80,true,0xFFFFFF);
            public var cursorScreen:Bitmap = new Bitmap(cursorBuffer);

            
        public function Main()
        {
            // Launch your application by right clicking within this class and select: Deubg As > FDT SWF Application
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }//End of constructor
        
        public function init():void{
        
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //entry point (your code should start here)
            
            //Place background on the stage
            addChild(screen);
            
            //Add layer 1
            layer1.graphics.beginFill(0xFFFFFF, 0.4);
            layer1.graphics.drawRoundRect(3, 17, stage.width-6, (stage.height/2)-17, 5);
            
            layer1.graphics.endFill();
            addChild(layer1);
            
            //Add layer2 
            layer2.graphics.beginFill(0xFFFFFF, 0.2);
            layer2.graphics.drawRoundRect(3, 17, stage.width-6, (stage.height-20), 5);
            layer2.graphics.endFill();
            addChild(layer2);        
            
            //Add layer3 for title 
            layer3.graphics.beginFill(0x000000, 0.8);
            layer3.graphics.drawRect(0, 0, stage.width, 17);
            layer3.graphics.endFill();
            addChild(layer3);   

            //Setting up the sound label
            label.defaultTextFormat = new TextFormat ( "Verdana", 10, 0x03A6A6);
            //label.autoSize = TextFieldAutoSize.LEFT;
            label.width = this.width;
            label.height = 17;
            label.text = "Dr. Noel Woodroffe - Issues of Physical Purity";
            addChild (label);
            
            
            //Add event listeners to stage 
            
            sound.addEventListener(Event.COMPLETE, loadComplete);
            sound.load(new URLRequest("http://labs.makemachine.net/files/flying_lotus_sample.mp3"));
            
            //A listener needs to be added for when the song's finished.
        }
        

        public function loadComplete(event:Event):void
        {    
            
            var sampleBit:Number = 8;
            
            // Calculate sample size based on the desired waveform width
            var sampleSize:int = buffer.width * sampleBit;
            
            //Draw the background
            //buffer.fillRect( buffer.rect, 0 );  
            
            // Estimate sample length (To get exact sample length we might need to dig byte to byte.)
            var extract:Number = Math.floor ((sound.length/1000)*44100);
            
            //playingTime = sound.length;
            
            //ratio = playingTime / buffer.width;
            var lng:Number = sound.extract(samples,extract);

            samples.position = 0;
            
            step = samples.length/sampleSize; //Could it be that the 4096 was the sample lenght?
    
            do 
                {step--; } 
            while ( step % sampleBit );
            
            var left:Number;
            var right:Number;
            var mono: Number; //Used for combination of the two amplitudes
            
            
            //This for loop build the waveform by generating a rectangle for each 
            for (var c:int = 0; c < sampleSize; c++) //sample length
            {
                
                //Get amplitudes for left and right channels
                left = samples.readFloat()/4; 
                //The number you place here will determine the max transient height
                right = samples.readFloat()/4;
                //the number 4 was used by trial and error
                
                //Combine both waveforms
                mono =  Math.abs(Math.max(left, right)) + Math.abs(Math.min(left, right));
                
                //Set the dimensions of the waveform
                rect.height = mono * buffer.height; //Set height of waveform           
                
                //Set up the position for the wave form
                rect.y = ((buffer.height - rect.height) / 2) + 5; //Position on y axis

                rect.x = c/sampleBit; //The four represents the sample bit.
                // Set sample bit we can work with less bits because we're drawing waveform,
                // the visual representation doesn't have to be bit-accurate.(less bits = smaller loops)
                
                //Draw the waveform 
                buffer.fillRect( rect, 0x000000); 
                
                //Set the starting position to get the amplitude in the next loop
                samples.position = c*step;

            }//End of for loop
            
            /*
             * 
 This is the listener used here: 
    stage.addEventListener( Event.ENTER_FRAME, scrollIt ); 
    
    Added after the song is fully loaded
             * */
            stage.addEventListener( Event.ENTER_FRAME, scrollIt ); 
            //After generating the wav, play the sound.
            channel = sound.play();
        
        }//End of loacComplete function

    
    public function scrollIt( e:Event ):void
{
    cursorBuffer.fillRect( cursorBuffer.rect,0 );
    zone.x = (buffer.width / playingTime) * channel.position;
    cursorBuffer.fillRect( zone , 0xFF990000 );  
}
    }//End of Main class
}//End of package

