/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mXWC
 */

package {
  import flash.display.*;                    
  import flash.geom.Matrix;                       
  import flash.geom.Point;                        
  import flash.filters.DropShadowFilter;          
  import flash.text.TextField;                    

    //背景、サイズ、フレームレート
    [SWF(backgroundColor="#ffffff", width="465", height="465", frameRate="60")]

  public class Web2Badge extends Sprite {         
    // インスタンス変数を宣言
    private const LINE_COLOR:uint = 0xffffff;     
    private const BODY_COLOR1:uint = 0xcccccc;   
    private const BODY_COLOR2:uint = 0x121212;    
    private const CORNER:int = 20;//歯数                
    private const RADIUS1:Number = 30;//中心→歯の山の距離            
    private const RADIUS2:Number = 26;//中心→歯の谷の距離            
    private const TEXT:String = "main";           

    // コンストラクタ
    public function Web2Badge() {
      // バッジの小さいほうの直径
      var d:Number = Math.min(RADIUS1, RADIUS2) * 2;

      // Spriteを作成
      var s:Sprite = new Sprite();
      s.graphics.lineStyle(1, LINE_COLOR);

      // グラデーションの範囲と方向をMatrixオブジェクトに格納
      // (d×dの範囲を-45°の方向に)
      var matrix:Matrix = new Matrix();
      matrix.createGradientBox(d, d, -Math.PI / 4);

      // グラデーションの情報を指定
      s.graphics.beginGradientFill(
        "linear",                    // 線状のグラデーション
        [BODY_COLOR1, BODY_COLOR2],  // 色
        [1, 1],                      // 透明度
        [0, 255],                    // 色の位置
        matrix);                     // 範囲と角度

      // 星型の描画
      var angle:Number = 2 * Math.PI / CORNER;
      var p1:Point, p2:Point;
      s.graphics.moveTo(RADIUS1, 0);
      for(var i:int = 0; i < CORNER; i++) {
        p1 = Point.polar(RADIUS2, angle * (i+0.5));
        p2 = Point.polar(RADIUS1, angle * (i+1));
        s.graphics.curveTo(p1.x, p1.y, p2.x, p2.y);//曲線
        //s.graphics.lineTo(p1.x, p1.y);
        //s.graphics.lineTo(p2.x, p2.y);
      }
      s.graphics.endFill();

      // 影をつける
      s.filters = [new DropShadowFilter(10, 45, 0, 0.2)];

      // 中に表示するテキストを作成
      var size:int = d / TEXT.length;
      var text:TextField = new TextField();
      text.htmlText = '<font size="' + size + '" color="#ffffff">'
        + '<b>' + TEXT + '</font></b>';
      text.x = -text.textWidth / 2;
      text.y = -text.textHeight / 2;
      text.filters = [new DropShadowFilter(1, 45, 0, 0.8)];
      s.addChild(text);

      // (100, 100) に表示
      s.x = s.y = 200;
      addChild(s);
      
      var line:Shape = new Shape();
      line.x = s.x;
      line.y = s.y;
      line.graphics.lineStyle(1,//線の太さ
                      0x000000,//カラー
                      1,//アルファ値
                      true,//ヒンディング最適化
                      "none",//スケールモード
                      "round",//線の先の種類
                      "round");//角の種類
      line.graphics.lineTo(50,-50);
      line.graphics.lineTo(100,-50);
      
      addChild(line);
    }
  }
}