/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mXUa
 */

// forked from kazutoyo's [PV3D]Text3Dをつかった何か
package {
	
	/**
	 * ...
	 * @author kazutoyo@富山商船コンピュータ部
	 * 
	 */
	
	import flash.display.*;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.materials.special.Letter3DMaterial;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.typography.Text3D;
	import org.papervision3d.typography.fonts.HelveticaBold;
	import org.papervision3d.view.Viewport3D;

	[SWF(backgroundColor="0x000000", width=640, height= 480)]
	public class PVdemo2 extends Sprite
	{
		private var viewport:Viewport3D;
		private var scene:Scene3D;
		private var camera:Camera3D;
		private var renderer:BasicRenderEngine;
		private var lf:Letter3DMaterial;
		private var text:Text3D;
		private var words:Array;
		private var lfarray:Array;
		private var color:uint;
		private var str:String = "あいうえおかきくけこ\nTさし\nCOMPUTERCLUB";
		private var size:Number = str.length;
		private var w:int = stage.stageWidth;
		private var h:int = stage.stageHeight;
		
		
		public function PVdemo2()
		{
			init();
		}
		
		private function init():void {
			viewport = new Viewport3D(stage.stageWidth, stage.stageHeight);
			addChild(viewport);
			
			renderer = new BasicRenderEngine();
			scene = new Scene3D();
			camera = new Camera3D();
			
			//文字フォーマット

			words = new Array(size);
			lfarray = new Array(size);
			
			//文字を表示
			for(var i:uint = 0; i < size; i++){
				var char:String;
				char = str.charAt(i); //文字列を一文字ずつ取り出す 
				
				color = Math.random() * 0xffffff + 0xff000000;
				lf = new Letter3DMaterial(color,Math.random()*1.0);
				lfarray[i] = lf;
				text = new Text3D(char,new HelveticaBold,lfarray[i]);
				text.x = 0;
				text.y = 0;
				text.z = Math.random() * 10;
				words[i] = text;
				
				scene.addChild(words[i]);
			}
            
            addEventListener(Event.ENTER_FRAME , rotationText);
            addEventListener(Event.ENTER_FRAME , onEnterFrame);
			
		}
		
		//文字を回転させる
		private function rotationText(evt:Event):void {
			var count:Number = 0;
			count++;
			
			for(var i:uint = 0; i< size; i++){
				words[i].rotationX +=Math.random()*5;
				words[i].rotationY +=Math.random()*5;
				
				
				if(words[i].scaleX < 1.5){
					words[i].scaleX +=0.003;
					words[i].scaleY +=0.003;
				}
				
			}
			
			renderer.renderScene(scene,camera,viewport);
		}
		
		private function onEnterFrame(evt:Event):void {
			for(var i:uint = 0; i< size; i++){
				
				//文字を動かす
				var vx:Number = Math.cos(i*(Math.PI*2/size)) * 10;
				var vy:Number = Math.sin(i*(Math.PI*2/size)) * 10;
				words[i].x +=vx;
				words[i].y +=vy;
				
				if(words[i].x < -w || words[i].x > w || words[i].y < -h || words[i].y > h){
					words[i].x =0;
					words[i].y =0;
				}
			}
		}
	}
}