/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mWeP
 */

package 
{
    import com.bit101.components.CheckBox;
    import com.bit101.components.HUISlider;
    import com.bit101.components.VBox;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.geom.Point;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    
    /**
     * 色の帯
     * ライフハッカー
     * http://www.lifehacker.jp/
     * の画面キャプチャで時たま出てくる壁紙が素敵だなと思ったので、それっぽいのを作ってみた。
     * 
     * Adobe kuler
     * http://kuler.adobe.com
     * から取得した色から帯を作る。
     * 一番明るい色が地の色。
     * クリックする度に、変わります。
     * 
     * 壁紙クリエイターとして、jpg/pngをダウンロードできるようにしても良いのかも。
     * 
     * @author umhr
     */
    public class UmhrKuler extends Sprite 
    {
        public var isBlur:CheckBox;
        private var _colorDataList:Array/*ColorData*/ = [];
        private var byteArray:ByteArray;
        private var image:Image;
        private var bitmapData:BitmapData;
        private var thresholdMakeImage:HUISlider;
        public function UmhrKuler() 
        {
            stage.scaleMode = "noScale";
            stage.align = "TL";
            init();
        }
        private function init():void 
        {
            if (stage) onInit();
            else addEventListener(Event.ADDED_TO_STAGE, onInit);
            var sp:Sprite = new Sprite();
            sp.graphics.beginFill(0xFF0000, 1);
            sp.graphics.drawRect(0, 0, 465, 465);
            sp.graphics.endFill();
            sp.filters = [new GlowFilter(0x000000, 0.5, 465 * 0.2, 465 * 0.2, 1, 4, true, true)];
            this.addChild(sp);
            bitmapData = new BitmapData(465, 465, true,0x00ffffff);
            addChild(new Bitmap(bitmapData));
            var vbox:VBox = new VBox(this, 0, 0);
            isBlur = new CheckBox(vbox, 0, 0, 'isBlur');
            isBlur.selected = true;
            thresholdMakeImage = new HUISlider(vbox, 0, 0, 'thresholdMakeImage');
            thresholdMakeImage.maximum = 1.4;
            thresholdMakeImage.value = 0.7;
        }
        
        private function onInit(event:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, onInit);
            // entry point
            
            var url:String = "http://kuler-api.adobe.com//feeds/rss/get.cfm?listType=popular&timeSpan=30";
            var load:URLLoader = new URLLoader(new URLRequest(url));
            load.addEventListener(Event.COMPLETE, onComplete);
        }
        
        private function onComplete(e:Event):void 
        {
            
            default xml namespace = new Namespace("http://kuler.adobe.com/kuler/API/rss/"); 
            var dataXML:XML = XML(e.target.data);
            var n:int = dataXML.channel.item.length();
            trace( "n : " + n );
            for (var i:int = 0; i < n; i++) 
            {
                var colorData:ColorData = new ColorData();
                colorData.themeTitle = dataXML.channel.item[i].themeItem.themeTitle;
                colorData.authorLabel = dataXML.channel.item[i].themeItem.themeAuthor.authorLabel;
                for (var j:int = 0; j < 5; j++) 
                {
                    colorData.addColor(dataXML.channel.item[i].themeItem.themeSwatches.swatch.swatchHexColor[j]);
                }
                colorData.sort();
                _colorDataList.push(colorData);
                
            }
            //trace(dataXML.channel.item[0].themeItem);
            stage.addEventListener(MouseEvent.CLICK, onClick);
            
            makeImage();
            //new Sound(new URLRequest('assets/realentada.mp3')).play();
            playSound('http://www.takasumi-nagai.com/soundfiles/01.mp3');
            addEventListener(Event.ENTER_FRAME, loop);
        }
        private function playSound(url:String):void
        {
            var snd:Sound = new Sound();
            var context:SoundLoaderContext = new SoundLoaderContext(0, true);
            var sndReq:URLRequest = new URLRequest(url);
            snd.addEventListener(Event.COMPLETE, function(e:Event):void { Sound(e.target).play(); } );
            snd.load(sndReq,context);
            
        }
        
        private function loop(e:Event):void 
        {
            var rf:Number;
            byteArray = new ByteArray;
            SoundMixer.computeSpectrum(byteArray, true);
            var frequencyIndex:Array= [6, 7, 8, 9, 10];
            var fl:uint = frequencyIndex.length;
            for (var i:int = 0; i < fl; i++) 
            {
                var i1:int = frequencyIndex[i];
                byteArray.position = i1 * 4;
                rf = byteArray.readFloat();
                image.setSize(i, rf);
            }
            byteArray.position = 0;
            bitmapData.draw(image);
            bitmapData.scroll(byteArray.readFloat()*6, 0);
            if (isBlur.selected) bitmapData.applyFilter(bitmapData, bitmapData.rect, new Point, new BlurFilter(1.05, 1.05, 2));
            byteArray.position = 11 * 4;
            if (byteArray.readFloat() > thresholdMakeImage.value) makeImage();
        }
        
        private function onClick(e:MouseEvent):void 
        {
            makeImage();
        }
        
        public function makeImage():void {
            //while (this.numChildren > 0) {
                //this.removeChildAt(0);
            //}
            if (image) 
            {
                removeChild(image);
            }
            var select:int = Math.floor(Math.random() * _colorDataList.length);
            trace( "_colorDataList.length : " + _colorDataList.length );
            var colorData:ColorData = _colorDataList[select];
            image = new Image(stage.stageWidth, stage.stageHeight, colorData.list);
            this.addChild(image);
            trace( "colorData.list : " + colorData.list );
            
            
            //this.addChild(new NameLabel(colorData.themeTitle, colorData.authorLabel));
        }
    }
}

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;
import org.libspark.betweenas3.BetweenAS3;
class NameLabel extends Sprite {
    private var _title:TextField = new TextField();
    public function NameLabel(themeTitle:String, authorLabel:String) {
        var text:String = "";
        text += "" + themeTitle + "\n";
        text += "by " + authorLabel;
        _title.defaultTextFormat = new TextFormat("_sans", 12, 0xFFFFFF);
        _title.width = 400;
        _title.wordWrap = true;
        _title.selectable = false;
        _title.multiline = true;
        _title.autoSize = "left";
        _title.text = text;
        _title.width = _title.textWidth+8;
        this.addChild(_title);
        
        this.graphics.beginFill(0x000000, 0.5);
        this.graphics.drawRoundRect(0, 0, _title.width, _title.height, 8, 8);
        this.graphics.endFill();        
        
        BetweenAS3.delay(BetweenAS3.tween(this, { alpha:0 }, null, 3 ), 5).play();
    }
    
}

class ColorData {
    /**
     * タイトル
     */
    public var themeTitle:String;
    /**
     * 作者
     */
    public var authorLabel:String;
    public var list:Array = [];
    public var tempList:Array = [];
    private var brightnessList:Array = [];
    
    public function ColorData() {
        
    }
    public function addColor(rgb:String):void {
        tempList.push(int("0x" + rgb));
        
        //trace(rgb,rgb.substr(0, 2),rgb.substr(2, 2),rgb.substr(4, 2))
        
        var r:int = int("0x" + rgb.substr(0, 2));
        var g:int = int("0x" + rgb.substr(2, 2));
        var b:int = int("0x" + rgb.substr(4, 2));
        brightnessList.push(r + g + b);
    }
    public function sort():void {
        var sortedList:Array = brightnessList.sort(Array.RETURNINDEXEDARRAY,Array.NUMERIC);
        sortedList.reverse();
        var first:int = sortedList[0];
        list.push(tempList[first]);
        
        for (var i:int = 0; i < 5; i++) 
        {
            var j:int = sortedList[i];
            if (i == first) {
                continue;
            }
            list.push(tempList[i]);
            
        }
        
    }
    
}



import flash.display.Shape;
import flash.display.Sprite;
import flash.filters.GlowFilter;

class Image extends Sprite {
    private var shapes:Array;
    public function Image(width:int, height:int, colorList:Array) {
        init(width, height, colorList);
    }
    
    public function setSize(i:int, rf:Number):void 
    {
        var shape:Shape = shapes[i] as Shape;
        shape.scaleY = rf;
    }
    private function init(width:int, height:int, colorList:Array):void {
        
        //this.graphics.beginFill(colorList[0], 1);
        //this.graphics.drawRect(0, 0, width, height);
        //this.graphics.endFill();
        
        var w:Number = Math.sqrt(width * width + height * height);
        var h:Number = w * 0.06;
        h = 30;
        
        var anchor:Sprite = new Sprite();
        anchor.x = 0;
        anchor.y = height * 0.5-20;
        //anchor.rotation = int(36 * Math.random()) * 10;
        this.addChild(anchor);
        
        var n:int = colorList.length;
        shapes = [];
        for (var i:int = 0; i < n; i++) 
        {
            //trace( "i : " + i );
            //var j:int = i - 1;
            var shape:Shape = new Shape();
            shape.graphics.beginFill(colorList[i ], 1);
            var size:Number = 40;
            shape.graphics.drawRect( 10, 0, size, size);
            shape.y = i*h
            shape.graphics.endFill();
            anchor.addChild(shape);
            //shape.scaleY = 0.4;
            shapes.push(shape);
            
        }
        

        
    }
    
}