/**
 * Copyright munegon ( http://wonderfl.net/user/munegon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mWUM
 */

// forked from beinteractive's Sample of LCDBitmap
// Demo of LCDBitmap
// http://www.libspark.org/wiki/LCDBitmap/en
//
// Based on Saburin's code
// http://blog.jactionscripters.com/2009/05/18/study-recreating-lcd-panels-trinitron-like-matrices/
package
{
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.media.Camera;
	import flash.media.Video;
	
        import net.hires.debug.Stats;
        
	[SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 30)]
	public class VideoSample extends Sprite
	{
		private static const SOURCE_VIDEO_WIDTH:uint = 60;
		private static const SOURCE_VIDEO_HEIGHT:uint = 45;
		
                private var _lcd:LCDBitmap;

		public function VideoSample()
		{
			setupStage();
			if (setupVideo()) {
				setupLCDBitmap();
                                //addChild( new Stats() );
			}
		}
		
		private var _video:Video;
		private var _videoBitmapData:BitmapData;
		
		private function setupStage():void
		{
			Wonderfl.capture_delay(10);
			stage.quality = StageQuality.LOW;
		}
		
		private function setupVideo():Boolean
		{
			var camera:Camera = Camera.getCamera();
			if (camera == null) {
				return false;
			}
			_video = new Video(SOURCE_VIDEO_WIDTH, SOURCE_VIDEO_HEIGHT);
			_video.attachCamera(camera);
			_videoBitmapData = new BitmapData(_video.width, _video.height, false, 0x000000);
			addEventListener(Event.ENTER_FRAME, videoEnterFrameHandler);
			return true;
		}
		
		private function videoEnterFrameHandler(e:Event):void
		{
//			_videoBitmapData.fillRect(_videoBitmapData.rect, 0x000000);
//			_videoBitmapData.draw(_video);
                        _lcd.draw( _video );
		}
		
		private function setupLCDBitmap():void
		{
			_lcd = new LCDBitmap(_videoBitmapData);
			_lcd.x = Math.floor((stage.stageWidth - _lcd.width) / 2);
			_lcd.y = Math.floor((stage.stageHeight - _lcd.height) / 2);
			addChild(_lcd);
		}
	}
}

/*
 * LCDBitmap
 * 
 * Licensed under the MIT License
 * 
 * Copyright (c) 2009 Jin Saburi (metalred.com),
 *                    BeInteractive! (www.be-interactive.org) and
 *                    Spark project  (www.libspark.org)
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 */

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.BlendMode;
import flash.display.IBitmapDrawable;
import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Matrix;
import flash.geom.Rectangle;

/**
 * Display the BitmapData like a LCD display.
 *
 * This is a class of <a href="http://blog.jactionscripters.com/2009/05/18/study-recreating-lcd-panels-trinitron-like-matrices/">
 * Jin Saburi's effect</a>.
 *
 * @see http://blog.jactionscripters.com/2009/05/18/study-recreating-lcd-panels-trinitron-like-matrices/
 */
class LCDBitmap extends Bitmap
{
	/**
	 * Create a new instance of the LCDBitmap.
	 *
	 * @param	bitmapData	an instance of BitmapData you need to display.
	 * @param	tileSize	size of tile displays RGB color.
	 * @param	tileMargin	margin of each tiles
	 * @param	pixelSnapping	same as Bitmap class.
	 * @param	smoothing	same as Bitmap class.
	 */
	public function LCDBitmap(bitmapData:BitmapData, tileSize:uint = 3, tileMargin:uint = 1, pixelSnapping:String = 'auto', smoothing:Boolean = false)
	{
		_sourceBitmapData = bitmapData;
		_lcdBitmapData = new BitmapData(bitmapData.width * ((tileSize + tileMargin) * 3), bitmapData.height * ((tileSize + tileMargin) * 3), true, 0x00000000);
                _patternBitmapData = new BitmapData( 4 * ( tileSize * tileMargin ), 4 * ( tileSize * tileMargin ), false, 0x000000 );
                _patternSprite = new Sprite();
                _baseBitmapData = _lcdBitmapData.clone();
                
		super(_lcdBitmapData, pixelSnapping, smoothing);
		trace(_lcdBitmapData.width, _lcdBitmapData.height);
		_tileSize = tileSize;
		_tileMargin = tileMargin;
		_tile = new Rectangle(0, 0, _tileSize, _tileSize);

                setupPattern();
//		addEventListener(Event.ENTER_FRAME, renderHandler);
	}
	
	private var _sourceBitmapData:BitmapData;
	private var _lcdBitmapData:BitmapData;
        private var _baseBitmapData:BitmapData;
        private var _patternBitmapData:BitmapData;
        private var _patternSprite:Sprite;
	private var _tileSize:uint;
	private var _tileMargin:uint;
	private var _tile:Rectangle;

        private function setupPattern():void {
		var tsize:uint = _tileSize + _tileMargin;

		_patternBitmapData .fillRect( _tile, 0xff0000 );
		_tile.x = tsize;
		_patternBitmapData .fillRect( _tile, 0x00ff00 );
		_tile.x = tsize * 2;
		_patternBitmapData .fillRect( _tile, 0x0000ff );
		
		_tile.x = _tileMargin;
		_tile.y = tsize;
		_patternBitmapData .fillRect( _tile, 0x0000ff );
		_tile.x = _tileMargin + tsize;
		_patternBitmapData .fillRect( _tile, 0xff0000 );
		_tile.x = _tileMargin + tsize * 2;
		_patternBitmapData .fillRect( _tile, 0x00ff00 );
		_tile.x = _tileMargin- tsize;
		_patternBitmapData .fillRect( _tile, 0x00ff00 );
		
		_tile.x = _tileMargin* 2;
		_tile.y = tsize * 2;
		_patternBitmapData .fillRect( _tile, 0x00ff00 );
		_tile.x = _tileMargin* 2 + tsize;
		_patternBitmapData .fillRect( _tile, 0x0000ff );
		_tile.x = _tileMargin* 2 + tsize * 2;
		_patternBitmapData .fillRect( _tile, 0xff0000 );
		_tile.x = _tileMargin* 2 - tsize;
		_patternBitmapData .fillRect( _tile, 0xff0000 );
                
                
                _patternSprite.graphics.beginBitmapFill( _patternBitmapData );
                _patternSprite.graphics.drawRect( 0, 0, _lcdBitmapData.width, _lcdBitmapData.height );
                _patternSprite.graphics.endFill();
                
                _baseBitmapData.draw( _patternSprite );
        }
	
	public function draw(source:IBitmapDrawable):void
	{
                var scale:uint = 3 * ( _tileSize + _tileMargin );
		var bitmap:BitmapData = _lcdBitmapData;
		bitmap.lock();
                bitmap.copyPixels( _baseBitmapData, _baseBitmapData.rect, _baseBitmapData.rect.topLeft );
                bitmap.draw( source, new Matrix( scale, 0, 0, scale ), null, BlendMode.MULTIPLY );
		bitmap.unlock();
	}
}